/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.base.client.editor;

import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardTemplateItem;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.ClaimItem;


/**
 * @author Alexander Yuhimenko
 * 
 */
public class EditorBuilder {

	public static BaseEditor buildByClaimItem(ClaimItem claimItem) {
		//----remove this as soon as possible :(
		//BaseEditor editor = getEditorByClaim(claimItem.getValueType());
		
		if (claimItem.getName().indexOf("Date")!=-1) {
			BaseEditor editor = new DateEditor();
			editor.setClaimType(claimItem.getClaimType());
			editor.setValue(claimItem.getValue());
			editor.setOldValue(new String(claimItem.getValue()));
			editor.setName(claimItem.getName());
			editor.setDescription(claimItem.getDescription());
			editor.setRequired(claimItem.isValueRequired());
			editor.setCheckValueRunTime(false);
			return editor;
		} 
		if (claimItem.getName().indexOf("Gender")!=-1) {
			BaseEditor editor = new ComboBoxEditor();
			editor.setClaimType(claimItem.getClaimType());
			editor.setValue(claimItem.getValue());
			editor.setOldValue(new String(claimItem.getValue()));
			editor.setName(claimItem.getName());
			editor.setDescription(claimItem.getDescription());
			editor.setRequired(claimItem.isValueRequired());
			editor.setCheckValueRunTime(false);
			return editor;
		}
		BaseEditor editor = getEditorByClaim(claimItem.getValueType());
		
		editor.setClaimType(claimItem.getClaimType());
		editor.setValue(claimItem.getValue());
		editor.setOldValue(new String(claimItem.getValue()));
		editor.setName(claimItem.getName());
		editor.setDescription(claimItem.getDescription());
		editor.setRequired(claimItem.isValueRequired());
		editor.setCheckValueRunTime(false);
		editor.setVisible(claimItem.isVisible());
		return editor;
	};

	public static BaseEditor buildByCardTemplateItem(CardTemplateItem cardTemplateItem) {
		BaseEditor editor = buildByClaimItem(cardTemplateItem);
		// editor.setInputRegExp(cardTemplateItem.getInputMask());
		editor.setInputRegExp(cardTemplateItem.getPattern());
		editor.setCheckValueRunTime(editor.getInputRegExp() != null);
		return editor;
	};

	private static BaseEditor getEditor(final String editorType) {
		if (BaseEditor.TEXT_BOX_EDITOR.equalsIgnoreCase(editorType)) {
			return new TextBoxEditor();
		} else if (BaseEditor.IMAGE_EDITOR.equalsIgnoreCase(editorType)) {
			return new ImageEditor();
		} else if (BaseEditor.TEXT_AREA_EDITOR.equalsIgnoreCase(editorType)) {
			return new TextBoxEditor();
		} else if (BaseEditor.COMBO_BOX_EDITOR.equalsIgnoreCase(editorType)) {
			return new ComboBoxEditor();
		} else if (BaseEditor.DATE_TEXT_BOX_EDITOR.equalsIgnoreCase(editorType)) {
			return new DateEditor();
		} else {
			return new TextBoxEditor();
		}
	}

	private static BaseEditor getEditorByClaim(final int type) {
		if (type == 0) {
			return getEditor(BaseEditor.TEXT_BOX_EDITOR);
		} else if (type == 1) {
			return getEditor(BaseEditor.TEXT_BOX_EDITOR);
		} else if (type == 2) {
			return getEditor(BaseEditor.IMAGE_EDITOR);
		} else if (type == 3) {
			return getEditor(BaseEditor.COMBO_BOX_EDITOR);
		} else {
			return getEditor(BaseEditor.TEXT_BOX_EDITOR);
		}
	}

}
