/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Alexander Yuhimenko - implementation
 */

package org.eclipse.higgins.ics.gwt.icm.client;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

import org.eclipse.higgins.ics.gwt.base.client.listener.ChangeUserProfileListener;
import org.eclipse.higgins.ics.gwt.base.client.model.CurrentStateBean;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardTemplate;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CurrentState;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.GWTResponse;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.ListEntity;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.UserProfile;
import org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.panel.ICMMainPanel;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.Dictionary;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.RootPanel;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class ICMEntryPoint implements EntryPoint {

	private static final ArrayList changeUserProfileList = new ArrayList();

	public static Constant constant;

	public static CurrentStateBean currentState;

	public static Dictionary dictionary;

	public static ICMMainPanel mainPanel;

	private static CardTemplate pCardTemplate;

	public static ICMServiceAsync service;

	private static UserProfile userProfile;

	static {
		constant = (Constant) GWT.create(Constant.class);
		service = (ICMServiceAsync) GWT.create(ICMService.class);
		ServiceDefTarget endpoint = (ServiceDefTarget) service;
		endpoint.setServiceEntryPoint(Utils.getContextPath() + "icmmain.rpc");
		dictionary = Dictionary.getDictionary(constant.dictionary());
	}

	// private static ICMEntryPoint entryPoint;
	//
	// public static ICMEntryPoint getInstance() {
	// if (entryPoint == null) {
	// entryPoint = new ICMEntryPoint();
	// }
	// return ICMEntryPoint;
	// }

	/**
	 * @param changeUserProfileList
	 *            the changeUserProfileList to set
	 */
	public static void addChangeUserProfileList(ChangeUserProfileListener listener) {
		ICMEntryPoint.changeUserProfileList.add(listener);
	}

	/**
	 * @return the changeUserProfileList
	 */
	public static ArrayList getChangeUserProfileList() {
		return changeUserProfileList;
	}

	/**
	 * @return the pCardTemplate
	 */
	public static CardTemplate getPCardTemplate() {
		if (pCardTemplate == null) {
			service.getPCardTemplate(getUserProfile().getLoginName(), getUserProfile().getPassword(), new GWTCallBack() {

				/*
				 * (non-Javadoc)
				 * 
				 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
				 */
				public void onSuccess(Object res) {
					if (res instanceof GWTResponse) {
						GWTResponse response = (GWTResponse) res;
						if (response.getStatusCode().equals(new Integer(0))) {
							setPCardTemplate((CardTemplate) response.getResult());
						}
					}
				}
			});
			return null;
		}
		return pCardTemplate;
	}

	/**
	 * @return the userProfile
	 */
	public static UserProfile getUserProfile() {
		return userProfile;
	}

	/**
	 * @param cardTemplate
	 *            the pCardTemplate to set
	 */
	public static void setPCardTemplate(CardTemplate cardTemplate) {
		pCardTemplate = cardTemplate;
	}

	/**
	 * @param userProfile
	 *            the userProfile to set
	 */
	public static void setUserProfile(UserProfile userProfile) {
		ICMEntryPoint.userProfile = userProfile;
		for (Iterator iterator = ICMEntryPoint.changeUserProfileList.iterator(); iterator.hasNext();) {
			ChangeUserProfileListener listener = (ChangeUserProfileListener) iterator.next();
			try {
				listener.onChangeUserProfile(ICMEntryPoint.userProfile);
			} catch (Exception e) {
			}
		}
	}

	public ICMEntryPoint() {

	}

	void getCurrentStatus() {
		service.getCurrentState(getUserProfile().getLoginName(), getUserProfile().getPassword(), new GWTCallBack() {
			// service.getCurrentState("Primat_Forever", "octobergoat", new GWTCallBack() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
			 */
			public void onSuccess(Object arg0) {
				Utils.hideWaiteDialog();
				if (arg0 instanceof GWTResponse) {
					GWTResponse response = (GWTResponse) arg0;
					if (response.getStatusCode().equals(new Integer(0))) {
						currentState = new CurrentStateBean((CurrentState) response.getResult());
						mainPanel = new ICMMainPanel();
						RootPanel.get().add(mainPanel);
						getMRU();
					} else {
						Utils.showErrorMessage(constant.messageErrorNumber() + response.getStatusCode());
					}
				} else {
					Utils.showErrorMessage(constant.messageSomeErrors());
				}
			}
		});

	}
	
	void getMRU() {
		service.getMRU(getUserProfile().getLoginName(), getUserProfile().getPassword(), new GWTCallBack() {
			public void onSuccess(Object arg0) {
				if (arg0 instanceof GWTResponse) {
					try {
						GWTResponse response = (GWTResponse) arg0;
						if (response.getStatusCode().equals(new Integer(0))) {
							HashSet set = new HashSet();
							set.addAll(((ListEntity)response.getResult()).getList());							
							currentState.setMrus(set);					
						} else {
							Utils.showErrorMessage(constant.messageErrorNumber() + response.getStatusCode());
						}
					} catch (Exception e) {
						// TODO Auto-generated catch block
						
					}
				} else {
					Utils.showErrorMessage(constant.messageSomeErrors());
				}
			}
		});
	}

	public void onModuleLoad() {
		Utils.showWaiteDialog(dictionary.get("ProcessingRequestLabel_HTML"));
		service.getUserProfile(new GWTCallBack() {
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
			 */
			public void onSuccess(Object res) {
				if (res instanceof GWTResponse) {
					GWTResponse response = (GWTResponse) res;
					if (response.getStatusCode().equals(new Integer(0))) {
						setUserProfile((UserProfile) response.getResult());
						String userName = getUserProfile().getFirstName()!=null?getUserProfile().getFirstName():"";
						String userLastName = getUserProfile().getLastName()!=null?getUserProfile().getLastName():"";
						Utils.waitPanel.setText(dictionary.get(constant.dnWelcomeText()) + " <b>" 
							//	+ userName + " "
							//	+ userLastName 
								+ "</b><br>"+dictionary.get("RetrievingCardsLabel_HTML"));
						getCurrentStatus();
						getPCardTemplate();
						
					} else {
						Utils.waitPanel
								.setText("<b>"+dictionary.get("ClickHBXLabel_HTML")+"</b>");
					}
				} else {
					// bed response
					Utils.waitPanel
							.setText("<b>"+dictionary.get("ClickHBXLabel_HTML")+"</b>");
				}
			}
		});
	}

}
