package org.eclipse.higgins.ics.gwt.icm.client.backup;

import java.util.List;

import org.eclipse.higgins.ics.gwt.base.client.model.entity.FormatDescriptor;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class ChooseTypeBackupPanel extends VerticalPanel implements BackupWizardPage{
	
	private VerticalPanel typesPanel = new VerticalPanel();
	
	private HorizontalPanel bodyPanel = new HorizontalPanel();
	
	private Label description = new Label("description");
	
	private Label typeDescription = new Label("Description fot selected format");
	
	private List typesList = null;
	
	private FormatDescriptor format = null;
	
	public ChooseTypeBackupPanel() {
		super();
		typeDescription.setStyleName("default");		
		setSpacing(10);
		//add(description);
		add(bodyPanel);
		typesPanel.setSpacing(5);
		typesPanel.setWidth("100px");
		typesPanel.setStyleName("backupWizardTypesPanel");
		bodyPanel.setSpacing(10);
		bodyPanel.add(typesPanel);
		bodyPanel.add(typeDescription);
	}
	
	public String getHeader() {
		return "Choose backup format";
	}
	
	public void drawTypesTable(List list) {
		typesList = list;
		for (int i=0; i<typesList.size(); i++) {
			final FormatDescriptor iformat = (FormatDescriptor)typesList.get(i);
			final Label label = new Label(iformat.getFileExtension());
			label.setStyleName("backupPanelTypesItem");
			label.addMouseListener(new MouseListener() {
				
				 public void onMouseEnter(Widget arg0) {
					 label.addStyleName("backupWizardItemPreSelected"); 
				}

				public void onMouseLeave(Widget arg0) {
					label.removeStyleName("backupWizardItemPreSelected");
				}
				
				public void onMouseMove(Widget arg0, int arg1, int arg2) {}				
				public void onMouseUp(Widget arg0, int arg1, int arg2) {}				
				public void onMouseDown(Widget arg0, int arg1, int arg2) {}
				
			});
			label.addClickListener(new ClickListener(){
				public void onClick(Widget arg) {
					resetAll();
					format = iformat;
					label.setStyleName("backupWizardItemSelected");
					typeDescription.setText(iformat.getName());
				}
			});
			label.setWidth("100%");
			typesPanel.add(label);
		}
		typesPanel.setHeight(typesPanel.getOffsetHeight()+15+"px");
	}
	
	private void resetAll() {
		for (int i=0; i<typesPanel.getWidgetCount(); i++) {
			typesPanel.getWidget(i).removeStyleName("backupWizardItemSelected");
		}
	}

	public FormatDescriptor getFormat() {
		return format;
	}

	public void setFormat(FormatDescriptor format) {
		this.format = format;
	}

	public List getTypesList() {
		return typesList;
	}

	public void setTypesList(List typesList) {
		this.typesList = typesList;
	}
}
