package org.eclipse.higgins.ics.gwt.icm.client.backup;

import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardCredential;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;
import org.eclipse.higgins.ics.gwt.icm.client.panel.cardcredential.CardCredentialEditor;
import org.eclipse.higgins.ics.gwt.icm.client.panel.cardcredential.PinCredentialPanel;

import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.VerticalPanel;

public class PasswordBackupPanel extends VerticalPanel implements BackupWizardPage{
	
	private PinCredentialPanel pinPanel1;

	private PinCredentialPanel pinPanel2;
	
	public PasswordBackupPanel(CardCredential credential) {
		super();
		setSpacing(10);
		addCredential(credential);				
	}
	
	private void addCredential(CardCredential cardCredential) {
		if (cardCredential != null) {
			if (CardCredentialEditor.PASSWORD_CRIDENTIAL_TYPE.equals(cardCredential.getType())) {
				this.pinPanel1 = new PinCredentialPanel(cardCredential);
				add(this.pinPanel1);
				this.pinPanel2 = new PinCredentialPanel(cardCredential, ICMEntryPoint.dictionary.get("RetypeLabel_HTML")
						+ this.pinPanel1.getPinLabel());
				add(this.pinPanel2);
			} else {
				add(new HTML("Unsupported credential type" + cardCredential.getType()));
			}
		}
	}
	
	public String getHeader() {
		return "Type a password";
	}
	
	public String getCredentialText0() {
		return this.pinPanel1.getPinTextBox().getText();
	}
	
	public CardCredential getCredential() {
		return this.pinPanel1.getCardCredential();
	}
	
	public String getCredentialText1() {
		return this.pinPanel2.getPinTextBox().getText();
	}
}
