/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel;

import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.panel.card.CardPanel;
import org.eclipse.higgins.ics.gwt.icm.client.tree.CategoryTree;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.WindowResizeListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.HorizontalSplitPanel;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class ICMMainPanel extends Composite implements WindowResizeListener {

	private DockPanel layoutPanel = new DockPanel();

	private TopPanel topPanel = new TopPanel();

	private HorizontalSplitPanel splitPanel = new HorizontalSplitPanel();

	private CategoryTree categoryTree;

	private CardPanel cardPanel;// = new CardPanel();

	// private VerticalPanel rightPanel = new VerticalPanel();

	private static ICMMainPanel instance = null;

	public static ICMMainPanel getInstance() {
		if (instance == null) {
			instance = new ICMMainPanel();
		}
		return instance;
	}

	/**
	 * 
	 */
	public ICMMainPanel() {
		this.layoutPanel.setWidth("100%");
		this.layoutPanel.setHeight("100%");
		this.splitPanel.setSize("100%", Utils.rootHeight - 65 + "px");
		this.splitPanel.setSplitPosition("270px");
		// this.splitPanel.setSplitPosition("270px");

		this.layoutPanel.add(this.topPanel, DockPanel.NORTH);
		this.layoutPanel.add(this.splitPanel, DockPanel.CENTER);
		Window.addWindowResizeListener(this);
		setCardPanel(new CardPanel());
		this.categoryTree = new CategoryTree();
		this.splitPanel.setLeftWidget(this.categoryTree);
		this.categoryTree.setPixelSize(250, Utils.rootHeight - 100);

		initWidget(this.layoutPanel);
		onWindowResized(Utils.rootWidth, Utils.rootHeight);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.google.gwt.user.client.WindowResizeListener#onWindowResized(int, int)
	 */
	public void onWindowResized(int arg0, int arg1) {
		try {
			// Utils.recalculateSize();
			try {
				arg1 = Utils.parseInt(Utils.getWindowHeight(), Window.getClientHeight());
			} catch (Exception e) {
				arg1 = Window.getClientHeight();
			}

			Utils.setPixelSize(arg0, arg1);

			this.topPanel.setWidth("100%");

			if (this.topPanel.getOffsetHeight()>0){
				this.splitPanel.setSize("100%", arg1 - this.topPanel.getOffsetHeight() + "px");
			}else{
				this.splitPanel.setSize("100%", arg1 - 75 + "px");
			}
			this.splitPanel.setSplitPosition("270px");

			if (this.splitPanel.getOffsetHeight()>0){
				this.cardPanel.setPixelSize(arg0 - 300, this.splitPanel.getOffsetHeight()-25);
				this.categoryTree.setPixelSize(250, this.splitPanel.getOffsetHeight()-25);
			}else {
				this.cardPanel.setPixelSize(arg0 - 300, arg1 - 110);
				this.categoryTree.setPixelSize(250, arg1 - 110);
				
			}
			
		} catch (Exception e) {
		}
	}

	/**
	 * @return the cardPanel
	 */
	public CardPanel getCardPanel() {
		return this.cardPanel;
	}

	/**
	 * @param cardPanel
	 *            the cardPanel to set
	 */
	public void setCardPanel(CardPanel cardPanel) {
		this.splitPanel.remove(this.cardPanel);
		this.cardPanel = cardPanel;
		this.cardPanel.setPixelSize(Utils.rootWidth - 315, Utils.rootHeight - 85);
		this.splitPanel.setRightWidget(this.cardPanel);
		// this.cardPanel.getLayoutPanel().setSize("100%", Utils.rootHeight - 80 + "px");
		// Window.alert("" + this.splitPanel.getRightWidget().getOffsetWidth());
	}

	/**
	 * @return the categoryTree
	 */
	public CategoryTree getCategoryTree() {
		return this.categoryTree;
	}

}
