package org.eclipse.higgins.ics.gwt.icm.client.panel;

import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FormSubmitCompleteEvent;
import com.google.gwt.user.client.ui.FormSubmitEvent;

public class ImportCardPanel extends ImportFilePanel {
	
	public ImportCardPanel(String actionUrl, String fileMask) {
		super(actionUrl, fileMask);
	}

	public void onSubmit(FormSubmitEvent event) {
		if (getUpload().getFilename() != null
				&& (getUpload().getFilename().toLowerCase().endsWith(getFileMask()[0]))) {
			Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("ImportingLabel_HTML"));
		} else {
			event.setCancelled(true);
			Utils.showErrorMessage("<b>*."+getFileMask()+"</b>"+ICMEntryPoint.dictionary.get("FileSupportMessage_HTML"));
		}
	}

	public void onSubmitComplete(FormSubmitCompleteEvent event) {
		ICMEntryPoint.service.getImportedCard(new AsyncCallback() {
			public void onFailure(Throwable arg0) {
				Utils.showErrorMessage(ICMEntryPoint.dictionary.get("CannotImportErrorMessage_HTML"));
			};

			public void onSuccess(Object arg) {
				Card[] cards = (Card[]) arg;
				for (int i = 0; i < cards.length; i++)
					ICMEntryPoint.currentState.addNewCard(cards[i]);
			};
		});
	}

}
