package org.eclipse.higgins.ics.gwt.icm.client.panel.cardcredential;

import java.util.ArrayList;

import org.eclipse.higgins.ics.gwt.base.client.button.CardActionButton;
import org.eclipse.higgins.ics.gwt.base.client.dialog.SimpleDialog;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardCredential;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.ErrorKeys;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.FormatDescriptor;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.GWTResponse;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.ListEntity;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class RestoreDataCredentialPanel extends Composite {
	
	private FormatDescriptor descriptor;
	
	private final VerticalPanel bodyPanel = new VerticalPanel();

	private DialogBox dialogBox;

	private final CardActionButton retrieveButton = new CardActionButton(ICMEntryPoint.dictionary.get("RetrieveButton_HTML"), new ClickListener() {

		/*
		 * (non-Javadoc)
		 * 
		 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
		 */
		public void onClick(Widget arg0) {
			Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("RetrievingClaimValueLabel_HTML"));
			ICMEntryPoint.service.putCredentialForRestore(getFormatDescriptor(), ICMEntryPoint.getUserProfile().getLoginName(), ICMEntryPoint
					.getUserProfile().getPassword(), new AsyncCallback() {
				/*
				 * (non-Javadoc)
				 * 
				 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onFailure(java.lang.Throwable)
				 */
				public void onFailure(Throwable arg0) {
					Utils.hideWaiteDialog();
					Utils.showErrorMessage("Network Error");
				}

				/*
				 * (non-Javadoc)
				 * 
				 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
				 */
				public void onSuccess(Object res) {
					Utils.hideWaiteDialog();
					if (res instanceof GWTResponse) {
						GWTResponse response = (GWTResponse) res;
						if (new Integer(0).equals(response.getStatusCode())) {
							ArrayList cards = (ArrayList)((ListEntity) response.getResult()).getList();
							getDialogBox().hide();
							VerticalPanel vPanel = new VerticalPanel();
							VerticalPanel vNotPanel = new VerticalPanel();
							VerticalPanel vAllPanel = new VerticalPanel();
							vAllPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
							vPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
							vNotPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
							for (int i = 0; i < cards.size(); i++)
								{boolean exists = ICMEntryPoint.currentState.addNewCard((Card)cards.get(i), false);
								if (exists) vNotPanel.add(new HTML("<b>" + ((Card)cards.get(i)).getName() + "</b>"));
								else vPanel.add(new HTML("<b>" + ((Card)cards.get(i)).getName() + "</b>"));}
							vPanel.add(new HTML(" <br>"));
							vNotPanel.add(new HTML(" <br>"));
							vAllPanel.add(new HTML("These cards were restored:"));
							vAllPanel.add(new HTML(" <br>"));
							vAllPanel.add(vPanel);
							
							vAllPanel.add(new HTML("These cards were not restored as they are already exists:"));
							vAllPanel.add(new HTML(" <br>"));
							vAllPanel.add(vNotPanel);
							
							SimpleDialog dialog = new SimpleDialog(vAllPanel);
							
							dialog.getCancelButton().setText("Close");
							dialog.showDialog();
						} else if (ErrorKeys.ERROR_CODE_RemoteException.equals(response.getStatusCode())) {
							String errorDescr = ICMEntryPoint.dictionary.get("IncorrectPasswordErrorLabel_HTML");
							((SimpleDialog)getDialogBox()).setText(errorDescr);
							
						} else {
							getDialogBox().hide();
							String errorDescr = ICMEntryPoint.dictionary.get("ErrorRetrievingClaimsLabel_HTML")+ICMEntryPoint.dictionary.get("TryAgainLabel_HTML");
							Utils.showErrorMessage(errorDescr);							
						}
					}
				}
			});
		}
	});
	
	public RestoreDataCredentialPanel(FormatDescriptor descriptor) {
		initWidget(this.bodyPanel);
		this.descriptor = descriptor;
		addCredential(descriptor.getCardCredential());
				
	}
	
	private void addCredential(CardCredential cardCredential) {
		if (cardCredential != null) {
			if (CardCredentialEditor.PASSWORD_CRIDENTIAL_TYPE.equals(cardCredential.getType())) {
				this.bodyPanel.add(new PinCredentialPanel(cardCredential));
			} else {
				this.bodyPanel.add(new HTML("Unsupported credential type" + cardCredential.getType()));
			}
		}
	}

	/**
	 * @return the card
	 */
	public FormatDescriptor getFormatDescriptor() {
		Widget w = bodyPanel.getWidget(0);
			if (w instanceof CardCredentialEditor) {
				CardCredential cardCredential = ((CardCredentialEditor) w).getCardCredential();
				descriptor.setCardCredential(cardCredential);
			}
		
		return descriptor;
	}
	
	/**
	 * @return the dialogBox
	 */
	public DialogBox getDialogBox() {
		return this.dialogBox;
	}

	/**
	 * @param dialogBox
	 *            the dialogBox to set
	 */
	public void setDialogBox(DialogBox dialogBox) {
		this.dialogBox = dialogBox;
	}

	/**
	 * @return the retrieveButton
	 */
	public CardActionButton getRetrieveButton() {
		return this.retrieveButton;
	}

	public void setFocus(boolean focused) {
		try {
			((CardCredentialEditor) bodyPanel.getWidget(0)).setFocus(focused);
		} catch (RuntimeException e) {
		}
	}
	
	public void showDialog() {
		if (this.dialogBox instanceof SimpleDialog)
				((SimpleDialog)dialogBox).showDialog();
			else
				dialogBox.show();
	}

}
