package org.eclipse.higgins.ics.gwt.icm.client.panel.cardcredential;

import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardCredential;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.VerticalPanel;

public class SelfIssuedCredentialPanel extends Composite implements
		CardCredentialEditor {

	private CardCredential cardCredential;

	private VerticalPanel bodyPanel = new VerticalPanel();
	private PasswordTextBox pinTextBox = new PasswordTextBox();
	private HTML pinLabel = new HTML();
	
	public SelfIssuedCredentialPanel(CardCredential cardCredential) 
	{
		this(cardCredential, ICMEntryPoint.dictionary.get("PinCodeLabel_HTML"));
	}
	/**
	 * 
	 */
	public SelfIssuedCredentialPanel(CardCredential cardCredential, String labelText) {
		if (cardCredential != null && CardCredentialEditor.SELFISSUED_CRIDENTIAL_TYPE.equals(cardCredential.getType())) {
			this.pinLabel.setStyleName("cardCredentialLabel");
			this.pinLabel.setHTML(labelText);
			this.cardCredential = cardCredential;
			this.bodyPanel.add(this.pinLabel);
			this.bodyPanel.add(this.pinTextBox);
			this.pinTextBox.setText(cardCredential.getPinCode());
		}
		initWidget(this.bodyPanel);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.icm.client.panel.cardcredential.CardCredentialEditor#setCardCredential(org.eclipse.higgins.ics.gwt.icm.client.panel.cardcredential.CardCredentialEditor)
	 */
	public CardCredential getCardCredential() {
		if (this.cardCredential != null) {
			if (CardCredentialEditor.SELFISSUED_CRIDENTIAL_TYPE.equals(this.cardCredential.getType())) {
				this.cardCredential.setPinCode(getPinTextBox().getText());
			}
		}
		return this.cardCredential;
	}

	/**
	 * @return the pinTextBox
	 */
	public PasswordTextBox getPinTextBox() {
		return this.pinTextBox;
	}

	/**
	 * @param focused
	 * @see com.google.gwt.user.client.ui.FocusWidget#setFocus(boolean)
	 */
	public void setFocus(boolean focused) {
		this.pinTextBox.setFocus(focused);
	}
	
	public String getPinLabel()
	{
		return this.pinLabel.getHTML();
	}
	
	public void setPinLabel(String html)
	{
		this.pinLabel.setHTML(html);
	}

}
