/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel.category;

import org.eclipse.higgins.ics.gwt.base.client.button.MenuItemMouseListener;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Category;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;
import org.eclipse.higgins.ics.gwt.icm.client.RPCUtils;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.MouseWheelListener;
import com.google.gwt.user.client.ui.SourcesMouseEvents;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class CategoryPanelItem extends HorizontalPanel implements SourcesMouseEvents {
	final Category category;
	private final HTML label;


	/**
	 * 
	 */
	public CategoryPanelItem(final Category category) {
		super();
		this.category = category;
		setStyleName("categoryItemPanel");

		final Image imgDelete = new Image(Utils.getContextPath() + "images/categoryDelete.gif");
		imgDelete.addClickListener(new ClickListener() {
			public void onClick(final Widget arg0) {
				RPCUtils.deleteCategory(CategoryPanelItem.this.category);
			}
		});
		imgDelete.addMouseListener(new MenuItemMouseListener());
		imgDelete.setTitle("Delete");

		final Image imgEdit = new Image(Utils.getContextPath() + "images/categoryEdit.gif");
		imgEdit.addClickListener(new ClickListener() {
			public void onClick(final Widget arg0) {
				RPCUtils.modifyCategory(CategoryPanelItem.this.category);
			}
		});
		imgEdit.addMouseListener(new MenuItemMouseListener());
		imgEdit.setTitle(ICMEntryPoint.dictionary.get("DetailsEditCardButton_HTML"));	
		this.label = new HTML(category.getName());
		label.setStyleName("categoryItemLabel");
		label.setWidth("250px");
		setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
		setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		setSpacing(4);
		add(label);
		if (!category.isPreDefined()) {
			add(imgEdit);
			add(imgDelete);
		}
		setTitle(ICMEntryPoint.dictionary.get("DNDToReorderCategoriesLabel_HTML"));
	}
	/**
	 * @param listener
	 * @see com.google.gwt.user.client.ui.Label#addMouseListener(com.google.gwt.user.client.ui.MouseListener)
	 */
	public void addMouseListener(final MouseListener listener) {
		this.label.addMouseListener(listener);
	}

	/**
	 * @param listener
	 * @see com.google.gwt.user.client.ui.Label#addMouseWheelListener(com.google.gwt.user.client.ui.MouseWheelListener)
	 */
	public void addMouseWheelListener(final MouseWheelListener listener) {
		this.label.addMouseWheelListener(listener);
	}

	/**
	 * @return the category
	 */
	public Category getCategory() {
		return this.category;
	}

	/**
	 * @return the label
	 */
	public Label getLabel() {
		return this.label;
	}

	/**
	 * @param listener
	 * @see com.google.gwt.user.client.ui.Label#removeMouseListener(com.google.gwt.user.client.ui.MouseListener)
	 */
	public void removeMouseListener(final MouseListener listener) {
		this.label.removeMouseListener(listener);
	}

	/**
	 * @param listener
	 * @see com.google.gwt.user.client.ui.Label#removeMouseWheelListener(com.google.gwt.user.client.ui.MouseWheelListener)
	 */
	public void removeMouseWheelListener(final MouseWheelListener listener) {
		this.label.removeMouseWheelListener(listener);
	}

}
