package org.eclipse.higgins.ics.gwt.icm.client.panel.category.dnd;

import com.allen_sauer.gwt.dnd.client.DragEndEvent;
import com.allen_sauer.gwt.dnd.client.DragHandler;
import com.allen_sauer.gwt.dnd.client.DragStartEvent;
import com.allen_sauer.gwt.dnd.client.VetoDragException;
import com.google.gwt.user.client.ui.HTML;

public class TableDragHandler implements DragHandler {
	  private static final String BLUE = "#4444BB";
	  private static final String GREEN = "#44BB44";
	  private static final String RED = "#BB4444";

	  private final HTML eventTextArea;

	  public TableDragHandler(HTML dragHandlerHTML) {
	    eventTextArea = dragHandlerHTML;
	  }

	  public void onDragEnd(DragEndEvent event) {
	    log("onDragEnd: " + event, RED);
	  }

	  public void onDragStart(DragStartEvent event) {
	    log("onDragStart: " + event, GREEN);
	  }

	  public void onPreviewDragEnd(DragEndEvent event) throws VetoDragException {
	    log("<br>onPreviewDragEnd: " + event, BLUE);
	  }

	  public void onPreviewDragStart(DragStartEvent event) throws VetoDragException {
	    clear();
	    log("onPreviewDragStart: " + event, BLUE);
	  }

	  private void clear() {
	    eventTextArea.setHTML("");
	  }

	  private void log(String text, String color) {
	    eventTextArea.setHTML(eventTextArea.getHTML() + (eventTextArea.getHTML().length() == 0 ? "" : "<br>") + "<span style='color:"
	        + color + "'>" + text + "</span>");
	  }
}
