package org.eclipse.higgins.ics.model.servlet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.eclipse.higgins.ics.model.bean.ManagerBean;

public class BackupCardsServlet extends HttpServlet implements Servlet {
	
	private ManagerBean bean = new ManagerBean();
	
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		String ext = request.getServletPath().substring(1, request.getServletPath().indexOf(".backup")).toString();
		response.setContentType("application/octet-stream");
		response.setHeader("Content-disposition", new String("attachment; filename=backup-"+ new SimpleDateFormat("yyyy-MMM-dd").format(new Date())+ext));
		response.setHeader("Pragma", "public, must-revalidate");
		response.setHeader("Cache-Control", "public, must-revalidate");
		try {
			byte[] file = bean.getFileFromSession(request.getSession());
			response.setContentLength(file.length);		
			int ln = 0;
			InputStream i = new ByteArrayInputStream(file);
			while ((ln = i.read(file)) > 0)
			response.getOutputStream().write(file, 0, ln);
			i.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doPost(request, response);
	}

}
