package org.eclipse.higgins.ics.model.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;

import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Response;
import org.eclipse.higgins.ics.model.bean.ManagerBean;

public class RestoreCardServlet extends HttpServlet implements Servlet {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 2392779498938689579L;

	public static final int MAX_UPLOAD_LENGTH = 1024 * 1024 * 10;
	
	private ManagerBean bean = new ManagerBean();
	
	public RestoreCardServlet() {
		super();
	}
	
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		HttpSession session = request.getSession(); 
		try {
			DiskFileItemFactory factory = new DiskFileItemFactory();
			// factory.setSizeThreshold(yourMaxMemorySize);
			// factory.setRepository(yourTempDirectory);
			String login = request.getParameter("ln");
			String password = request.getParameter("pw");	
			byte[] fileData = null;
			ServletFileUpload upload = new ServletFileUpload(factory);
			upload.setSizeMax(MAX_UPLOAD_LENGTH);
			List items = upload.parseRequest(request);
			for (int i=0; i<items.size(); i++) {
				FileItem item = (FileItem)items.get(i);
				if (!item.isFormField()) {
					long sizeInBytes = item.getSize();
					if (MAX_UPLOAD_LENGTH >= sizeInBytes) {
						InputStream uploadedStream = item.getInputStream();
						fileData = new byte[(int) sizeInBytes];
						uploadedStream.read(fileData);
						uploadedStream.close();
					}
				}
				else
				{
					InputStream uploadedStream = item.getInputStream();
					long sizeInBytes = item.getSize();
					byte[] data = new byte[(int) sizeInBytes];
					uploadedStream.read(data);
					if (item.getFieldName().equals("ln")) login = new String(data);
					if (item.getFieldName().equals("pw")) password = new String(data);
					uploadedStream.close();
				}
			}
			Response rppsResponse = bean.checkImportStream(login, password, fileData);
			session.setAttribute("restoredfile", fileData);
			session.setAttribute("forestore", rppsResponse.getResult());
			

		} catch (FileUploadException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
