/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.base.client.editor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

import org.eclipse.higgins.ics.gwt.base.client.listener.SaveValueListener;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.panel.CrossCardClaimEditorPanel;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.KeyboardListenerAdapter;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class TextBoxEditor extends BaseEditor {
	
	 SuggestBox box;
	 final Image image;
	 final MultiWordSuggestOracle oracle;
	 private KeyboardListener keyboardListener = new KeyboardListenerAdapter() {

	      public void onKeyDown(Widget sender, char keyCode, int modifiers) {
	        // Make sure that the menu is actually showing. These keystrokes
	        // are only relevant when choosing a suggestion.
	        if (suggestionPopup.isAttached()) {
	          switch (keyCode) {
	            case KeyboardListener.KEY_DOWN:
	              suggestionMenu.selectItem(suggestionMenu.getSelectedItemIndex() + 1);
	              break;
	            case KeyboardListener.KEY_UP:
	              suggestionMenu.selectItem(suggestionMenu.getSelectedItemIndex() - 1);
	              break;
	            case KeyboardListener.KEY_ENTER:
	            default:
	            	suggestionPopup.hide();
	            
	          }
	        }
	      }

	    };
	 
	 private final SuggestionMenu suggestionMenu = new SuggestionMenu(true);
	 private final SuggestionPopup suggestionPopup = new SuggestionPopup();
	  
	 
	 private class SuggestionMenu extends MenuBar {

		    public SuggestionMenu(boolean vertical) {
		      super(vertical);
		      // Make sure that CSS styles specified for the default Menu classes
		      // do not affect this menu
		      setStyleName("");
		    }

		    /*public void doSelectedItemAction() {
		      // In order to perform the action of the item that is currently
		      // selected, the menu must be showing.
		      MenuItem selectedItem = getSelectedItem();
		      if (selectedItem != null) {
		        doItemAction(selectedItem, true);
		      }
		    }*/

		    public int getNumItems() {
		      return getItems().size();
		    }

		    /**
		     * Returns the index of the menu item that is currently selected.
		     */
		    public int getSelectedItemIndex() {
		      // The index of the currently selected item can only be
		      // obtained if the menu is showing.
		      MenuItem selectedItem = getSelectedItem();
		      if (selectedItem != null) {
		        return getItems().indexOf(selectedItem);
		      }
		      return -1;
		    }
		    
		    public void addAll(Collection collection) {
		    	for (Iterator i = collection.iterator(); i.hasNext();) {
		    		final SuggestionMenuItem menuItem = new SuggestionMenuItem((String)i.next(), true);
		    		addItem(menuItem);
		    		menuItem.setCommand(new Command() {
		    	          public void execute() {
		    	            box.setText(menuItem.getSuggestion());
		    	            suggestionPopup.hide();
		    	          }
		    	    });
		    	}
		    }

		    /**
		     * Selects the item at the specified index in the menu. Selecting the item
		     * does not perform the item's associated action; it only changes the style
		     * of the item and updates the value of SuggestionMenu.selectedItem.
		     */
		    public void selectItem(int index) {
		      List items = getItems();
		      if (index > -1 && index < items.size()) {
		        //((SuggestionMenuItem) items.get(index))
		      }
		    }
		  }

		  /**
		   * Class for menu items in a SuggestionMenu. A SuggestionMenuItem differs
		   * from a MenuItem in that each item is backed by a Suggestion object.
		   * The text of each menu item is derived from the display string of a
		   * Suggestion object, and each item stores a reference to its Suggestion
		   * object.
		   */
		  private static class SuggestionMenuItem extends MenuItem {

		    private static final String STYLENAME_DEFAULT = "item";

		    private String suggestion;

		    public SuggestionMenuItem(String suggestion, boolean asHTML) {
		      super(suggestion, asHTML, (MenuBar)null);
		      // Each suggestion should be placed in a single row in the suggestion
		      // menu. If the window is resized and the suggestion cannot fit on a
		      // single row, it should be clipped (instead of wrapping around and
		      // taking up a second row).
		      DOM.setStyleAttribute(getElement(), "whiteSpace", "nowrap");
		      setStyleName(STYLENAME_DEFAULT);
		      setSuggestion(suggestion);
		    }

		    public String getSuggestion() {
		      return suggestion;
		    }

		    public void setSuggestion(String suggestion) {
		      this.suggestion = suggestion;
		    }
		  }

		  /**
		   * A PopupPanel with a SuggestionMenu as its widget. The SuggestionMenu is
		   * placed in a PopupPanel so that it can be displayed at various positions
		   * around the SuggestBox's text field. Moreover, the SuggestionMenu
		   * needs to appear on top of any other widgets on the page, and the PopupPanel
		   * provides this behavior.
		   *
		   * A non-static member class is used because the popup uses the SuggestBox's
		   * SuggestionMenu as its widget, and the position of the SuggestBox's TextBox
		   * is needed in order to correctly position the popup.
		   */
		  private class SuggestionPopup extends PopupPanel {

		    private static final String STYLENAME_DEFAULT = "gwt-SuggestBoxPopup";

		    public SuggestionPopup() {
		      super(true);
		      setWidget(suggestionMenu);
		      setStyleName(STYLENAME_DEFAULT);
		    }

		    /**
		     * The default position of the SuggestPopup is directly below the
		     * SuggestBox's text box, with its left edge aligned with the left edge of
		     * the text box. Depending on the width and height of the popup and the
		     * distance from the text box to the bottom and right edges of the window,
		     * the popup may be displayed directly above the text box, and/or its right
		     * edge may be aligned with the right edge of the text box.
		     */
		    public void showAlignedPopup() {
		   
		    // Set the position of the popup right before it is shown.
		    setPopupPositionAndShow(new PositionCallback() {
		      public void setPosition(int offsetWidth, int offsetHeight) {
		        // Calculate left position for the popup.

		        int left = box.getAbsoluteLeft();
		        int offsetWidthDiff = offsetWidth - box.getOffsetWidth();

		        // If the suggestion popup is not as wide as the text box, always align
		        // to the left edge of the text box. Otherwise, figure out whether to
		        // left-align or right-align the popup.
		        if (offsetWidthDiff > 0) {
		          // Make sure scrolling is taken into account, since box.getAbsoluteLeft()
		          // takes scrolling into account.
		          int windowRight = Window.getClientWidth() + Window.getScrollLeft();
		          int windowLeft = Window.getScrollLeft();

		          // Distance from the left edge of the text box to the right edge of the
		          // window
		          int distanceToWindowRight = windowRight - left;

		          // Distance from the left edge of the text box to the left edge of the
		          // window
		          int distanceFromWindowLeft = left - windowLeft;

		          // If there is not enough space for the popup's width overflow to the
		          // right of the text box and there IS enough space for the popup's
		          // width overflow to the left of the text box, then right-align
		          // the popup. However, if there is not enough space on either side,
		          // then stick with left-alignment.
		          if (distanceToWindowRight < offsetWidth &&
		              distanceFromWindowLeft >= (offsetWidth - box.getOffsetWidth())) {
		            // Align with the right edge of the text box.
		            left -= offsetWidthDiff;
		          }
		        }

		        // Calculate top position for the popup

		        int top = box.getAbsoluteTop();

		        // Make sure scrolling is taken into account, since box.getAbsoluteTop()
		        // takes scrolling into account.
		        int windowTop = Window.getScrollTop();
		        int windowBottom = Window.getScrollTop() + Window.getClientHeight();

		        // Distance from the top edge of the window to the top edge of the text box
		        int distanceFromWindowTop = top - windowTop;

		        // Distance from the bottom edge of the window to the bottom edge of the
		        // text box
		        int distanceToWindowBottom = windowBottom - (top + box.getOffsetHeight());

		        // If there is not enough space for the popup's height below the text box
		        // and there IS enough space for the popup's height above the text box,
		        // then then position the popup above the text box. However, if there is
		        // not enough space on either side, then stick with displaying the popup
		        // below the text box.
		        if (distanceToWindowBottom < offsetHeight &&
		            distanceFromWindowTop >= offsetHeight) {
		          top -= offsetHeight;
		        } else {
		          // Position above the text box
		          top += box.getOffsetHeight();
		        }

		        setPopupPosition(left, top);
		      }
		    });
		    }
		  }

	/**
	 * 
	 */
	 public TextBoxEditor() {
		super();
		editor = new TextBox();
		oracle = new MultiWordSuggestOracle("");  
		box = new SuggestBox(oracle);
//		editor.setWidth("100%");
		box.setStyleName(STYLE_TEXT_BOX_EDITOR);
		box.addClickListener(new ClickListener() {
			public void onClick(Widget arg){
				suggestionPopup.showAlignedPopup();
				box.addKeyboardListener(keyboardListener);
			}
		});
		add(box);
		image = new Image(Utils.getContextPath() + Utils.baseConstant.uriImgOptions());
		image.setStyleName("image_button");
		image.addClickListener(new ClickListener() {
			public void onClick(Widget arg0) {
				TextBoxEditor tmpEditor = new TextBoxEditor();
				tmpEditor.setValue(getValue());
				tmpEditor.setOldValue(getOldValue());
				tmpEditor.setClaimType(getClaimType());
				tmpEditor.remove(tmpEditor.getImage());
				final CrossCardClaimEditorPanel unsimpleEditor = new CrossCardClaimEditorPanel(tmpEditor);
				unsimpleEditor.getSaveValueListenerCollection().add(new SaveValueListener(){
					public void onSave(String newValue) {
						setValue(newValue);
					}
				});
				/*unsimpleEditor.getDialog().getCancelButton().addClickListener(new ClickListener() {
					public void onClick(Widget arg0) {
						add(unsimpleEditor.getBaseEditor());
						add(image);	
					}
				});*/
				
			}
		});
		//add(image);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor#getTypeEditor()
	 */
	public String getTypeEditor() {
		return TEXT_BOX_EDITOR;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor#getValue()
	 */
	public String getValue() {
		return box.getText();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor#setReadOnly(boolean)
	 */
	public void setReadOnly(boolean isReadOnly) {
		super.setReadOnly(isReadOnly);
		//((TextBox) editor).setReadOnly(isReadOnly);
		if (isReadOnly) {
			remove(box);
			Label label = new Label();
			label.setStyleName(STYLE_TEXT_BOX_EDITOR);
			label.setText(getValue());
			add(label);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor#setValue(java.lang.String)
	 */
	public void setValue(String val) {
		setOldValue(val);
		if (val != null) {
			((TextBox) editor).setText(val);
			box.setText(val);
		}
		else {
			((TextBox) editor).setText("");
			box.setText("");
		}
	}

	public SuggestBox getBox() {
		return box;
	}

	public void setBox(SuggestBox box) {
		this.box = box;
	}

	public Image getImage() {
		return image;
	}
	
	public void setClaimType(String claimType) {
		super.setClaimType(claimType);
		HashSet mrus = Utils.getValuesFromMRU(claimType);
		oracle.addAll(mrus);
		suggestionMenu.addAll(mrus);
	}

	public MultiWordSuggestOracle getOracle() {
		return oracle;
	}
	
	public void disableOptions() {
		image.setVisible(false);
	}
	
	public void enableOptions() {
		image.setVisible(true);
	}

}
