/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.base.client.model.entity;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class ClaimItem extends BaseEntity implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 6634666114282969562L;

	protected String id;

	protected String description;

	protected String claimType;

	protected boolean isValueRequired;

	protected String value;

	protected String valueTypeProperty;

	protected int valueType;

	protected boolean checked = false;

	protected boolean visible= true;

	/**
	 * @gwt.typeArgs <java.lang.String>
	 */
	protected ArrayList errorList;

	ClaimItem[] containerValue;

	/**
	 * 
	 */
	public ClaimItem() {
		super();
	}

	/**
	 * @return the id
	 */
	public String getId() {
		return this.id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return this.description;
	}

	/**
	 * @param description
	 *            the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @return the isValueRequired
	 */
	public boolean isValueRequired() {
		return this.isValueRequired;
	}

	/**
	 * @param isValueRequired
	 *            the isValueRequired to set
	 */
	public void setValueRequired(boolean isValueRequired) {
		this.isValueRequired = isValueRequired;
	}

	/**
	 * @return the value
	 */
	public String getValue() {
		return this.value;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * @return the valueType
	 */
	public int getValueType() {
		return this.valueType;
	}

	/**
	 * @param valueType
	 *            the valueType to set
	 */
	public void setValueType(int valueType) {
		this.valueType = valueType;
	}

	/**
	 * @return the checked
	 */
	public boolean isChecked() {
		return this.checked;
	}

	/**
	 * @param checked
	 *            the checked to set
	 */
	public void setChecked(boolean checked) {
		this.checked = checked;
	}

	/**
	 * @return the errorList
	 */
	public ArrayList getErrorList() {
		return this.errorList;
	}

	/**
	 * @param errorList
	 *            the errorList to set
	 */
	public void setErrorList(ArrayList errorList) {
		this.errorList = errorList;
	}

	/**
	 * @return the containerValue
	 */
	public ClaimItem[] getContainerValue() {
		return this.containerValue;
	}

	/**
	 * @param containerValue
	 *            the containerValue to set
	 */
	public void setContainerValue(ClaimItem[] containerValue) {
		this.containerValue = containerValue;
	}

	/**
	 * @return the claimType
	 */
	public String getClaimType() {
		return this.claimType;
	}

	/**
	 * @param claimType
	 *            the claimType to set
	 */
	public void setClaimType(String claimType) {
		this.claimType = claimType;
	}

	/**
	 * @return the valueTypeProperty
	 */
	public String getValueTypeProperty() {
		return this.valueTypeProperty;
	}

	/**
	 * @param valueTypeProperty the valueTypeProperty to set
	 */
	public void setValueTypeProperty(String valueTypeProperty) {
		this.valueTypeProperty = valueTypeProperty;
	}

	/**
	 * @return the visible
	 */
	public boolean isVisible() {
		return this.visible;
	}

	/**
	 * @param visible the visible to set
	 */
	public void setVisible(boolean visible) {
		this.visible = visible;
	}

}