/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.base.client.model.entity;

import java.io.Serializable;
import java.util.Date;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class UserProfile extends BaseEntity implements Serializable {

	private static final long serialVersionUID = 0L;

	private Date created;

	private String email;

	private String firstName;

	private String lastName;

	private String loginName;

	private Date modified;

	private String password;

	private String status;

	private String usedFrom;

	/**
	 * @return the created
	 */
	public Date getCreated() {
		return this.created;
	}

	/**
	 * @return the email
	 */
	public String getEmail() {
		return this.email;
	}

	/**
	 * @return the firstName
	 */
	public String getFirstName() {
		return this.firstName;
	}

	/**
	 * @return the lastName
	 */
	public String getLastName() {
		return this.lastName;
	}

	/**
	 * @return the loginName
	 */
	public String getLoginName() {
		return this.loginName;
	}

	/**
	 * @return the modified
	 */
	public Date getModified() {
		return this.modified;
	}

	/**
	 * @return the password
	 */
	public String getPassword() {
		return this.password;
	}

	/**
	 * @return the status
	 */
	public String getStatus() {
		return this.status;
	}

	/**
	 * @return the usedFrom
	 */
	public String getUsedFrom() {
		return this.usedFrom;
	}

	/**
	 * @param created
	 *            the created to set
	 */
	public void setCreated(Date createdDate) {
		this.created = createdDate;
	}

	/**
	 * @param email
	 *            the email to set
	 */
	public void setEmail(String email) {
		this.email = email;
	}

	/**
	 * @param firstName
	 *            the firstName to set
	 */
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	/**
	 * @param lastName
	 *            the lastName to set
	 */
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	/**
	 * @param loginName
	 *            the loginName to set
	 */
	public void setLoginName(String loginName) {
		this.loginName = loginName;
	}

	/**
	 * @param modified
	 *            the modified to set
	 */
	public void setModified(Date lastUpdatedDate) {
		this.modified = lastUpdatedDate;
	}

	/**
	 * @param password
	 *            the password to set
	 */
	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * @param status
	 *            the status to set
	 */
	public void setStatus(String status) {
		this.status = status;
	}

	/**
	 * @param usedFrom
	 *            the usedFrom to set
	 */
	public void setUsedFrom(String usedFrom) {
		this.usedFrom = usedFrom;
	}

}
