/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.base.client.panel;

import org.eclipse.higgins.ics.gwt.base.client.util.Utils;

import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class RoundedPanel extends DockPanel {

	private final HorizontalPanel panel = new HorizontalPanel();
	private final SimplePanel spanel = new SimplePanel();
	private Widget bodyWidget = new Label("empty body");

	/**
	 * 
	 */
	public RoundedPanel(Widget widget) {
		this();
		setBodyWidget(widget);
		this.panel.setStyleName(getStyleRoundedPanel());
		this.spanel.addStyleName(getStyleRoundedPanelEast());
		this.spanel.add(getBodyWidget());
		this.panel.add(this.spanel);
		add(this.panel, DockPanel.CENTER);

	}

	/**
	 * 
	 */
	private RoundedPanel() {
		super();
		final HorizontalPanel nothPanel = new HorizontalPanel();
		nothPanel.setWidth("100%");
		nothPanel.setStyleName(getStyleRoundedPanelNoth());
		nothPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
		nothPanel.add(getImageTopRt());
		add(nothPanel, DockPanel.NORTH);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.google.gwt.user.client.ui.UIObject#setHeight(java.lang.String)
	 */
	public void setHeight(String height) {
		super.setHeight(height);
		try {
			this.panel.setHeight(getOffsetHeight() + "px");
			this.spanel.setHeight(getOffsetHeight() + "px");
			this.bodyWidget.setHeight(getOffsetHeight() + "px");
		} catch (Exception e) {
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.google.gwt.user.client.ui.UIObject#setPixelSize(int, int)
	 */
	public void setPixelSize(int width, int height) {
		super.setPixelSize(width, height);
		try {
			this.panel.setPixelSize(getOffsetWidth(), getOffsetHeight());
			this.spanel.setPixelSize(getOffsetWidth(), getOffsetHeight());
			this.bodyWidget.setPixelSize(getOffsetWidth(), getOffsetHeight());
		} catch (Exception e) {
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.google.gwt.user.client.ui.UIObject#setSize(java.lang.String, java.lang.String)
	 */
	public void setSize(String width, String height) {
		super.setSize(width, height);
		try {
			this.panel.setSize(getOffsetWidth() + "px", getOffsetHeight() + "px");
			this.spanel.setSize(getOffsetWidth() + "px", getOffsetHeight() + "px");
			this.bodyWidget.setSize(getOffsetWidth() + "px", getOffsetHeight() + "px");
		} catch (Exception e) {
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.google.gwt.user.client.ui.UIObject#setWidth(java.lang.String)
	 */
	public void setWidth(String width) {
		super.setWidth(width);
		try {
			this.panel.setWidth(getOffsetWidth() + "px");
			this.spanel.setWidth(getOffsetWidth() + "px");
			this.bodyWidget.setWidth(getOffsetWidth() + "px");
		} catch (Exception e) {
		}

	}

	/**
	 * @return the bodyWidget
	 */
	public Widget getBodyWidget() {
		return this.bodyWidget;
	}

	/**
	 * @param bodyWidget
	 *            the bodyWidget to set
	 */
	private void setBodyWidget(Widget bodyWidget) {
		this.bodyWidget = bodyWidget;
	}

	/**
	 * @return the styleRoundedPanel
	 */
	public String getStyleRoundedPanel() {
		return "roundedPanel";
	}

	/**
	 * @return the styleRoundedPanelEast
	 */
	public String getStyleRoundedPanelEast() {
		return "roundedPanel_east";
	}

	/**
	 * @return the styleRoundedPanelNoth
	 */
	public String getStyleRoundedPanelNoth() {
		return "roundedPanel_noth";
	}

	/**
	 * @return the imageTopRt
	 */
	public Image getImageTopRt() {
		return new Image(Utils.getContextPath() + Utils.baseConstant.uriImgBoxTopRt());
	}

}
