package org.eclipse.higgins.ics.gwt.base.client.util;

import java.util.Date;

import org.eclipse.higgins.ics.gwt.base.client.dialog.SimpleDialog;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.ChangeListenerCollection;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

public class DatePicker extends Composite{

  private class NavBar extends Composite implements ClickListener {

    public final DockPanel bar = new DockPanel();
    public final Image prevMonth = new Image(Utils.getContextPath() + Utils.baseConstant.uriImgArrowLeftBlue());
    public final Image prevYear = new Image(Utils.getContextPath() + Utils.baseConstant.uriImgBigArrowLeftBlue());
    public final Image nextYear = new Image(Utils.getContextPath() + Utils.baseConstant.uriImgBigArrowRigthBlue());
    public final Image nextMonth = new Image(Utils.getContextPath() + Utils.baseConstant.uriImgArrowRigthBlue());
    public final HTML titleMonth = new HTML();
    public final HTML titleYear = new HTML();
    public HorizontalPanel titlePanel = new HorizontalPanel();

    private final DatePicker calendar;

    public NavBar(DatePicker calendar) {
    	initWidget(bar);
    	this.calendar = calendar;

      bar.addStyleName("navbar");
      titleMonth.addStyleName("header");
      titleYear.addStyleName("header");
      titleYear.addClickListener(this);
      prevMonth.addClickListener(this);
      prevYear.addClickListener(this);
      nextMonth.addClickListener(this);
      nextYear.addClickListener(this);
      HorizontalPanel prevButtons = new HorizontalPanel();
      prevButtons.add(prevYear);
      prevButtons.add(prevMonth);
      titlePanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
      titlePanel.setSpacing(0);
      titlePanel.add(titleMonth);
      titlePanel.add(titleYear);
      HorizontalPanel nextButtons = new HorizontalPanel();
      nextButtons.add(nextMonth);
      nextButtons.add(nextYear);
      bar.setVerticalAlignment(DockPanel.ALIGN_MIDDLE);
      
      bar.add(prevButtons, DockPanel.WEST);
      bar.setCellHorizontalAlignment(prevButtons, DockPanel.ALIGN_LEFT);
      bar.add(nextButtons, DockPanel.EAST);
      bar.setCellHorizontalAlignment(nextButtons, DockPanel.ALIGN_RIGHT);
      bar.add(titlePanel, DockPanel.CENTER);
      bar.setCellHorizontalAlignment(titlePanel, HasAlignment.ALIGN_CENTER);
      bar.setCellVerticalAlignment(titlePanel, HasAlignment.ALIGN_MIDDLE);
      bar.setCellWidth(titlePanel, "100%");
      
    }

    public void onClick(Widget sender) {
      if (sender == prevMonth) {
        calendar.prevMonth();
      } else if (sender == prevYear) {
        calendar.prevYear();
      } else if (sender == nextYear) {
    	calendar.nextYear();
      } else if (sender == nextMonth) {
        calendar.nextMonth();
      } else if (sender == titleYear) {
        titlePanel.remove(titleYear);
        titlePanel.setSpacing(3);
        final TextBox txtBox = new TextBox();
        DOM.setElementAttribute(txtBox.getElement(), "size", "4");
        txtBox.setText(getYear()+"");
        titlePanel.add(txtBox);
        final Image ok = new Image(Utils.getContextPath() + Utils.baseConstant.uriImgButtonAddGray());
        ok.addClickListener(new ClickListener() {
        	public void onClick(Widget arg) {
        		titleYear.setText(txtBox.getText());
        		titlePanel.clear();
        		titlePanel.setSpacing(0);
        		titlePanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        		titlePanel.add(titleMonth);
        		titlePanel.add(titleYear);
        		calendar.setYear(titleYear.getText());
        	}
        });
        titlePanel.add(ok);
      }
    }
  }

  private static class Cell extends HTML {
    private int day;
       
    public Cell(String text, int day) {
      super(text);
      MouseListener mouseListener =  new MouseListener() {
  		
 		 public void onMouseEnter(Widget arg0) {
 			 addStyleName("picker-pre-selected"); 
 		}

 		public void onMouseLeave(Widget arg0) {
 			removeStyleName("picker-pre-selected");
 		}

 		
 		 public void onMouseMove(Widget arg0, int arg1, int arg2) {
 		}

 		
 		public void onMouseUp(Widget arg0, int arg1, int arg2) {
 		}
 		
 		public void onMouseDown(Widget arg0, int arg1, int arg2) {					
 		}
 	};
 	addMouseListener(mouseListener);
      this.day = day;
    }
       
    public int getDay() {
      return day;
    }
  }
  
  private final NavBar navbar = new NavBar(this);
  private final DockPanel outer = new DockPanel();
  private SimpleDialog dialog; 
  public TextBox text;

  private final Grid grid = new Grid(6, 7) {
    public boolean clearCell(int row, int column) {
      boolean retValue = super.clearCell(row, column);
           
      Element td = getCellFormatter().getElement(row, column);
      DOM.setInnerHTML(td, "");
      return retValue;
    }
  };

  private Date date = new Date();

  private ChangeListenerCollection changeListeners;
   
  public String[] days = new String[] { "Sunday", "Monday", "Tuesday",
      "Wednesday", "Thursday", "Friday", "Saturday" };

  public String[] months = new String[] { "January", "February", "March",
      "April", "May", "June", "July", "August", "September", "October",
      "November", "December" };

  public DatePicker() {
	  initWidget(outer); 
	  grid.addStyleName("table");
    grid.setCellSpacing(0);
    outer.add(navbar, DockPanel.NORTH);
    outer.add(grid, DockPanel.CENTER);
    drawCalendar();
    addStyleName("DatePicker");
       
  }

  private void drawCalendar() {
    int year = getYear();
    int month = getMonth();
    int day = getDay();
    setHeaderText(year, month);
    grid.getRowFormatter().addStyleName(0, "weekheader");
    for (int i = 0; i < days.length; i++) {
      grid.getCellFormatter().addStyleName(0, i, "days");
      grid.setText(0, i, days[i].substring(0, 3));
    }
    
    Date now = new Date();
    int sameDay = now.getDate();
    int today = (now.getMonth() == month && now.getYear()+1900 == year) ? sameDay : 0;
       
    int firstDay = new Date(year - 1900, month, 1).getDay();
    int numOfDays = getDaysInMonth(year, month);

    int j = 0;
    for (int i = 1; i < 6; i++) {
      for (int k = 0; k < 7; k++, j++) {
        int displayNum = (j - firstDay + 1);
        if (j < firstDay || displayNum > numOfDays) {
          grid.getCellFormatter().addStyleName(i, k, "empty");
          grid.setHTML(i, k, "&nbsp;");
        } else {
          final HTML html = new Cell(
            "<span>" + String.valueOf(displayNum) + "</span>", 
            displayNum);
          html.addClickListener(new ClickListener() {
      		public void onClick(Widget arg0) {
      			setDate(getYear(), getMonth(), ((Cell)html).getDay());
      			text.setText(months[getMonth()]+" "+((Cell)html).getDay()+", "+getYear());
      			dialog.hide();
    		}
    	});
          grid.getCellFormatter().addStyleName(i, k, "cell");
          if (displayNum == today) {
            grid.getCellFormatter().addStyleName(i, k, "today");
          } else if (displayNum == sameDay) {
            grid.getCellFormatter().addStyleName(i, k, "day");
          }
          
            
          grid.setWidget(i, k, html);
        }
      }
    }
  }

  protected void setHeaderText(int year, int month) {
    navbar.titleMonth.setText(months[month]+", ");
    navbar.titleYear.setText(year+"");
  }
   
  private int getDaysInMonth(int year, int month) {
    switch (month) {
      case 1:
        if ((year % 4 == 0 && year % 100 != 0) || year % 400 == 0)
          return 29; // leap year
        else
          return 28;
      case 3:
        return 30;
      case 5:
        return 30;
      case 8:
        return 30;
      case 10:
        return 30;
      default:
        return 31;
    }
  }

  public void prevMonth() {
    int month = getMonth() - 1;
    if (month < 0) {
      setDate(getYear() - 1, 11, getDay());
    } else {
      setMonth(month);
    }
    drawCalendar();
  }

  public void nextMonth() {
    int month = getMonth() + 1;
    if (month > 11) {
      setDate(getYear() + 1, 0, getDay());
    } else {
      setMonth(month);
    }
    drawCalendar();
  }
   
  public void prevYear() {
    setYear(getYear() - 1);
    drawCalendar();
  }

  public void nextYear() {
    setYear(getYear() + 1);
    drawCalendar();
  }
  
  public void setYear(String year) {
	  setYear(Integer.parseInt(year));
	  drawCalendar();
  }

  private void setDate(int year, int month, int day) {
    date = new Date(year - 1900, month, day);
  }
   
  private void setYear(int year) {
    date.setYear(year - 1900);
  }

  private void setMonth(int month) {
    date.setMonth(month);
  }

  public int getYear() {
    return 1900 + date.getYear();
  }

  public int getMonth() {
    return date.getMonth();
  }

  public int getDay() {
    return date.getDate();
  }
   
  public Date getDate() {
    return date;
  }
  
  public void show(TextBox txtBox) {
	  dialog = new SimpleDialog(this);
	  text = txtBox;
	  dialog.showDialog();
  }

  public void onClick(Widget sender) {
    Cell cell = (Cell)sender;
    setDate(getYear(), getMonth(), cell.getDay());
    drawCalendar();
    if (changeListeners != null) {
      changeListeners.fireChange(this);
    }
  }
}  