/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel.card;

import org.eclipse.higgins.ics.gwt.base.client.BaseConstant;
import org.eclipse.higgins.ics.gwt.base.client.editor.ImageEditor;
import org.eclipse.higgins.ics.gwt.base.client.listener.ChangeSelectedCardListener;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Category;
import org.eclipse.higgins.ics.gwt.base.client.panel.RoundedPanel;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;
import org.eclipse.higgins.ics.gwt.icm.client.panel.history.CardHistoryPanel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class CardPanel extends Composite {

	private Image photo;

	private String imagee;
	
	private Widget currentFooterPanel;
	
	private CardHistoryPanel historyPanel = new CardHistoryPanel();

	private final VerticalPanel layoutPanel = new VerticalPanel();

	private final ScrollPanel bodyPanel = new ScrollPanel();

	private final CardPanelHeader headerPanel = new CardPanelHeader();

	private final static CardPanelFooter footerButtonPanel = new CardPanelFooter();

	private final RoundedPanel roundedPanel;

	private final BaseConstant constant = (BaseConstant) GWT
			.create(BaseConstant.class);

	//private boolean isHistoryClicked = false;

	private final ChangeSelectedCardListener selectedCardListener = new ChangeSelectedCardListener() {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.higgins.ics.gwt.base.client.listener.ChangeSelectedCardListener#onChangeSelectedCard(org.eclipse.higgins.ics.gwt.base.client.model.entity.Card,
		 *      org.eclipse.higgins.ics.gwt.base.client.model.entity.Category)
		 */
		public void onChangeSelectedCard(final Card card,
				final Category category) {
			if (card != null) {
				try {
					bodyPanel.clear();
					final Image imageDef = new Image(Utils.getContextPath()
							+ ICMEntryPoint.constant.uriImgTabRt());
					imageDef.setSize("2px", "21px");
					final Image imageSel = new Image(Utils.getContextPath()
							+ ICMEntryPoint.constant.uriImgTabRtHover());
					imageSel.setSize("2px", "21px");

					((Label) headerPanel.getTabPanelCardDetails().getWidget(0))
							.addClickListener(new ClickListener() {
								public void onClick(Widget arg0) {
									showTab(getCardDetailWidget(card));
									headerPanel.getTabPanelCardDetails()
											.getWidget(0).setStyleName(
													"tabBarItem-selected");
									headerPanel.getTabPanelHistory().getWidget(
											0).setStyleName("tabBarItem");
									headerPanel.getTabPanelCardDetails()
											.remove(1);
									headerPanel.getTabPanelCardDetails().add(
											imageSel);
									headerPanel.getTabPanelHistory().remove(1);
									headerPanel.getTabPanelHistory().add(
											imageDef);
									//isHistoryClicked = false;
								}
							});

					((Label) headerPanel.getTabPanelHistory().getWidget(0))
							.addClickListener(new ClickListener() {
								public void onClick(Widget arg0) {
									showTab(getCardHistoryWidget(card));
									headerPanel.getTabPanelHistory().getWidget(
											0).setStyleName(
											"tabBarItem-selected");
									headerPanel.getTabPanelCardDetails()
											.getWidget(0).setStyleName(
													"tabBarItem");
									headerPanel.getTabPanelHistory().remove(1);
									headerPanel.getTabPanelHistory().add(
											imageSel);
									headerPanel.getTabPanelCardDetails()
											.remove(1);
									headerPanel.getTabPanelCardDetails().add(
											imageDef);
									//isHistoryClicked = true;
								}
							});

					showTab(getCardDetailWidget(card));
				} catch (Exception e) {
				}
			} else {
				bodyPanel.clear();

				// setVisible(false);
			}

		}

	};

	/**
	 * 
	 */
	public CardPanel() {
		this.layoutPanel.setWidth("100%");
		this.layoutPanel.setHeight("100%");
		// this.bodyPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);

		this.layoutPanel.add(this.headerPanel);
		this.layoutPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
		this.layoutPanel.add(this.bodyPanel);

		

		this.bodyPanel.setHeight("100%");

		this.roundedPanel = new RoundedPanel(new ScrollPanel(this.layoutPanel));

		initWidget(this.roundedPanel);

		ICMEntryPoint.currentState
				.addChangeSelectedCardListener(this.selectedCardListener);

	}

	public Widget getCardDetailWidget(Card card) {
		if (currentFooterPanel != null) this.layoutPanel.remove(currentFooterPanel);
		currentFooterPanel = footerButtonPanel;
		this.layoutPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
		this.layoutPanel.add(currentFooterPanel);
		if (card.getCardType().equals("IPersonalInformationCard")) {
			return getPCardDetailWidget(card);
		} else if (card.getCardType().equals("IManagedInformationCard")) {
			return getMCardDetailWidget(card);
		} else {
			return getMCardDetailWidget(card);
		}
	}

	public Widget getCardHistoryWidget(Card card) {
		this.layoutPanel.remove(currentFooterPanel);
		currentFooterPanel = historyPanel.getCardHistoryFooter();
		if (historyPanel.getCardHistoryFooter().getCard().getCardInformation()==null) historyPanel.getHistory();
		this.layoutPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
		this.layoutPanel.add(currentFooterPanel);
		return historyPanel;
	}

	public Widget getPCardDetailWidget(Card card) {
		imagee = new String(card.getImage());
		final FlexTable flexTable = new FlexTable();
		// flexTable.setWidth("100%");
		flexTable.getColumnFormatter().setWidth(0, "160px");

		flexTable.getFlexCellFormatter().setHorizontalAlignment(0, 0,
				HasHorizontalAlignment.ALIGN_RIGHT);
		Label labelPhoto = new Label("Photo:");
		labelPhoto.setStyleName("cardPanel_claim_label");
		flexTable.setWidget(0, 0, labelPhoto);

		// Image cardImage = new Image();
		// DOM.setElementAttribute(cardImage.getElement(), "src",
		// "data:image/jpeg;base64," + card.getImage());
		ImageEditor photo = new ImageEditor();
		photo.setValue(imagee);
		photo.setReadOnly(true);

		flexTable.getFlexCellFormatter().setHorizontalAlignment(0, 1,
				HasHorizontalAlignment.ALIGN_LEFT);
		flexTable.setWidget(0, 1, photo);

		int drow = 1;
		for (int i = 0; i < card.getClaimItems().length; i++) {
			flexTable.getFlexCellFormatter().setHorizontalAlignment(drow + i,
					0, HasHorizontalAlignment.ALIGN_RIGHT);
			Label label = new Label(card.getClaimItems()[i].getName() + ": ");
			label.setVisible(card.getClaimItems()[i].isVisible());
			label.setStyleName("cardPanel_claim_label");
			flexTable.setWidget(drow + i, 0, label);

			Label value = new Label(card.getClaimItems()[i].getValue() != null
					&& !card.getClaimItems()[i].getValue().equalsIgnoreCase(
							"null") ? card.getClaimItems()[i].getValue() : "");
			value.setStyleName("cardPanel_claim_value");
			value.setVisible(card.getClaimItems()[i].isVisible());
			flexTable.getFlexCellFormatter().setHorizontalAlignment(drow + i,
					1, HasHorizontalAlignment.ALIGN_LEFT);
			flexTable.setWidget(drow + i, 1, value);

			// if (i == 1 || i == 7) {
			// dimRowTable = dimRowTable + 1;
			// Image separator = new Image(Utils.getContextPath() +
			// ICMEntryPoint.constant.uriImgBgHeaderOverlayForm());
			// separator.setHeight("1px");
			// separator.setWidth("100%");
			// bodyTable.setWidget(dimRowTable + i, 0, separator);
			// bodyTable.getFlexCellFormatter().setColSpan(dimRowTable + i, 0,
			// 2);
			// }
		}

		return flexTable;
	}

	public Widget getMCardDetailWidget(Card card) {
		photo = new Image();
		imagee = new String(card.getImage());
		final FlexTable flexTable = new FlexTable();
		try {
			if (Utils.isIE()) {
				//photo.setUrl(Utils.getContextPath() + Utils.baseConstant.uriImgProgress());
				ICMEntryPoint.service.putImageForIE(card.getImage(),
						new AsyncCallback() {
							public void onSuccess(Object arg0) {
								photo.setUrl(constant.servletPaintLogoAddress()
										+ "?cdata="
										+ imagee.substring(imagee.length() - 20).replace('+','_').replace('=','_'));
							}

							public void onFailure(Throwable arg0) {
								photo.setVisible(false);
							}
						});
			} else
				DOM.setElementAttribute(photo.getElement(), "src",
						"data:image/jpeg;base64," + imagee);
		} catch (Exception e) {
			e.printStackTrace();
		}
		// flexTable.setWidth("100%");
		flexTable.getColumnFormatter().setWidth(0, "180px");
		// bodyTable.setWidth(this.bodyPanel.getOffsetWidth() - 10+"px");

		flexTable.getFlexCellFormatter().setHorizontalAlignment(0, 0,
				HasHorizontalAlignment.ALIGN_RIGHT);
		flexTable.getFlexCellFormatter().setHorizontalAlignment(0, 1,
				HasHorizontalAlignment.ALIGN_LEFT);

		Label labelIssuer = new Label(card.getIssuerName());
		labelIssuer.setStyleName("cardPanel_claim_value");
		/*
		 * if (Utils.isIE()) { if (imagee != null) {
		 * photo.setUrl(constant.servletPaintLogoAddress() + "?cdata=" +
		 * imagee.substring(imagee.length() - 20)); photo.setVisible(true); }
		 * else photo.setVisible(false);
		 * photo.setUrl(constant.servletPaintLogoAddress() + "?cdata=" +
		 * imagee.substring(imagee.length() - 20));
		 *  } else
		 */

		flexTable.setWidget(0, 0, photo);
		flexTable.setWidget(0, 1, labelIssuer);

		Image separator = new Image(Utils.getContextPath()
				+ ICMEntryPoint.constant.uriImgBgHeaderOverlayForm());
		separator.setHeight("1px");
		separator.setWidth("100%");
		flexTable.setWidget(1, 0, separator);
		flexTable.getFlexCellFormatter().setColSpan(1, 0, 2);

		int drow = 2;
		for (int i = 0; i < card.getClaimItems().length; i++) {
			flexTable.getFlexCellFormatter().setHorizontalAlignment(drow + i,
					0, HasHorizontalAlignment.ALIGN_RIGHT);
			Label label = new Label(card.getClaimItems()[i].getName() + ": ");
			label.setVisible(card.getClaimItems()[i].isVisible());
			label.setStyleName("cardPanel_claim_label");
			flexTable.setWidget(drow + i, 0, label);

			Label value = new Label(card.getClaimItems()[i].getValue());
			value.setVisible(card.getClaimItems()[i].isVisible());
			value.setStyleName("cardPanel_claim_value");
			value.setText(card.getClaimItems()[i].getValue() != null
					&& !card.getClaimItems()[i].getValue().equalsIgnoreCase(
							"null") ? card.getClaimItems()[i].getValue() : "");
			if (card.getClaimItems()[i].getClaimType().equalsIgnoreCase("http://eclipse.org/higgins/2008/password")) {
				value.setText("*****");
			}
			flexTable.getFlexCellFormatter().setHorizontalAlignment(drow + i,
					1, HasHorizontalAlignment.ALIGN_LEFT);
			flexTable.setWidget(drow + i, 1, value);
		}

		return flexTable;
	}

	private void showTab(Widget widget) {
		this.bodyPanel.clear();
		this.bodyPanel.add(widget);
	}

	/**
	 * @return the layoutPanel
	 */
	public VerticalPanel getLayoutPanel() {
		return this.layoutPanel;
	}

	/**
	 * @param height
	 * @see com.google.gwt.user.client.ui.UIObject#setHeight(java.lang.String)
	 */
	public void setHeight(String height) {
		this.layoutPanel.setHeight(height);
	}

	/**
	 * @param width
	 * @param height
	 * @see com.google.gwt.user.client.ui.UIObject#setPixelSize(int, int)
	 */
	public void setPixelSize(int width, int height) {
		// width = width -20;
		// width = width - 5;
		this.headerPanel.setWidth(width + "px");

		this.footerButtonPanel.setPixelSize(width, 48);
		try {
			if (this.headerPanel.getOffsetHeight() > 0
					&& this.footerButtonPanel.getOffsetHeight() > 0) {
				this.bodyPanel.setPixelSize(width - 10, height
						- this.headerPanel.getOffsetHeight()
						- this.footerButtonPanel.getOffsetHeight());
			} else {
				this.bodyPanel.setPixelSize(width - 10, height - 185);
			}

		} catch (Exception e) {
			this.bodyPanel.setPixelSize(width, height - 185);
		}
		this.layoutPanel.setSize(width + "px", height + "px");
	}

	/**
	 * @param width
	 * @param height
	 * @see com.google.gwt.user.client.ui.UIObject#setSize(java.lang.String,
	 *      java.lang.String)
	 */
	public void setSize(String width, String height) {
		this.layoutPanel.setSize(width, height);
	}

	/**
	 * @param width
	 * @see com.google.gwt.user.client.ui.UIObject#setWidth(java.lang.String)
	 */
	public void setWidth(String width) {
		this.layoutPanel.setWidth(width);
	}
	
	public static CardPanelFooter getCardPanelFooter() {
		return footerButtonPanel;
	}
}
