package org.eclipse.higgins.ics.gwt.icm.client.panel.cardcredential;

import org.eclipse.higgins.ics.gwt.base.client.button.CardActionButton;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardCredential;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.VerticalPanel;

public class ManagePinPanel extends Composite {

	private PinCredentialPanel pinPanel1;

	private PinCredentialPanel pinPanel2;

	private final VerticalPanel bodyPanel = new VerticalPanel();

	private DialogBox dialogBox;

	private final Card card;
	
	private HTML description = new HTML();

	private CardActionButton doButton;

	public ManagePinPanel(Card card, boolean isEdit) {
		this.card = card;
		CardCredential cardCredential = new CardCredential();
		cardCredential.setType(CardCredentialEditor.PIN_CRIDENTIAL_TYPE);
		this.pinPanel1 = new PinCredentialPanel(cardCredential);
		this.bodyPanel
				.add(description);
		this.bodyPanel.add(this.pinPanel1);
		if (isEdit) {
			this.pinPanel2 = new PinCredentialPanel(cardCredential, ICMEntryPoint.dictionary.get("RetypeLabel_HTML")
					+ this.pinPanel1.getPinLabel());
			this.bodyPanel.add(this.pinPanel2);
		}
		initWidget(this.bodyPanel);
	}

	/**
	 * @return the dialogBox
	 */
	public DialogBox getDialogBox() {
		return this.dialogBox;
	}

	/**
	 * @param dialogBox
	 *            the dialogBox to set
	 */
	public void setDialogBox(DialogBox dialogBox) {
		this.dialogBox = dialogBox;
	}

	/**
	 * @return the card
	 */
	public Card getCard() {
		return this.card;
	}

	/**
	 * @return the pinPanel1
	 */
	public PinCredentialPanel getPinPanel1() {
		return this.pinPanel1;
	}

	/**
	 * @return the pinPanel1
	 */
	public PinCredentialPanel getPinPanel2() {
		return this.pinPanel2;
	}

	/**
	 * @return the setPinButton
	 */
	public CardActionButton getDoButton() {
		return this.doButton;
	}

	public void setDoButton(CardActionButton button) {
		this.doButton = button;
	}

	/**
	 * @param focused
	 * @see org.eclipse.higgins.ics.gwt.icm.client.panel.cardcredential.PinCredentialPanel#setFocus(boolean)
	 */
	public void setFocus(boolean focused) {
		this.pinPanel1.setFocus(focused);
	}
	
	public String getDescriptionHTML() {
		return this.description.getHTML();
	}

	public void setDescriptionHTML(String html) {
		this.description.setHTML(html);
	}
}
