/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko -  initial API and implementation
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel.category.dnd;

import com.allen_sauer.gwt.dnd.client.DragContext;
import com.allen_sauer.gwt.dnd.client.drop.AbstractPositioningDropController;
import com.allen_sauer.gwt.dnd.client.util.CoordinateLocation;
import com.allen_sauer.gwt.dnd.client.util.DOMUtil;
import com.allen_sauer.gwt.dnd.client.util.Location;
import com.allen_sauer.gwt.dnd.client.util.LocationWidgetComparator;
import com.allen_sauer.gwt.dnd.client.util.WidgetLocation;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.IndexedPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class TableDropController extends AbstractPositioningDropController {

	 private FlexTable flexTable;

	  private IndexedPanel flexTableRowsAsIndexPanel = new IndexedPanel() {

	    public Widget getWidget(int index) {
	      return flexTable.getWidget(index, 0);
	    }

	    public int getWidgetCount() {
	      return flexTable.getRowCount();
	    }

	    public int getWidgetIndex(Widget child) {
	      throw new UnsupportedOperationException();
	    }

	    public boolean remove(int index) {
	      throw new UnsupportedOperationException();
	    }
	  };

	  private Widget positioner = null;

	  private int targetRow;

	  public TableDropController(FlexTable flexTable) {
	    super(flexTable);
	    this.flexTable = flexTable;
	  }

	  public void onDrop(DragContext context) {
	    TableDragController trDragController = (TableDragController) context.dragController;
	    TableUtils.moveRow(trDragController.getDraggableTable(), flexTable,
	        trDragController.getDragRow(), targetRow + 1);
	    super.onDrop(context);
	  }

	  public void onEnter(DragContext context) {
	    super.onEnter(context);
	    positioner = newPositioner(context);
	  }

	  public void onLeave(DragContext context) {
	    positioner.removeFromParent();
	    positioner = null;
	    super.onLeave(context);
	  }

	  public void onMove(DragContext context) {
	    super.onMove(context);
	    targetRow = DOMUtil.findIntersect(flexTableRowsAsIndexPanel, new CoordinateLocation(
	        context.mouseX, context.mouseY), LocationWidgetComparator.BOTTOM_HALF_COMPARATOR) - 1;
	    positioner.removeFromParent();
	    Widget w = flexTable.getWidget(targetRow == -1 ? 0 : targetRow, 0);
	    Location widgetLocation = new WidgetLocation(w, context.boundaryPanel);
	    Location tableLocation = new WidgetLocation(flexTable, context.boundaryPanel);
	    context.boundaryPanel.add(positioner, tableLocation.getLeft(), widgetLocation.getTop()
	        + (targetRow == -1 ? 0 : w.getOffsetHeight()));
	  }

	  Widget newPositioner(DragContext context) {
		    Widget p = new SimplePanel();
		    p.addStyleName("dragdrop-dropTarget-engage");
		    p.setPixelSize(flexTable.getOffsetWidth(), 1);
		    return p;
		  }
}
