package org.eclipse.higgins.ics.gwt.icm.client.panel.category.dnd;

import org.eclipse.higgins.ics.gwt.icm.client.panel.category.CategoryPanelItem;

import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Widget;

public class TableUtils {

		  public static void copyRow(final FlexTable sourceTable, final FlexTable targetTable, final int sourceRow, final int targetRow) {
				try {
					targetTable.insertRow(targetRow);
					final Widget w = sourceTable.getWidget(sourceRow, 0);
					if (w != null) {
						final CategoryPanelItem categoryPanelItem = new CategoryPanelItem(((CategoryPanelItem) w).getCategory());
						categoryPanelItem.setStyleName("categoryItemDnDPanel");
						targetTable.setWidget(targetRow, 0, categoryPanelItem);
						copyRowStyle(sourceTable, targetTable, sourceRow,targetRow);
					}
				} catch (final Exception e) {
					// Window.alert("copyRow:" + e.getMessage());
				}
			}

		  public static void moveRow(final FlexTable sourceTable, final FlexTable targetTable, int sourceRow, final int targetRow) {
				try {
					if (sourceTable == targetTable && sourceRow >= targetRow) {
						sourceRow++;
					}
					// if (sourceTable == null)
					// Window.alert("sourceTable == null");
					// if (targetTable == null)
					// Window.alert("targetTable == null");
					targetTable.insertRow(targetRow);
					final Widget w = sourceTable.getWidget(sourceRow, 0);
					if (w != null) {
						targetTable.setWidget(targetRow, 0, w);
						// } else {
						// Window.alert("Widget is null");
					}
					copyRowStyle(sourceTable, targetTable, sourceRow,targetRow);
					sourceTable.removeRow(sourceRow);
				} catch (final Exception e) {
					// Window.alert("moveRow" + e.getMessage());
				}
			}

		  private static void copyRowStyle(FlexTable sourceTable, FlexTable targetTable, int sourceRow,
		      int targetRow) {
		    String rowStyle = sourceTable.getRowFormatter().getStyleName(sourceRow);
		    targetTable.getRowFormatter().setStyleName(targetRow, rowStyle);
		  }
		  
}
