/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel.edit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.eclipse.higgins.ics.gwt.base.client.button.CardActionButton;
import org.eclipse.higgins.ics.gwt.base.client.button.SimpleButton;
import org.eclipse.higgins.ics.gwt.base.client.dialog.SimpleDialog;
import org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor;
import org.eclipse.higgins.ics.gwt.base.client.editor.EditorBuilder;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardUpdate;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Category;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.ClaimItem;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.GWTResponse;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.ListEntity;
import org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class PCardEditablePanel extends CardEditablePanel {
	
public static class CrossCardEditorPanelItem extends VerticalPanel {
		
		CheckBox checkBox = new CheckBox();
		PasswordTextBox pinBox = new PasswordTextBox();
		//String cuid = new String();
		//CardCredential credential = null;
		Card card;
		HorizontalPanel hpanel = new HorizontalPanel();
		Label name;
		
		public CrossCardEditorPanelItem(final Card card) {
			super();
			setWidth("80px");
			setHeight("25px");
			setSpacing(2);
			setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
			setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
			this.card = card;
			if (card.getCardCredential()!= null && card.getCardCredential().length>0) pinBox.setText(card.getCardCredential()[0].getPinCode());
			/*pinBox.addClickListener(new ClickListener(){
				public void onClick(Widget arg0) {
					pinBox.setText("");
				}
			});*/
			checkBox.setChecked(false);
			checkBox.addClickListener(new ClickListener() {
				public void onClick(Widget arg) {
					if (card.isProtected() && !card.isSaveCredential() && checkBox.isChecked()) {
						
						add(pinBox);
					}
					if (card.isProtected() && !card.isSaveCredential() && !checkBox.isChecked()) {
						
						remove(pinBox);
					}
				}
			});
			hpanel.setSpacing(2);
			hpanel.add(checkBox);
			name = new Label(card.getName().substring(0, 20));
			hpanel.add(name);
			add(hpanel);					
		}		

		public CheckBox getCheckBox() {
			return checkBox;
		}

		public void setCheckBox(CheckBox checkBox) {
			this.checkBox = checkBox;
		}

		public PasswordTextBox getPinBox() {
			return pinBox;
		}

		public void setPinBox(PasswordTextBox pinBox) {
			this.pinBox = pinBox;
		}

		public Card getCard() {
			return card;
		}

		public void setCard(Card card) {
			this.card = card;
		}
	}


	/**
	 * 
	 */
	
	final VerticalPanel optionsPanel = new VerticalPanel();
	HorizontalPanel optionsChooserPanel = new HorizontalPanel();
	VerticalPanel updateOptionsPanel = new VerticalPanel();
	final SimpleButton moreOptionsButton;
	final VerticalPanel cardsTablePanel = new VerticalPanel();
	HorizontalPanel cardOptions = new HorizontalPanel();
	final FlexTable cardsTable = new FlexTable();
	private final HTML cardCounter = new HTML();	
	private List cards = new ArrayList();	
	private int tableWidthCount = 1;
	
	final RadioButton rb0 = new RadioButton("myRadio", "This card only");
	final RadioButton rb1 = new RadioButton("myRadio", "All cards with the same prior value");
	final RadioButton rb2 = new RadioButton("myRadio", "Selected cards...");		
	
	public PCardEditablePanel(Card pcard) {
		super(pcard);
		this.getLabelCardImage().setText(ICMEntryPoint.dictionary.get("CardImageLabel_HTML"));
		// getBodyTable().getColumnFormatter().setWidth(0, "160px");

		getBodyTable().setWidget(this.dimRowTable, 0, buildGroupPanel(ICMEntryPoint.dictionary.get("Level1ClaimTitle_HTML")));
		getBodyTable().getFlexCellFormatter().setColSpan(this.dimRowTable, 0, 2);
		this.dimRowTable = this.dimRowTable + 1;

		for (int i = 0; i < getCard().getClaimItems().length; i++) {
			getBodyTable().getFlexCellFormatter().setHorizontalAlignment(this.dimRowTable + i, 0, HasHorizontalAlignment.ALIGN_RIGHT);
			Label label = new Label(getCard().getClaimItems()[i].getName() + ": ");
			label.setStyleName("cardPanel_claim_label");
			getBodyTable().setWidget(this.dimRowTable + i, 0, label);
			label.setVisible(getCard().getClaimItems()[i].isVisible());

			BaseEditor editor = EditorBuilder.buildByClaimItem(getCard().getClaimItems()[i]);
			editor.setChildHeight("80");
			editor.setWidth("80");
			getBodyTable().getFlexCellFormatter().setHorizontalAlignment(this.dimRowTable + i, 1, HasHorizontalAlignment.ALIGN_LEFT);
			getBodyTable().setWidget(this.dimRowTable + i, 1, editor);
			if (!getCard().getClaimItems()[i].isVisible()){
				getBodyTable().getFlexCellFormatter().setVisible(this.dimRowTable + i, 1, false);
	//			getBodyTable().getFlexCellFormatter().setVisible(this.dimRowTable + i, 1, false);
			}
		}
		setSaveChangesListener(new ClickListener() {
			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(Widget arg0) {
				if (rb0.isChecked()) {
					getCard().setName(getCardName().getValue());
					getCard().setImage(getCardImage().getValue());
					getCard().setImageType("image/jpeg");
					for (int i = 0; i < getCard().getClaimItems().length; i++) {
						try {
							BaseEditor editor = (BaseEditor) getBodyTable().getWidget(PCardEditablePanel.this.dimRowTable + i, 1);
							getCard().getClaimItems()[i].setValue(editor.getValue());
						} catch (RuntimeException e) {
						}
					}
					
					Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("SendChangesLabel_HTML"));
					ICMEntryPoint.service.modifyCard(getCard(), ICMEntryPoint.getUserProfile().getLoginName(), ICMEntryPoint.getUserProfile()
							.getPassword(), new GWTCallBack() {

						
						public void onFailure(Throwable arg0) {
							Utils.hideWaiteDialog();
							super.onFailure(arg0);
						}

						
						public void onSuccess(Object res) {
							Utils.hideWaiteDialog();
							if (res instanceof GWTResponse) {
								GWTResponse response = (GWTResponse) res;
								if (response.getStatusCode().equals(new Integer(0))) {
									ICMEntryPoint.currentState.modifySelectedCard((Card) response.getResult());
								} else {
									Utils.showErrorMessage(response.getStatusMessage());
								}
							}
							if (getDialogBox() != null) {
								getDialogBox().hide();
							}
						}
					});
				} else {
					Set cardsToUpdate = new HashSet(0);
					Set claimsToUpdate = new HashSet(0);
					if (rb1.isChecked()) {
						for (int i = 0; i < getCard().getClaimItems().length; i++) {
								try {
									BaseEditor editor = (BaseEditor) getBodyTable().getWidget(PCardEditablePanel.this.dimRowTable + i, 1);
									//getCard().getClaimItems()[i].setValue(editor.getValue());
									if (!editor.getOldValue().equalsIgnoreCase(editor.getValue())) {
										for (int j=0; j<cards.size(); j++) {
											Card maybeCard = (Card)cards.get(j);
											if (maybeCard.getClaimItems()[i].getValue().equalsIgnoreCase(editor.getOldValue()) && !maybeCard.isProtected()) {
												maybeCard.getClaimItems()[i].setValue(editor.getValue());
												cardsToUpdate.add(new Integer(j));
											}
										}
									}
								} catch (RuntimeException e) {
								}
							}
						
						final Card[] arrayOfCards  = new Card[cardsToUpdate.size()];
						int i=0;
						for (Iterator iterator = cardsToUpdate.iterator(); iterator.hasNext();) {
							arrayOfCards[i] = (Card)cards.get(((Integer)iterator.next()).intValue());
							i++;
						}
						
						Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("SendChangesLabel_HTML"));
						
						ICMEntryPoint.service.updateICards(ICMEntryPoint.getUserProfile().getLoginName(), ICMEntryPoint.getUserProfile().getPassword(), arrayOfCards, new AsyncCallback() {
							public void onFailure(Throwable arg) {
								Utils.hideWaiteDialog();
								Utils.showErrorMessage("Error: "+arg);
							}
							public void onSuccess(Object arg) {
								Utils.hideWaiteDialog();
								getDialogBox().hide();
								if (arg instanceof GWTResponse) {
									GWTResponse response = (GWTResponse) arg;
									if (response.getStatusCode().equals(new Integer(0))) {
										ListEntity entity = (ListEntity)response.getResult();
										List cuids = entity.getList();
										String info = new String("The following cards were updated:<br>");
										for (int i=0; i<arrayOfCards.length; i++) {
											for (int j=0; j<cuids.size(); j++) {
												Card card = arrayOfCards[i];
												if (card.getCuid()==(String)cuids.get(j)) {
													info = info+"<br>"+"<b>"+card.getName()+"</b>";
													if (card.isValueAvailable())
														ICMEntryPoint.currentState.modifySelectedCard(card);
													else {
														for (int k=0; k<card.getClaimItems().length; k++) {
															card.getClaimItems()[k].setValue("");
														}
														ICMEntryPoint.currentState.modifySelectedCard(card);
													}
													for (int m = 0; m < getCard().getClaimItems().length; m++) {
														BaseEditor editor = (BaseEditor) getBodyTable().getWidget(PCardEditablePanel.this.dimRowTable + m, 1);											
														for (int k=0; k<card.getClaimItems().length; k++) {
															Utils.addValueToMRU(editor.getClaimType(), editor.getValue());
														}
													}
												}
											}
										}
										
										HTML html = new HTML();
										html.setHTML(info.toString());
										SimpleDialog end = new SimpleDialog(html);
										end.getCancelButton().setText("Close");
										end.showDialog();
									}
								}
							}
						});
					}
					
					if (rb2.isChecked()) {
							int row = 0;
							int col = 0;
							for (int i=0; i<cards.size(); i++) {
								try {
									Card maybeCard = (Card)cards.get(i);
									CrossCardEditorPanelItem item = (CrossCardEditorPanelItem)cardsTable.getWidget(row, col);
									if (item != null && item.getCheckBox().isChecked()) {								
										//Window.alert(editor.getOldValue()+" "+editor.getValue());
										for (int j = 0; j < getCard().getClaimItems().length; j++) {
											BaseEditor editor = (BaseEditor) getBodyTable().getWidget(PCardEditablePanel.this.dimRowTable + j, 1);
											if (editor.getValue()!=null && !editor.getValue().equalsIgnoreCase(editor.getOldValue())) {
												maybeCard.getClaimItems()[j].setValue(editor.getValue());
												if (cardsToUpdate.size()<1) claimsToUpdate.add(maybeCard.getClaimItems()[j]);
											}
											if (maybeCard.getCardCredential()!= null && (maybeCard.getCardCredential().length>0)) {
												maybeCard.getCardCredential()[0].setPinCode(item.getPinBox().getText());											
											}										
										}				
										cardsToUpdate.add(new Integer(i));	
									}
									col++;
									if (col>tableWidthCount) {
										row++;
										col=0;
									}
								} catch (Exception e) {
									// TODO Auto-generated catch block
									Window.alert(e.toString());
								}									
								//cardsToUpdate.add(new Integer(i));
							}
							final CardUpdate[] cardUpdates  = new CardUpdate[cardsToUpdate.size()];
							int i=0;
							for (Iterator iterator = cardsToUpdate.iterator(); iterator.hasNext();) {
								CardUpdate update = new CardUpdate();
								Card card = (Card)cards.get(((Integer)iterator.next()).intValue());
								update.setCuid(card.getCuid());
								if (card.getCardCredential()!= null && (card.getCardCredential().length>0)) {
									update.setCredential(card.getCardCredential()[0]);
								}
								cardUpdates[i] = update;
								i++;
							}
							
							final String[] claimUpdates  = new String[claimsToUpdate.size()];
							final String[] valueUpdates  = new String[claimsToUpdate.size()];
							i=0;
							try {
								for (Iterator iterator = claimsToUpdate.iterator(); iterator.hasNext();) {
									ClaimItem item = (ClaimItem)iterator.next();
									claimUpdates[i] = item.getClaimType();
									valueUpdates[i] = item.getValue();
									i++;
							}
							} catch (Exception e) {
								Window.alert(e.toString());
							}
							
							/*final Card[] arrayOfCards = new Card[cardsToUpdate.size()];
							int i=0;
							for (Iterator iterator = cardsToUpdate.iterator(); iterator.hasNext();) {
								Integer integer = (Integer)iterator.next();
								arrayOfCards[i] = (Card)cards.get(integer.intValue());
								i++;
							}*/
							//Window.alert(arrayOfCards.toString() + " " +cardsToUpdate.size());
							Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("SendChangesLabel_HTML"));
							
							ICMEntryPoint.service.updateClaimAcrossCards(ICMEntryPoint.getUserProfile().getLoginName(), ICMEntryPoint.getUserProfile().getPassword(), claimUpdates, valueUpdates, cardUpdates, new AsyncCallback() {
								public void onFailure(Throwable arg) {
									Utils.hideWaiteDialog();
									Utils.showErrorMessage("Error: "+arg);
								}
								public void onSuccess(Object arg) {
									Utils.hideWaiteDialog();
									getDialogBox().hide();
									if (arg instanceof GWTResponse) {
										GWTResponse response = (GWTResponse) arg;
										if (response.getStatusCode().equals(new Integer(0))) {
											ListEntity entity = (ListEntity)response.getResult();
											List cuids = entity.getList();
											String info = new String("The following cards were updated:<br>");
											for (int i=0; i<cards.size(); i++) {
												for (int j=0; j<cuids.size(); j++) {
													Card card = (Card)cards.get(i);
													if (card.getCuid()==(String)cuids.get(j)) {
														info = info+"<br>"+"<b>"+card.getName()+"</b>";
														if (card.isValueAvailable())
															ICMEntryPoint.currentState.modifySelectedCard(card);
														else {
															for (int k=0; k<card.getClaimItems().length; k++) {
																card.getClaimItems()[k].setValue("");
															}
															ICMEntryPoint.currentState.modifySelectedCard(card);
														}
														for (int m = 0; m < getCard().getClaimItems().length; m++) {
															BaseEditor editor = (BaseEditor) getBodyTable().getWidget(PCardEditablePanel.this.dimRowTable + m, 1);											
															for (int k=0; k<card.getClaimItems().length; k++) {
																Utils.addValueToMRU(editor.getClaimType(), editor.getValue());
																/*for (Iterator iter = getSaveValueListenerCollection().iterator(); iter.hasNext();) {
																	SaveValueListener listener = (SaveValueListener)iter.next();
																	listener.onSave(editor.getValue());
																}*/
																}
															}
														}
													}
												}
											
											HTML html = new HTML();
											html.setHTML(info.toString());
											SimpleDialog end = new SimpleDialog(html);
											end.getCancelButton().setText("Close");
											end.showDialog();
										}
									}
								}
							});	
					}
					
					
					
					/**/
					
					
				}		
				
				
				/*getCard().setName(getCardName().getValue());
				getCard().setImage(getCardImage().getValue());
				getCard().setImageType("image/jpeg");
				for (int i = 0; i < getCard().getClaimItems().length; i++) {
					try {
						BaseEditor editor = (BaseEditor) getBodyTable().getWidget(PCardEditablePanel.this.dimRowTable + i, 1);
						getCard().getClaimItems()[i].setValue(editor.getValue());
					} catch (RuntimeException e) {
					}
				}
*/
				//Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("SendChangesLabel_HTML"));
			/*	ICMEntryPoint.service.modifyCard(getCard(), ICMEntryPoint.getUserProfile().getLoginName(), ICMEntryPoint.getUserProfile()
						.getPassword(), new GWTCallBack() {

					
					 * (non-Javadoc)
					 * 
					 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onFailure(java.lang.Throwable)
					 
					public void onFailure(Throwable arg0) {
						Utils.hideWaiteDialog();
						super.onFailure(arg0);
					}

					
					 * (non-Javadoc)
					 * 
					 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
					 
					public void onSuccess(Object res) {
						Utils.hideWaiteDialog();
						if (res instanceof GWTResponse) {
							GWTResponse response = (GWTResponse) res;
							if (response.getStatusCode().equals(new Integer(0))) {
								ICMEntryPoint.currentState.modifySelectedCard((Card) response.getResult());
							} else {
								Utils.showErrorMessage(response.getStatusMessage());
							}
						}
						if (getDialogBox() != null) {
							getDialogBox().hide();
						}
					}
				});
*/
			}
		});
		
		List categories = ICMEntryPoint.currentState.getCategory().getChildList();
	    for (Iterator iterator = categories.iterator(); iterator.hasNext();) {
			Category categoryItem = (Category) iterator.next();
			addCards(categoryItem);
		}
		drawTable();
		
		Image separator = new Image(Utils.getContextPath() + ICMEntryPoint.constant.uriImgBgHeaderOverlayForm());
		separator.setHeight("1px");
		separator.setWidth("95%");
	    updateOptionsPanel.add(new HTML("Update"));
	    //updateOptionsPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
		updateOptionsPanel.add(rb0);
		updateOptionsPanel.add(rb1);
		updateOptionsPanel.add(rb2);
		final HorizontalPanel optionsSeparator = buildGroupPanel("CARD SAVING OPTIONS");
		getBodyTable().setWidget(getBodyTable().getRowCount(), 0, optionsSeparator);
		getBodyTable().getFlexCellFormatter().setColSpan(getBodyTable().getRowCount()-1, 0, 2);
		optionsPanel.add(updateOptionsPanel);
		optionsPanel.add(cardsTablePanel);
		optionsPanel.setVisible(false);
		optionsSeparator.setVisible(false);
		
		ClickListener listener = new ClickListener() {
			public void onClick(Widget arg0) {
				cardsTablePanel.setVisible(rb2.isChecked());
			}
		};
		rb0.addClickListener(listener);
		rb1.addClickListener(listener);
		rb2.addClickListener(listener);
		
		moreOptionsButton = new SimpleButton("More options", new ClickListener() {
			public void onClick(Widget arg) {
				if (optionsPanel.isVisible()) {
					optionsPanel.setVisible(false);
					optionsSeparator.setVisible(false);
					((HTML)arg).setText("More options");
				} else {
					optionsPanel.setVisible(true);
					optionsSeparator.setVisible(true);
					((HTML)arg).setText("Less options");
				}
			}
		});
		
		/*editor.setChildHeight("80");
		editor.setWidth("80");
		getBodyTable().getFlexCellFormatter().setHorizontalAlignment(this.dimRowTable + i, 1, HasHorizontalAlignment.ALIGN_LEFT);
		*/
		getBodyTable().setWidget(getBodyTable().getRowCount(), 0, optionsPanel);
		getBodyTable().getFlexCellFormatter().setColSpan(getBodyTable().getRowCount()-1, 0, 2);
		cardsTablePanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
		optionsPanel.setSize("100%", "100%");
	    cardsTablePanel.add(cardOptions);
	    cardsTablePanel.add(separator);
	    cardsTablePanel.add(cardsTable);
	    cardsTablePanel.setSize("100%", "100%");
	    cardsTable.setSize("100%", "100%");
	    cardsTablePanel.setVisible(false);
	    cardsTablePanel.setStyleName("simpleDialog_noBorder");
	    
		rb0.setChecked(true);
		setSaveChangesButton(new CardActionButton(ICMEntryPoint.dictionary.get("SaveButton_HTML"), getSaveChangesListener()));
		//((SimpleDialog)getDialogBox()).getButtonPanel().insert(moreOptionsButton, 1);
	}
	
	public void drawTable() {
		//cardCount = 0;
		cardCounter.setHTML("");
		int row = 0;
		int col = 0;
		for (int i=0; i<cards.size(); i++) {
			CrossCardEditorPanelItem item = new CrossCardEditorPanelItem((Card)cards.get(i));
			if (item.getCard().getCuid().equals(getCard().getCuid()))
				item.getCheckBox().setChecked(true);
			cardsTable.setWidget(row, col, item);			
			item.setWidth("100%");
			col++;
			if (col>tableWidthCount) {
				row++;
				col=0;
			}
		}
		cardsTable.setSize("100%", "100%");
	}
	
	private void addCards(Category category) {
		for (Iterator iterator = category.getCardList().iterator(); iterator.hasNext();) {
			Card cardItem = (Card) iterator.next();
			if (cardItem.getCardType().equals("IPersonalInformationCard")) {cards.add(cardItem); // && !cardItem.isProtected()
			 //Window.alert(cardItem+"");
				}
		}

		for (Iterator iterator = category.getChildList().iterator(); iterator.hasNext();) {
			Category categoryItem = (Category) iterator.next();
			addCards(categoryItem);
		} 
	}

	public SimpleButton getMoreOptionsButton() {
		return moreOptionsButton;
	}

}
