package org.eclipse.higgins.ics.gwt.icm.client.panel.history;

import java.util.List;

import org.eclipse.higgins.ics.gwt.base.client.button.CardActionButton;
import org.eclipse.higgins.ics.gwt.base.client.button.DisabledNavigationButton;
import org.eclipse.higgins.ics.gwt.base.client.button.NavigationButton;
import org.eclipse.higgins.ics.gwt.base.client.button.SimpleButton;
import org.eclipse.higgins.ics.gwt.base.client.button.TableHeaderSortButton;
import org.eclipse.higgins.ics.gwt.base.client.listener.ChangeSelectedCardListener;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardInformation;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardUsage;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Category;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.GWTResponse;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.ListEntity;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class CardHistoryPanel extends Composite {

	private HTMLTable fTable = new FlexTable();

	//private static final FlexTable header = new FlexTable();

	private static final CardHistoryPanelFooter footer = new CardHistoryPanelFooter();

	private static final VerticalPanel bodyPanel = new VerticalPanel();
	
	private static final ScrollPanel tablePanel = new ScrollPanel();
	
	private static final String SORT_BY_SITE = "site";
	
	private static final String SORT_BY_DATE = "date";
	
	private static CardActionButton getHistoryButton;
	
	private static boolean busy = false;
	
	private int pageSize = 12;
	
	private int pageNumber = 0;
	
	private int pageCount = 0;
	
	private String sortBy;
	
	private String sortOrder = "ASC";

	private final Label descriptionLabel = new Label(
			ICMEntryPoint.dictionary.get("HistoryDescriptionLabel_HTML"));
	
	private final TableHeaderSortButton sortBySiteButton;
	
	private final TableHeaderSortButton sortByDateButton;
	
	public CardHistoryPanel() {
		
		sortBySiteButton = new TableHeaderSortButton(ICMEntryPoint.dictionary
				.get("HistorySitesTableUrlColumnTitle_HTML"), new ClickListener(){
			public void onClick(Widget arg){
				Utils.showWaiteDialog("Sorting...");
				ICMEntryPoint.service.getCardHistory(ICMEntryPoint.getUserProfile().getLoginName(),
						ICMEntryPoint.getUserProfile().getPassword(),
						footer.getCard().getCuid(),
						pageSize*pageNumber, pageSize, SORT_BY_SITE, sortOrder, new AsyncCallback() {
					public void onFailure(Throwable arg0) {
						Utils.hideWaiteDialog();
						Utils.showErrorMessage("Error");
					}
					
					public void onSuccess(Object arg0) {
						Utils.hideWaiteDialog();
						//Card tmpCard = footer.getCard();					
						if (((GWTResponse) arg0).getStatusCode().equals(new Integer(0))) {
							sortBy = SORT_BY_SITE;
							CardUsage[] usages = getHistoryFromListEntity((ListEntity)((GWTResponse) arg0).getResult());
							footer.getCard().getCardInformation().setCardHistory(usages);
							footer.getCard().getCardInformation().setSortBy(SORT_BY_SITE);
							footer.getCard().getCardInformation().setSortOrder(sortOrder);
							footer.getCard().getCardInformation().setStartsFrom(pageSize*pageNumber);
							ICMEntryPoint.currentState.modifyCardInCategory(footer.getCard(),ICMEntryPoint.currentState.getCategory());
							if (sortOrder.equals("ASC")) sortOrder = "DESC"; else sortOrder = "ASC";
							drawTable(usages);
						}
						
					}
				});			
			}
		});
		
		sortByDateButton = new TableHeaderSortButton(ICMEntryPoint.dictionary
				.get("HistorySitesTableUpdatedColumnTitle_HTML"), new ClickListener(){
			public void onClick(Widget arg){
				Utils.showWaiteDialog("Sorting...");
				ICMEntryPoint.service.getCardHistory(ICMEntryPoint.getUserProfile().getLoginName(),
						ICMEntryPoint.getUserProfile().getPassword(),
						footer.getCard().getCuid(),
						pageSize*pageNumber, pageSize, SORT_BY_DATE, sortOrder, new AsyncCallback() {
					public void onFailure(Throwable arg0) {
						Utils.hideWaiteDialog();
						Utils.showErrorMessage("Error");
					}
					
					public void onSuccess(Object arg0) {
						Utils.hideWaiteDialog();
						//Card tmpCard = footer.getCard();					
						if (((GWTResponse) arg0).getStatusCode().equals(new Integer(0))) {
							sortBy = SORT_BY_DATE;
							CardUsage[] usages = getHistoryFromListEntity((ListEntity)((GWTResponse) arg0).getResult());
							footer.getCard().getCardInformation().setCardHistory(usages);
							footer.getCard().getCardInformation().setSortBy(SORT_BY_DATE);
							footer.getCard().getCardInformation().setSortOrder(sortOrder);
							footer.getCard().getCardInformation().setStartsFrom(pageSize*pageNumber);
							ICMEntryPoint.currentState.modifyCardInCategory(footer.getCard(),ICMEntryPoint.currentState.getCategory());
							if (sortOrder.equals("ASC")) sortOrder = "DESC"; else sortOrder = "ASC";
							drawTable(usages);
						}
						
					}
				});		
				
			}
		});
		sortBy = SORT_BY_DATE;
		bodyPanel.setSpacing(10);
		//bodyPanel.add(new Label("Please press \"Get history\" button to retrieve history"));
		tablePanel.add(fTable);	
		
		getHistoryButton = new CardActionButton("Get history", new ClickListener() {
			public void onClick(Widget arg0) {
				getHistory();
			}
		});
		//if (footer.getUrlActionPanel().getWidgetCount() <=1)
			//footer.getUrlActionPanel().insert(getHistoryButton, 0);
		//getHistory();
		initWidget(bodyPanel);	
		final ChangeSelectedCardListener selectedCardListener = new ChangeSelectedCardListener() {
			public void onChangeSelectedCard(final Card card, final Category category) {
				footer.setCard(card);
				if (card.getCardInformation() == null) {
					sortBy = SORT_BY_DATE;
					pageNumber = 0;
					pageCount = 0;
					bodyPanel.clear();
					footer.reset();
					bodyPanel.setSpacing(10);
					//bodyPanel.add(new Label("Please press \"Get history\" button to retrieve history"));
					tablePanel.add(fTable);	
				} else {
					sortBy = card.getCardInformation().getSortBy();
					sortOrder = card.getCardInformation().getSortOrder();
					pageCount = card.getCardInformation().getHistorySize()/pageSize;
					pageNumber = card.getCardInformation().getStartsFrom()/pageSize;
					drawTable(card.getCardInformation().getCardHistory());
				}
			}
		};
		ICMEntryPoint.currentState.addChangeSelectedCardListener(selectedCardListener);
	}

	public void getHistory() {
		if (footer.getCard() != null && !busy) {
			Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("HistoryLoadingWaitLabel_HTML"));
			busy = true;
				ICMEntryPoint.service.getCardInformation(footer.getCard().getCuid(),
						ICMEntryPoint.getUserProfile().getLoginName(),
						ICMEntryPoint.getUserProfile().getPassword(), pageSize,
						new AsyncCallback() {
							public void onFailure(Throwable arg0) {
								Utils.hideWaiteDialog();
								Utils.showErrorMessage("ERROR - Cannot get card info");
								busy = false;
							};

							public void onSuccess(Object arg) {
								Utils.hideWaiteDialog();
								busy = false;
								if (((GWTResponse) arg).getStatusCode().equals(new Integer(0))) {
									Card tmpCard = footer.getCard();
									footer.reset();
									tmpCard.setCardInformation(((CardInformation) ((GWTResponse) arg)
													.getResult()));
									footer.setCard(tmpCard);
									ICMEntryPoint.currentState.modifyCardInCategory(tmpCard,ICMEntryPoint.currentState.getCategory());
									
									CardInformation info = ((CardInformation) ((GWTResponse) arg)
											.getResult());
									CardUsage[] usages = info.getCardHistory();
									pageCount = (((CardInformation) ((GWTResponse) arg).getResult())).getHistorySize()/pageSize;
									drawTable(usages);
								}
								
								else {
									Utils.showErrorMessage("ERROR - Cannot get card info");
								}
								
							};
						});
				}		
	}
	
	

	public Widget getCardHistoryWidget() {
		return this;
	}

	private static String getDomainFromUrl(String url) {
		return url.substring(url.indexOf("://") + 3, url.indexOf("/", url.indexOf("://") + 3));
	}

	private static String getDomainLinkFromUrl(String url) {
		return "<A HREF=\"" + url + "\">" + getDomainFromUrl(url) + "</A>";
	}
	
	private static String getUrlFromDomainLink(String link)
	{
		String url = link.substring(link.indexOf("HREF=\"")+10, link.indexOf("\">", link.indexOf(link.indexOf("HREF=\"")+10)));
		return url;
	}

	private void drawTable(CardUsage[] usages) {
		if ((usages != null) && (usages.length >0))  {
			try {
				bodyPanel.clear();
				fTable.clear();
				bodyPanel.setHeight("100%");
				bodyPanel.setWidth("100%");
				fTable.setCellSpacing(0);
				bodyPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
				fTable.setWidth("100%");
				bodyPanel.add(descriptionLabel);
				bodyPanel.add(tablePanel);
				//bodyPanel.add(header);
				HorizontalPanel siteLabel = new HorizontalPanel();
				siteLabel.add(sortBySiteButton);
				siteLabel.setSpacing(3);
				siteLabel.setWidth("100%");
				siteLabel.setStyleName("tableHistoryHeader");
				siteLabel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
				if (sortBy.equals(SORT_BY_SITE) && sortOrder.equals("DESC"))siteLabel.add(new Image(ICMEntryPoint.constant.uriImgMenuSpinOpen()));
				if (sortBy.equals(SORT_BY_SITE) && sortOrder.equals("ASC"))siteLabel.add(new Image(ICMEntryPoint.constant.uriImgMenuSpinUp()));
				
				HorizontalPanel dateLabel = new HorizontalPanel();
				dateLabel.add(sortByDateButton);
				dateLabel.setSpacing(3);
				dateLabel.setWidth("90px");
				dateLabel.setStyleName("tableHistoryHeader");
				dateLabel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);				
				if (sortBy.equals(SORT_BY_DATE) && sortOrder.equals("DESC"))dateLabel.add(new Image(ICMEntryPoint.constant.uriImgMenuSpinOpen()));
				if (sortBy.equals(SORT_BY_DATE) && sortOrder.equals("ASC"))dateLabel.add(new Image(ICMEntryPoint.constant.uriImgMenuSpinUp()));
				
				final Label useLabel = new Label(ICMEntryPoint.dictionary.get("HistorySitesTableUseEveryTimeColumnTitle_HTML"));
				useLabel.setWidth("90px");
				useLabel.setStyleName("tableHistoryHeader");
				fTable.setWidget(0, 0, siteLabel);
				fTable.setWidget(0, 1, dateLabel);
				fTable.setWidget(0, 2, useLabel);
				//fTable.getColumnFormatter().setWidth(1, "200px");
				//fTable.getColumnFormatter().setWidth(2, "200px");
				//header.getColumnFormatter().setWidth(0, "100%");
				fTable.getColumnFormatter().setWidth(0, "100%");
				int col = 0;
				for (int i = 0; i < usages.length; i++) {
					
					HTML siteUrl = new HTML(
							getDomainLinkFromUrl(usages[i].getSite()));
					siteUrl.addStyleName("siteURL");
					final Label dateL = new Label(usages[i].getDate());
					dateL.setWidth("90px");
					fTable.setWidget(col + 1, 0, siteUrl);
					fTable.setWidget(col + 1, 1, dateL);
					siteUrl.setStyleName("tableHistory");
					dateL.setStyleName("tableHistory");
					if (usages[i].isSaved()) {
						final int ii = col;
						SimpleButton noUseButton = new SimpleButton(ICMEntryPoint.dictionary.get("ForgetCardForSiteButton_HTML"), new ClickListener() {
						public void onClick(Widget arg0) {
								String[] s = new String[1];
								s[0] = footer.getCard().getCardInformation().getCardHistory()[ii].getSite();
								Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("HistoryModifyingLabel_HTML"));
								ICMEntryPoint.service.deleteUrlsCardRelation(ICMEntryPoint
										.getUserProfile().getLoginName(), ICMEntryPoint
										.getUserProfile().getPassword(), footer.getCard()
										.getCuid(), s, new AsyncCallback() {
									public void onSuccess(Object arg) {
										Utils.hideWaiteDialog();
										((FlexTable)fTable).removeCell(ii+1, 2);
										final Label dummy = new Label();
										dummy.setWidth("90px");
										dummy.setStyleName("tableHistory");
										fTable.setWidget(ii + 1, 2, dummy);
									}

									public void onFailure(Throwable arg) {
										Utils.hideWaiteDialog();
										Utils.showErrorMessage("ERROR - Cannot delete card info");
									}
								});
						}
					});
					HorizontalPanel noUseButtonPanel = new HorizontalPanel();
					noUseButtonPanel.setHeight("100%");
					noUseButtonPanel.setStyleName("tableHistory");
					noUseButtonPanel.add(noUseButton);
					fTable.setWidget(col + 1, 2, noUseButtonPanel);
					} else {
						final Label dummy = new Label();
						dummy.setWidth("90px");
						dummy.setStyleName("tableHistory");
						fTable.setWidget(col + 1, 2, dummy);
					}
					fTable.getRowFormatter().addStyleName(col + 1,"tableHistory");
					col++;
					
				}
				//header.getRowFormatter().addStyleName(0,"tableHistoryHeader");
				
				footer.setPageLabel(this.pageNumber, this.pageCount);
				if (pageNumber == 0) footer.setPreviousPageButton(new DisabledNavigationButton(ICMEntryPoint.dictionary.get("HistoryPreviousPageButton_HTML"), null, "left"));
				else footer.setPreviousPageButton(new NavigationButton(ICMEntryPoint.dictionary.get("HistoryPreviousPageButton_HTML"), new ClickListener(){
					public void onClick(Widget arg)
					{
						Utils.showWaiteDialog("Please wait...");
						ICMEntryPoint.service.getCardHistory(ICMEntryPoint.getUserProfile().getLoginName(),
								ICMEntryPoint.getUserProfile().getPassword(),
								footer.getCard().getCuid(),
								pageSize*(pageNumber-1), pageSize, 
								sortBy, sortOrder, new AsyncCallback() {
									public void onFailure(Throwable arg0) {
										Utils.hideWaiteDialog();
										Utils.showErrorMessage("Error");
									}
									
									public void onSuccess(Object arg0) {
										Utils.hideWaiteDialog();
										if (((GWTResponse) arg0).getStatusCode().equals(new Integer(0))) {
											CardUsage[] usages = getHistoryFromListEntity((ListEntity)((GWTResponse) arg0).getResult());
											footer.getCard().getCardInformation().setCardHistory(usages);
											footer.getCard().getCardInformation().setSortBy(sortBy);
											footer.getCard().getCardInformation().setSortOrder(sortOrder);
											footer.getCard().getCardInformation().setStartsFrom(pageSize*(pageNumber-1));
											ICMEntryPoint.currentState.modifyCardInCategory(footer.getCard(),ICMEntryPoint.currentState.getCategory());
											pageNumber--;
											drawTable(usages);
										}
										
									}
								});
					}
				}, "left"));
				if (pageNumber == pageCount) footer.setNextPageButton(new DisabledNavigationButton(ICMEntryPoint.dictionary.get("HistoryNextPageButton_HTML"), null, "right"));
				else footer.setNextPageButton(new NavigationButton(ICMEntryPoint.dictionary.get("HistoryNextPageButton_HTML"), new ClickListener(){
					public void onClick(Widget arg)
					{
						Utils.showWaiteDialog("Please wait...");
						ICMEntryPoint.service.getCardHistory(ICMEntryPoint.getUserProfile().getLoginName(),
								ICMEntryPoint.getUserProfile().getPassword(),
								footer.getCard().getCuid(),
								pageSize*(pageNumber+1), pageSize, 
								sortBy, sortOrder, new AsyncCallback() {
									public void onFailure(Throwable arg0) {
										Utils.hideWaiteDialog();
										Utils.showErrorMessage("Error");
									}
									
									public void onSuccess(Object arg0) {
										Utils.hideWaiteDialog();
										if (((GWTResponse) arg0).getStatusCode().equals(new Integer(0))) {
											CardUsage[] usages = getHistoryFromListEntity((ListEntity)((GWTResponse) arg0).getResult());
											footer.getCard().getCardInformation().setCardHistory(usages);
											footer.getCard().getCardInformation().setSortBy(sortBy);
											footer.getCard().getCardInformation().setSortOrder(sortOrder);
											footer.getCard().getCardInformation().setStartsFrom(pageSize*(pageNumber+1));
											ICMEntryPoint.currentState.modifyCardInCategory(footer.getCard(),ICMEntryPoint.currentState.getCategory());
											pageNumber++;
											drawTable(usages);
										}
										
									}
								});
					}
				}, "right"));
				//bodyPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
				//bodyPanel.add(footer);
			} catch (Exception e) {
				
			}
		}
		else {
			bodyPanel.clear();
			bodyPanel.add(new Label("Card history for this card is empty"));
		}
	}
	
	/*public static String[] getSelectedUrls()
	{
		String[] uurls = new String[0];
		CardUsage[] usages = footer.getCard().getCardInformation().getCardHistory();
		if (fTable.getRowCount() > 1) {
			
			ArrayList urls = new ArrayList(0);
			for (int i = 0; i < fTable.getRowCount() - 1; i++) {
				if (((CheckBox) fTable.getWidget(i + 1, 2)).isChecked())
					//urls.add(getUrlFromDomainLink(((HTML)fTable.getWidget(i + 1, 0)).getHTML()));
					urls.add(usages[i].getSite());
					
			}
			uurls = new String[urls.size()];
			for (int i = 0; i < urls.size(); i++)
				uurls[i] = (String)urls.get(i);
				
		}
		return uurls;
		
	}
*/	
	public int getPageNumber()
	{
		return this.pageNumber;
	}
	
	/*private CardUsage[] sortBySite(CardUsage[] usages, boolean sortUp)
	{
		for (int i=0; i< usages.length; i++)
		{
			for (int j=0; j< usages.length; j++)
			{
				int compare = usages[i].getSite().toLowerCase().compareTo(
						usages[j].getSite().toLowerCase());
				if (compare<0 && sortUp)
				{
					CardUsage u = usages[i];
					usages[i] = usages[j];
					usages[j] = u;
				}
				if (compare>0 && !sortUp)
				{
					CardUsage u = usages[j];
					usages[j] = usages[i];
					usages[i] = u;
				}
			}
		}
		return usages;
	}
	
	
	private CardUsage[] sortByDate(CardUsage[] usages, boolean sortUp)
	{
		for (int i=0; i< usages.length; i++)
		{
			for (int j=0; j< usages.length; j++)
			{
				int compare = usages[i].getDate().toLowerCase().compareTo(
						usages[j].getDate().toLowerCase());
				if (compare<0 && sortUp)
				{
					CardUsage u = usages[i];
					usages[i] = usages[j];
					usages[j] = u;
				}
				if (compare>0 && !sortUp)
				{
					CardUsage u = usages[j];
					usages[j] = usages[i];
					usages[i] = u;
				}
			}
		}
		return usages;
	}*/
	
	public CardHistoryPanelFooter getCardHistoryFooter() {
		return footer;
	}	
	
	private CardUsage[] getHistoryFromListEntity(ListEntity entity) {
		List historyList = entity.getList();
		CardUsage[] usages = new CardUsage[historyList.size()];
		for (int i=0; i<historyList.size(); i++) {
			usages[i] = (CardUsage)historyList.get(i);
		}
		return usages;
	}
}
