/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Alexander Yuhimenko - implementation
 */
package org.eclipse.higgins.ics.model.servlet;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.axis.encoding.Base64;
import org.eclipse.higgins.ics.model.bean.ManagerBean;

/**
 * 
 * @author Alexander Yuhimenko
 * 
 * Servlet implementation class for Servlet: PaintLogo
 * 
 * @web.servlet name="PaintLogo" display-name="PaintLogo"
 * 
 * @web.servlet-mapping url-pattern="/paint-logo"
 * 
 */
public class PaintLogoServlet extends javax.servlet.http.HttpServlet implements javax.servlet.Servlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8231667348984956047L;
	String image = new String();
	ManagerBean bean = new ManagerBean();
	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public PaintLogoServlet() {
		super();
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		int contentLength = request.getContentLength();
		InputStream in = request.getInputStream();
		try {
			byte[] payload = new byte[contentLength];
			int offset = 0;
			int len = contentLength;
			int byteCount;
			while (offset < contentLength) {
				byteCount = in.read(payload, offset, len);
				if (byteCount == -1) {
					throw new ServletException("Client did not send " + contentLength + " bytes as expected");
				}
				offset += byteCount;
				len -= byteCount;
			}
			image = new String(payload, "UTF-8");
		} finally {
			if (in != null) {
				in.close();
			}
		}
		request.getSession().setAttribute(image.substring(image.length()-20), image);
		//bean.putToImage(image);
	}
	
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		String data = request.getParameter("cdata");
		Object img = request.getSession().getAttribute(data);
		image = (String)img;
		//image = bean.getFromImage();
		if (image != null) {
			byte[] b = Base64.decode(image);
			InputStream i = new ByteArrayInputStream(b);
			BufferedImage im = ImageIO.read(i);
			ImageIO.write(im, "jpeg", response.getOutputStream());
			
			//response.getOutputStream().write(resizeTo80X120InBytes(Base64.decode(image)));
		}
	}
	
	
}