package org.eclipse.higgins.ics.gwt.base.client.editor;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.ui.ListBox;

public class ComboBoxEditor extends BaseEditor {
	
	public static List genderOptions = new ArrayList(2);
	static {
		genderOptions.add("Male");
		genderOptions.add("Female");
	}
	
	public ComboBoxEditor() {
		super();
		editor = new ListBox();
		editor.setStyleName(STYLE_COMBO_BOX_EDITOR);
		((ListBox)editor).setMultipleSelect(false);
		setOptions(genderOptions);
		add(editor);
	}
	
	public void setOptions(List options) {
		if (options != null) {
			((ListBox)editor).clear();
			((ListBox)editor).addItem("<Select a value...>");
			for (int i=0; i<options.size(); i++) {
				String val = (String)options.get(i);
				if (val != null) ((ListBox)editor).addItem(val);
			}
		}
	}
	
	public String getTypeEditor() {
		// TODO Auto-generated method stub
		return null;
	}

	public String getValue() {
		String value = ((ListBox)editor).getItemText(((ListBox)editor).getSelectedIndex());
		if (value.equals("<Select a value...>")) return "";
		return value;
	}

	public void setValue(String val) {
		if (val != null) {
			for (int i=0; i<((ListBox)editor).getItemCount(); i++) {
				if (val.equals(((ListBox)editor).getValue(i))) {
					((ListBox)editor).setSelectedIndex(i); break;
				}
			}
		} else {
			((ListBox)editor).setSelectedIndex(0);
		}
	}
	
	public void setVisibleItemCount(int count) {
		((ListBox)editor).setVisibleItemCount(count);		
	}

}
