/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.base.client.editor;

import org.eclipse.higgins.ics.gwt.base.client.BaseConstant;
import org.eclipse.higgins.ics.gwt.base.client.button.CardActionButton;
import org.eclipse.higgins.ics.gwt.base.client.button.SimpleButton;
import org.eclipse.higgins.ics.gwt.base.client.dialog.SimpleDialog;
import org.eclipse.higgins.ics.gwt.base.client.panel.RoundedPanelDialog;
import org.eclipse.higgins.ics.gwt.base.client.panel.WaitPanel;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FormHandler;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.FormSubmitCompleteEvent;
import com.google.gwt.user.client.ui.FormSubmitEvent;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class ImageEditor extends BaseEditor {

	private String base64ImageData;

	private SimpleButton changeButton;

	private TextBox childHeightTextBox = new TextBox();

	private TextBox childWidthTextBox = new TextBox();

	private SimpleDialog choseFileDialog;

	private FormPanel form = new FormPanel();

	private HorizontalPanel formPanel = new HorizontalPanel();
	
	private VerticalPanel layoutPanel = new VerticalPanel();

	private Image image = new Image();

	private final WaitPanel wait = new WaitPanel(ICMEntryPoint.dictionary.get("UploadingFileLabel_HTML"));

	private DialogBox waitBox = new DialogBox();

	private FileUpload upload = new FileUpload();

	private final BaseConstant constant = (BaseConstant) GWT.create(BaseConstant.class);

	private final CardActionButton uploadImageButton = new CardActionButton(ICMEntryPoint.dictionary.get("UploadButton_HTML"),
			new ClickListener() {

				/*
				 * (non-Javadoc)
				 * 
				 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
				 */
				public void onClick(Widget arg0) {
					getForm().submit();
				}
			});
	/**
	 * 
	 */
	public ImageEditor() {
		super();
		try {
			buildForm();

			setChangeButton(new SimpleButton(ICMEntryPoint.dictionary.get("ChoosePictureButton_HTML"), new ClickListener() {
				/*
				 * (non-Javadoc)
				 * 
				 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
				 */
				public void onClick(Widget arg0) {
					
					setChoseFileDialog(new SimpleDialog(layoutPanel));
					getChoseFileDialog().setText(ICMEntryPoint.dictionary.get("ChoosePictureButton_HTML"));
					getChoseFileDialog().getButtonPanel().insert(uploadImageButton, 2);
					getChoseFileDialog().showDialog();

				}

			}));

			add(this.getChangeButton());
			this.editor = new TextBox();
		} catch (Exception e) {
			// TODO Auto-generated catch block
		}
	}

	/**
	 * 
	 */
	private void buildForm() {
		getForm().setAction(Utils.getContextPath() + "img2string");
		getForm().setEncoding(FormPanel.ENCODING_MULTIPART);
		getForm().setMethod(FormPanel.METHOD_POST);
		getUpload().setName("imageFile");
		DOM.setElementAttribute(getUpload().getElement(), "size", "45");
		getUpload().setStyleName("imageFile");
		formPanel.add(getUpload());
		getChildWidthTextBox().setName("childWidth");
		getChildWidthTextBox().setVisible(false);
		formPanel.add(getChildWidthTextBox());

		getChildHeightTextBox().setName("childHeight");
		getChildHeightTextBox().setText(getChildHeight());
		getChildHeightTextBox().setVisible(false);
		formPanel.add(getChildHeightTextBox());

		getForm().setWidget(formPanel);
		layoutPanel.add(getForm());
		layoutPanel.setHorizontalAlignment(ALIGN_RIGHT);
		layoutPanel.add(new Label("Select a .gif or .jpg image file"));
		getForm().addFormHandler(new FormHandler() {
			public void onSubmit(FormSubmitEvent event) {
				if (getUpload().getFilename() != null
						&& (getUpload().getFilename().toLowerCase().endsWith("jpeg")
								|| getUpload().getFilename().toLowerCase().endsWith("jpg") || getUpload().getFilename().toLowerCase()
								.endsWith("gif"))) {
					if (!Utils.isIE())
						Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("UploadingFileLabel_HTML"));
					else
						showSafeProgressPopup();
					// image.setUrl(Utils.getContextPath() + Utils.baseConstant.uriImgProgress());
				} else {
					event.setCancelled(true);
					Utils.showErrorMessage("Supported only <b>jpeg</b> and <b>gif</b> images. <br> Please, choose other file.");
				}
			}

			public void onSubmitComplete(FormSubmitCompleteEvent event) {
				if (!Utils.isIE())
					Utils.hideWaiteDialog();
				else
					hideSafeProgressPopup();
				String response = event.getResults();
				if (!Utils.isIE() && response != null && response.length() > 10) {
					response = response.substring(5, response.length() - 6);
				}
				if (response == null || response.startsWith("Error")) {
					Utils.showErrorMessage(response);
				} else {
					ImageEditor.this.setValue(response);
					getChoseFileDialog().hide();
				}
			}
		});
		getUpload().setVisible(true);
	}

	/**
	 * @return the changeButton
	 */
	private SimpleButton getChangeButton() {
		return this.changeButton;
	}

	/**
	 * @return the childHeightTextBox
	 */
	private TextBox getChildHeightTextBox() {
		return this.childHeightTextBox;
	}

	/**
	 * @return the childWidthTextBox
	 */
	private TextBox getChildWidthTextBox() {
		return this.childWidthTextBox;
	}

	/**
	 * @return the choseFileDialog
	 */
	public SimpleDialog getChoseFileDialog() {
		return this.choseFileDialog;
	}

	/**
	 * @return the form
	 */
	FormPanel getForm() {
		return this.form;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor#getTypeEditor()
	 */
	public String getTypeEditor() {
		return IMAGE_EDITOR;
	}

	/**
	 * @return the upload
	 */
	FileUpload getUpload() {
		return this.upload;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor#getValue()
	 */
	public String getValue() {
		return this.base64ImageData;
	}

	/**
	 * @param changeButton
	 *            the changeButton to set
	 */
	private void setChangeButton(SimpleButton changeButton) {
		this.changeButton = changeButton;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor#setChildHeight(java.lang.String)
	 */
	public void setChildHeight(String childHeight) {
		super.setChildHeight(childHeight);
		this.getChildHeightTextBox().setText(getChildHeight());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor#setChildWidth(java.lang.String)
	 */
	public void setChildWidth(String childWidth) {
		super.setChildWidth(childWidth);
		this.getChildWidthTextBox().setText(getChildWidth());
	}

	/**
	 * @param choseFileDialog
	 *            the choseFileDialog to set
	 */
	public void setChoseFileDialog(SimpleDialog choseFileDialog) {
		this.choseFileDialog = choseFileDialog;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor#setReadOnly(boolean)
	 */
	public void setReadOnly(boolean isReadOnly) {
		super.setReadOnly(isReadOnly);
		getChangeButton().setVisible(!isReadOnly);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor#setValue(java.lang.String)
	 */
	public void setValue(String val) {
		if (val == null || val.equals("")) {
			val = "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";
		}
		
		/*Safari fix*/
		if (val != null && val.indexOf(";")!= -1) {
			val = val.substring(val.lastIndexOf(";")+3);
		}
		/*ie fix*/
		if (val!=null && val.indexOf("<PRE>")!=-1) {
			val = val.substring(5, val.length()-6);
		}
		//Window.alert(val);
		try {
			this.base64ImageData = val;
			final String logoAddress = constant.servletPaintLogoAddress() + "?cdata=" + val.substring(val.length() - 20).replace('+', '_').replace('=','_');
			if (Utils.isIE()) {
				//image.setUrl(Utils.getContextPath() + Utils.baseConstant.uriImgProgress());
				ICMEntryPoint.service.putImageForIE(val, new AsyncCallback() {
					public void onSuccess(Object arg0) {
						image.setUrl(logoAddress);
					}

					public void onFailure(Throwable arg0) {
						image.setVisible(false);
					}
				});
			}
			/*
			 * if (Utils.isIE()) { if (val != null) { image.setUrl(constant.servletPaintLogoAddress() + "?cdata=" +
			 * val.substring(val.length() - 20)); image.setVisible(true); } else image.setVisible(false); }
			 */else {
				DOM.setElementAttribute(this.image.getElement(), "src", "data:image/jpeg;base64," + val);
				/*image.setWidth("60px");
				image.setHeight("60px");*/
			}
			
			insert(this.image, 0);
		} catch (Exception e) {
			// TODO Auto-generated catch block
		}
		// insert(this.image, 0);
		// DOM.setElementAttribute(this.image.getElement(), "src",
		// "data:image/jpeg;base64," + val);
	}

	private void showSafeProgressPopup() {
		RoundedPanelDialog roundedPanel = new RoundedPanelDialog(wait);
		waitBox.setWidget(roundedPanel);
		DOM.setIntStyleAttribute(waitBox.getElement(), "zIndex", 999999);
		waitBox.show();
		waitBox.setPopupPosition((Utils.rootWidth - waitBox.getOffsetWidth()) / 2, (Utils.rootHeight - waitBox.getOffsetHeight()) / 2);
		;
	}

	private void hideSafeProgressPopup() {
		waitBox.hide();
	}
}
