/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.base.client.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

import org.eclipse.higgins.ics.gwt.base.client.listener.AddCardListener;
import org.eclipse.higgins.ics.gwt.base.client.listener.AddCategoryListener;
import org.eclipse.higgins.ics.gwt.base.client.listener.ChangeSelectedCardListener;
import org.eclipse.higgins.ics.gwt.base.client.listener.DeleteCardListener;
import org.eclipse.higgins.ics.gwt.base.client.listener.DeleteCategoryListener;
import org.eclipse.higgins.ics.gwt.base.client.listener.ModifyCategoryListListener;
import org.eclipse.higgins.ics.gwt.base.client.listener.ModifyCategoryListener;
import org.eclipse.higgins.ics.gwt.base.client.listener.ModifySelectedCardListener;
import org.eclipse.higgins.ics.gwt.base.client.listener.RemoveCardListener;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Category;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CurrentState;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;
import org.eclipse.higgins.ics.gwt.icm.client.RPCUtils;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class CurrentStateBean {

	private ArrayList addCardList = new ArrayList();

	private ArrayList addCategoryList = new ArrayList();

	private ArrayList changeSelectedCardList = new ArrayList();

	private CurrentState currentState;
	
	private String defaultPCardUid = null;

	private ArrayList deleteCardList = new ArrayList();

	private ArrayList modifyCategoriesList = new ArrayList();

	private ArrayList deleteCategoryList = new ArrayList();

	private ArrayList modifySelectedCardList = new ArrayList();

	private ArrayList modifyCategoryList = new ArrayList();

	private ArrayList removeCardList = new ArrayList();
	
	private HashSet mrus;

	/**
	 * 
	 */
	public CurrentStateBean(CurrentState currentState) {
		super();
		this.currentState = currentState;
	}

	public boolean addAddCardListener(AddCardListener addCardListener) {
		return this.addCardList.add(addCardListener);
	}

	public boolean addAddCategoryListener(
			AddCategoryListener addCategoryListener) {
		return this.addCategoryList.add(addCategoryListener);
	}

	public boolean addModifyCategoryListListener(
			ModifyCategoryListListener modifyCategoryListListener) {
		return this.modifyCategoriesList.add(modifyCategoryListListener);
	}

	public void addCategory(Category category) {
		try {
			getCategory().getChildList().add(category);
			for (Iterator iterator = getAddCategoryList().iterator(); iterator
					.hasNext();) {
				AddCategoryListener addCategoryListener = (AddCategoryListener) iterator
						.next();
				try {
					addCategoryListener.onAddCategory(category);
				} catch (Exception e) {
				}
			}

		} catch (RuntimeException e) {
		}
	}

	/**
	 * @param changeSelectedCardListener
	 * @return
	 */
	public boolean addChangeSelectedCardListener(
			ChangeSelectedCardListener changeSelectedCardListener) {
		return this.changeSelectedCardList.add(changeSelectedCardListener);
	}

	/**
	 * @param e
	 * @return
	 * @see java.util.ArrayList#add(java.lang.Object)
	 */
	public boolean addDeleteCardListener(DeleteCardListener deleteCardListener) {
		return this.deleteCardList.add(deleteCardListener);
	}

	/**
	 * @param o
	 * @return
	 * @see java.util.ArrayList#add(java.lang.Object)
	 */
	public boolean addDeleteCategoryListener(
			DeleteCategoryListener deleteCategoryListener) {
		return this.deleteCategoryList.add(deleteCategoryListener);
	}

	/**
	 * @param changeSelectedCardListener
	 * @return
	 */
	public boolean addModifySelectedCardListener(
			ModifySelectedCardListener modifySelectedCardListener) {
		return this.modifySelectedCardList.add(modifySelectedCardListener);
	}

	public boolean addModifyCategoryListener(
			ModifyCategoryListener modifyCategoryListener) {
		return this.modifyCategoryList.add(modifyCategoryListener);
	}

	public void modifyCategory(Category category) {
		try {
			for (Iterator iterator = this.modifyCategoryList.iterator(); iterator
					.hasNext();) {
				ModifyCategoryListener modifyCategoryListener = (ModifyCategoryListener) iterator
						.next();
				try {
					modifyCategoryListener.onModifyCategory(category);
				} catch (Exception e) {
				}
			}
			getCategory().getChildList().set(
					getCategory().getChildList().indexOf(category), category);

		} catch (RuntimeException e) {
		}
	}

	public boolean addNewCard(final Card card, boolean overwriteExists) {
		// final Category category;
		boolean exists = false;
		for (int i=0; i<getCategory().getChildList().size(); i++) {
			Category category = (Category) getCategory().getChildList().get(i);
			if (card.getCardType().equals("IPersonalInformationCard")
					&& category.getType()!= null && category.getType().indexOf("p--pers")>-1) {
				exists = addNewCard(card, category, overwriteExists);
			}
			if ((card.getCardType().equals("IManagedInformationCard"))
					&& category.getType()!= null && category.getType().indexOf("p--webs")>-1) {
				exists = addNewCard(card, category, overwriteExists);
			}
			if ((card.getCardType().equals("IPwmCard"))
					&& category.getType()!= null && category.getType().indexOf("p--pass")>-1) {
				exists = addNewCard(card, category, overwriteExists);
			}
		}
		return exists;
		/*ICMEntryPoint.service.getMessageAttribute(attrs, new AsyncCallback() {
			public void onSuccess(Object arg0) {
				String[] attrsReal = (String[]) ((Response) arg0).getResult();
				
			}

			public void onFailure(Throwable arg0) {
				Window.alert("damn");
			}
		});*/

	}
	
	public boolean addNewCard(final Card card) {
		return addNewCard(card, true);

	}

	public boolean addNewCard(Card card, Category category) {
		return addNewCard(card, category, true);
	}
	
	public boolean addNewCard(Card card, Category category, boolean overwriteExists) {
		boolean exists = false;
		try {
			for (Iterator iter = category.getCardList().iterator(); iter.hasNext();) 
			{
				Card aCard = (Card)iter.next();
				exists = aCard.getCuid().equals(card.getCuid());
				if (exists)	{
					if (overwriteExists) 
						deleteCard(aCard);
					else
							return exists;					
				}
			}
			
			/*if (exists) {
				Utils.showErrorMessage("The card \""+card.getName()+"\" already exists and will be overwritten!");
			} */
			category.getCardList().add(card);
			for (Iterator iterator = getAddCardList().iterator(); iterator
					.hasNext();) {
				AddCardListener addCardListener = (AddCardListener) iterator
					.next();
				try {
					addCardListener.onAddCard(card, category);
				} catch (Exception e) {
			}
		} 
		} catch (Exception e) {
		}
		return exists;	
		
	}

	public void modifyCategoryList(List categoryList) {
		try {
			getCategory().setChildList(categoryList);
			for (Iterator iterator = getModifyCategoriesList().iterator(); iterator
					.hasNext();) {
				ModifyCategoryListListener modifyCategoryListListener = (ModifyCategoryListListener) iterator
						.next();
				try {
					modifyCategoryListListener
							.onModifyCategoryList(categoryList);
				} catch (Exception e) {
				}
			}
		} catch (Exception e) {
		}
	}

	/**
	 * @param o
	 * @return
	 * @see java.util.ArrayList#add(java.lang.Object)
	 */
	public boolean addRemoveCardListener(RemoveCardListener cardListener) {
		return this.removeCardList.add(cardListener);
	}

	public void deleteAllCard() {
		deleteAllCardInCategory(getCategory());
	}

	private void deleteAllCardInCategory(Category category) {
		try {
			for (Iterator iterator = category.getChildList().iterator(); iterator
					.hasNext();) {
				Category categoryItem = (Category) iterator.next();
				deleteAllCardInCategory(categoryItem);
			}

			for (Iterator iterator = category.getCardList().iterator(); iterator
					.hasNext();) {
				Card cardItem = (Card) iterator.next();
				for (Iterator deleteIterator = getDeleteCardList().iterator(); deleteIterator
						.hasNext();) {
					DeleteCardListener deleteCardListener = (DeleteCardListener) deleteIterator
							.next();
					try {
						deleteCardListener.onDeleteCardListener(cardItem,
								category);
					} catch (Exception e) {
					}
				}
				category.getCardList().remove(cardItem);
			}
		} catch (RuntimeException e) {
		}

	}

	public void deleteCard(Card card) {
		try {
			// Category category = getSelectedCategory();

			for (Iterator iterator = getDeleteCardList().iterator(); iterator
					.hasNext();) {
				DeleteCardListener deleteCardListener = (DeleteCardListener) iterator
						.next();
				try {
					deleteCardListener.onDeleteCardListener(card,
							getSelectedCategory());
				} catch (RuntimeException e) {
				}
			}
			for (Iterator iterator = getCategory().getChildList().iterator(); iterator
					.hasNext();) {
				Category categoryItem = (Category) iterator.next();
				try {
					categoryItem.getCardList().remove(card);
				} catch (Exception e) {
				}
				// for (Iterator iterator2 =
				// categoryItem.getCardList().iterator(); iterator2.hasNext();)
				// {
				// Card cardItem = (Card) iterator2.next();
				// if (cardItem.getCuid().equals(card.getCuid())) {
				// categoryItem.getCardList().remove(card);
				// }
				// }
			}
		} catch (RuntimeException e) {
		}
	}

	public void deleteCategory(Category category) {
		for (Iterator iterator = getDeleteCategoryList().iterator(); iterator
				.hasNext();) {
			DeleteCategoryListener deleteCategoryListener = (DeleteCategoryListener) iterator
					.next();
			try {
				deleteCategoryListener.onDeleteCategory(category);
			} catch (RuntimeException e) {
			}
		}
		getCategory().getChildList().remove(category);
		// if (category.getCardList().si)
		for (Iterator iterator = category.getCardList().iterator(); iterator
				.hasNext();) {
			Card cardItem = (Card) iterator.next();
			addNewCard(cardItem);
		}
	}

	private void fireSelectedCardListeners(Card card) {
		for (Iterator iterator = getModifySelectedCardList().iterator(); iterator
				.hasNext();) {
			ModifySelectedCardListener modifySelectedCardListener = (ModifySelectedCardListener) iterator
					.next();
			try {
				modifySelectedCardListener.onModifySelectedCard(card);
			} catch (Exception e) {
			}
		}
	}

	/**
	 * @return the addCardList
	 */
	public ArrayList getAddCardList() {
		return this.addCardList;
	}

	public ArrayList getAddCategoryList() {
		return this.addCategoryList;
	}

	/**
	 * @return
	 * @see org.eclipse.higgins.ics.gwt.base.client.model.entity.CurrentState#getCategory()
	 */
	public Category getCategory() {
		return this.currentState.getCategory();
	}

	public List getCategoryList(Category category) {
		List list = new ArrayList();
		for (Iterator iterator = category.getChildList().iterator(); iterator
				.hasNext();) {
			Category categoryItem = (Category) iterator.next();
			list.add(categoryItem);
			list.addAll(getCategoryList(categoryItem));
		}
		return list;
	}

	/**
	 * @return the changeSelectedCardList
	 */
	public ArrayList getChangeSelectedCardList() {
		return changeSelectedCardList;
	}

	/**
	 * @return the deleteCardList
	 */
	public ArrayList getDeleteCardList() {
		return this.deleteCardList;
	}

	/**
	 * @return the deleteCategoryList
	 */
	public ArrayList getDeleteCategoryList() {
		return this.deleteCategoryList;
	}

	/**
	 * @return the modifySelectedCardList
	 */
	public ArrayList getModifySelectedCardList() {
		return this.modifySelectedCardList;
	}

	public ArrayList getModifyCategoriesList() {
		return this.modifyCategoriesList;
	}

	/**
	 * @return
	 * @see org.eclipse.higgins.ics.gwt.base.client.model.entity.BaseEntity#getName()
	 */
	public String getName() {
		return this.currentState.getName();
	}

	/**
	 * @return the removeCardList
	 */
	public ArrayList getRemoveCardList() {
		return this.removeCardList;
	}

	/*
	 * public void modifyInformationForCard(CardInformation info) { }
	 */

	/**
	 * @return
	 * @see org.eclipse.higgins.ics.gwt.base.client.model.entity.CurrentState#getSelectedCard()
	 */
	public Card getSelectedCard() {
		return this.currentState.getSelectedCard();
	}

	/**
	 * @return
	 * @see org.eclipse.higgins.ics.gwt.base.client.model.entity.CurrentState#getSelectedCategory()
	 */
	public Category getSelectedCategory() {
		return this.currentState.getSelectedCategory();
	}

	public void modifyCardInCategory(Card card, Category category) {
		for (Iterator iterator = category.getCardList().iterator(); iterator
				.hasNext();) {
			Card cardItem = (Card) iterator.next();
			if (cardItem.getCuid() != null
					&& cardItem.getCuid().equals(card.getCuid())) {
				cardItem.setName(card.getName());
				cardItem.setDefault(getDefaultPCardUid()!= null && (card.isDefault() || cardItem.getCuid().equalsIgnoreCase(getDefaultPCardUid())));
				cardItem.setImage(card.getImage());
				cardItem.setCardInformation(card.getCardInformation());
				cardItem.setProtected(card.isProtected());
				cardItem.setValueAvailable(card.isValueAvailable());
				cardItem.setIsSaveCredential(card.isSaveCredential());
				cardItem.setCardCredential(card.getCardCredential());
				for (int i = 0; i < cardItem.getClaimItems().length; i++) {
					cardItem.getClaimItems()[i].setValue(card.getClaimItems()[i].getValue());
				}
				card.setRelatedCards(cardItem.getRelatedCards());
				fireSelectedCardListeners(cardItem);
			}
		}
		for (Iterator iterator = category.getChildList().iterator(); iterator
				.hasNext();) {
			Category categoryItem = (Category) iterator.next();
			modifyCardInCategory(card, categoryItem);
		}
	}
	
	public void changeDefaultCard(Card card) {
		String[] uid = new String[1];
		uid[0] = this.getDefaultPCardUid();
		if (uid[0]!=null) {
			Card oldDefaultCard = (Card)RPCUtils.getCardsByCuids(uid, currentState.getCategory()).get(0);			
			oldDefaultCard.setDefault(false);
		}
		
		uid[0] = card.getCuid();		
		card.setDefault(true);
		if (card != null) {
			((Card)RPCUtils.getCardsByCuids(uid, currentState.getCategory()).get(0)).setDefault(true);
			this.setDefaultPCardUid(card.getCuid());
			if (getSelectedCard().getCuid().equals(card.getCuid())) 
				modifySelectedCard(card);			
		}
	}
	
	public String getDefaultPCardUid() {
		return defaultPCardUid;
	}

	public void setDefaultPCardUid(String defaultPCardUid) {
		this.defaultPCardUid = defaultPCardUid;
	}


	public void modifySelectedCard(Card card) {
		card.setDefault(getDefaultPCardUid()!= null && card.getCuid().equalsIgnoreCase(getDefaultPCardUid()));
		modifyCardInCategory(card, getCategory());
		setSelectedCard(card);
	}

	public void removeCard(Card card, Category category) {
		try {
			category.getCardList().remove(card);
			for (Iterator iterator = getRemoveCardList().iterator(); iterator
					.hasNext();) {
				RemoveCardListener removeCardListener = (RemoveCardListener) iterator
						.next();
				try {
					removeCardListener.onRemoveCard(card, category);
				} catch (RuntimeException e) {
				}
			}
		} catch (RuntimeException e) {
		}

	}

	/**
	 * @param category
	 * @see org.eclipse.higgins.ics.gwt.base.client.model.entity.CurrentState#setCategory(org.eclipse.higgins.ics.gwt.base.client.model.entity.Category)
	 */
	public void setCategory(Category category) {
		this.currentState.setCategory(category);
	}

	/**
	 * @param name
	 * @see org.eclipse.higgins.ics.gwt.base.client.model.entity.BaseEntity#setName(java.lang.String)
	 */
	public void setName(String name) {
		this.currentState.setName(name);
	}

	/**
	 * @param selectedCard
	 * @see org.eclipse.higgins.ics.gwt.base.client.model.entity.CurrentState#setSelectedCard(org.eclipse.higgins.ics.gwt.base.client.model.entity.Card)
	 */
	public void setSelectedCard(Card selectedCard) {
		this.currentState.setSelectedCard(selectedCard);
		for (Iterator iterator = getChangeSelectedCardList().iterator(); iterator
				.hasNext();) {
			ChangeSelectedCardListener changeSelectedCardListener = (ChangeSelectedCardListener) iterator
					.next();
			try {
				changeSelectedCardListener.onChangeSelectedCard(
						selectedCard,
						getSelectedCategory());
			} catch (RuntimeException e) {
			}
		}
	}

	/**
	 * @param selectedCategory
	 * @see org.eclipse.higgins.ics.gwt.base.client.model.entity.CurrentState#setSelectedCategory(org.eclipse.higgins.ics.gwt.base.client.model.entity.Category)
	 */
	public void setSelectedCategory(Category selectedCategory) {
		this.currentState.setSelectedCategory(selectedCategory);
	}

	public HashSet getMrus() {
		return mrus;
	}

	public void setMrus(HashSet mrus) {
		this.mrus = mrus;
	}

}
