/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel.card;

import java.util.Iterator;
import java.util.List;

import org.eclipse.higgins.ics.gwt.base.client.button.CardActionButton;
import org.eclipse.higgins.ics.gwt.base.client.button.PopupButton;
import org.eclipse.higgins.ics.gwt.base.client.button.SimpleButton;
import org.eclipse.higgins.ics.gwt.base.client.dialog.SimpleDialog;
import org.eclipse.higgins.ics.gwt.base.client.listener.ChangeSelectedCardListener;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Category;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.ErrorKeys;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.GWTResponse;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.ListEntity;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.StsFault;
import org.eclipse.higgins.ics.gwt.base.client.panel.RoundedPanelDialog;
import org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;
import org.eclipse.higgins.ics.gwt.icm.client.RPCUtils;
import org.eclipse.higgins.ics.gwt.icm.client.panel.cardcredential.CardCredentialEditor;
import org.eclipse.higgins.ics.gwt.icm.client.panel.cardcredential.CardCredentialPanel;
import org.eclipse.higgins.ics.gwt.icm.client.panel.cardcredential.ManagePinPanel;
import org.eclipse.higgins.ics.gwt.icm.client.panel.category.CategoryListPanel;
import org.eclipse.higgins.ics.gwt.icm.client.panel.edit.CardEditablePanel;
import org.eclipse.higgins.ics.gwt.icm.client.panel.edit.MCardEditablePanel;
import org.eclipse.higgins.ics.gwt.icm.client.panel.edit.PCardEditablePanel;
import org.eclipse.higgins.ics.gwt.icm.client.panel.edit.PWCardEditablePanel;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class CardPanelFooter extends HorizontalPanel {
	/**
	 * 
	 */
	private static final String STYLE_CARD_PANEL_FOOTER_LABEL = "cardPanel_footer_label";

	/**
	 * 
	 */
	private static final String STYLE_CARD_PANEL_FOOTER = "cardPanel_footer";

	private final HorizontalPanel cardActionPanel = new HorizontalPanel();
	private final HorizontalPanel cardActionButtonPanel = new HorizontalPanel();
	private final VerticalPanel bodyPanel = new VerticalPanel();
	// private final HorizontalPanel pinPanel = new HorizontalPanel();
	private final HorizontalPanel fileInPanel = new HorizontalPanel();
	private final CardActionButton deleteButton;
	// private final CardActionButton removeButton;
	private final CardActionButton retrieveButton;
	private final CardActionButton editButton;
	private final CardActionButton makeCopyButton;
	private final CardActionButton resetPinButton;
	private final CardActionButton editPinButton;
	private final CardActionButton savePinButton;
	private final CardActionButton forgetPinButton;
	private final PopupButton moveButton;
	private final CardActionButton pinButton;
	private final SimpleButton noDeleteButton;
	private final CardActionButton setAsDefaultButton;

	private final Label actionsLabel = new Label(ICMEntryPoint.dictionary.get(ICMEntryPoint.constant.dnDetailsCardActionsLabelText()));
	private final Label pinLockedLabel = new Label(ICMEntryPoint.dictionary.get(ICMEntryPoint.constant.dnDetailsPinLockedLabelText()));
	private final Label fileInLabel = new Label(ICMEntryPoint.dictionary.get("MoveToCategoryButton_HTML"));
	private Card card;

	private final ChangeSelectedCardListener selectedCardListener;

	/**
	 * 
	 */
	public CardPanelFooter() {
		CategoryListPanel categoryListPanel = new CategoryListPanel();
		ICMEntryPoint.currentState.addAddCategoryListener(categoryListPanel.getAddCategoryListener());
		moveButton = new PopupButton(ICMEntryPoint.dictionary.get("CategoryPopupButton_HTML"), new RoundedPanelDialog(categoryListPanel),
				PopupButton.TOP_DIRECTION);
		
		moveButton.setTooltip(ICMEntryPoint.dictionary.get("MoveToCategoryButtonTooltip_HTML"));
		
		savePinButton = new CardActionButton(ICMEntryPoint.dictionary.get("SavePinButtonLabel_HTML"), new ClickListener() {
			public void onClick(Widget arg0) {
				Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("SavePinWaitLabel_HTML"));
				ICMEntryPoint.service.setCardCredential(ICMEntryPoint.getUserProfile().getLoginName(),
						ICMEntryPoint.getUserProfile().getPassword(), getCard().getCuid(), getCard().getCardCredential()[0], new GWTCallBack() {
					public void onFailure(Throwable arg0) {
						Utils.hideWaiteDialog();
						super.onFailure(arg0);
					}
						
					public void onSuccess(Object res) {
						Utils.hideWaiteDialog();
						if (res instanceof GWTResponse) {
							GWTResponse response = (GWTResponse) res;
							if (new Integer(0).equals(response.getStatusCode())) {
								Card aCard = Utils.cloneCard(getCard());
								aCard.setIsSaveCredential(true);
								aCard.setValueAvailable(true);
								
								ICMEntryPoint.currentState.modifySelectedCard(aCard);
							} else {
								Utils.showErrorMessage(ICMEntryPoint.dictionary.get("ServerErrorLabel_HTML")
										+ response.getStatusMessage());
							}
						}
					}	
				});
			}
		});
		
		setAsDefaultButton = new CardActionButton("<nobr>Set as default</nobr>", new ClickListener(){
			public void onClick(Widget arg0) {
				Utils.showWaiteDialog("Setting default...");
				ICMEntryPoint.service.setDefaultPCard(ICMEntryPoint.getUserProfile().getLoginName(),
						ICMEntryPoint.getUserProfile().getPassword(), getCard().getCuid(), new GWTCallBack() {
					public void onFailure(Throwable arg0) {
						Utils.hideWaiteDialog();
						super.onFailure(arg0);
					}
						
					public void onSuccess(Object res) {
						Utils.hideWaiteDialog();
						if (res instanceof GWTResponse) {
							GWTResponse response = (GWTResponse) res;
							if (new Integer(0).equals(response.getStatusCode()) ) {
								ICMEntryPoint.currentState.changeDefaultCard(getCard());
							} else {
								Utils.showErrorMessage(ICMEntryPoint.dictionary.get("ServerErrorLabel_HTML")
										+ response.getStatusMessage());
							}
						}
					}	
				});
			}
		});
		setAsDefaultButton.setTooltip("Set as default card for M-card signing");
		
		noDeleteButton = new SimpleButton(ICMEntryPoint.dictionary.get("DetailsDeleteCardButton_HTML"), null);
		noDeleteButton.setTooltip("This card is used as default for signing your m-cards. It cannot be deleted.");
		
		savePinButton.setTooltip(ICMEntryPoint.dictionary.get("SavePinButtonTooltip_HTML"));
		
		forgetPinButton = new CardActionButton(ICMEntryPoint.dictionary.get("ResetPinButtonLabel_HTML"), new ClickListener() {
			public void onClick(Widget arg0) {
				Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("ResetPinMemoryWaitLabel_HTML"));
				ICMEntryPoint.service.clearCardCredential(ICMEntryPoint.getUserProfile().getLoginName(),
						ICMEntryPoint.getUserProfile().getPassword(), getCard().getCuid(), new GWTCallBack() {
					public void onFailure(Throwable arg0) {
						Utils.hideWaiteDialog();
						super.onFailure(arg0);
					}
						
					public void onSuccess(Object res) {
						Utils.hideWaiteDialog();
						if (res instanceof GWTResponse) {
							GWTResponse response = (GWTResponse) res;
							if (new Integer(0).equals(response.getStatusCode()) && response.getResult() instanceof Card) {
								ICMEntryPoint.currentState.modifySelectedCard((Card)response.getResult());
							} else {
								Utils.showErrorMessage(ICMEntryPoint.dictionary.get("ServerErrorLabel_HTML")
										+ response.getStatusMessage());
							}
						}
					}	
				});
			}
		});
		
		forgetPinButton.setTooltip(ICMEntryPoint.dictionary.get("ResetPinButtonTooltip_HTML"));

		this.editPinButton = new CardActionButton(ICMEntryPoint.dictionary.get("ChangePasswordButton_HTML"), new ClickListener() {
			public void onClick(Widget arg0) {
				final ManagePinPanel pinPanel = new ManagePinPanel(getCard(), true);
				CardActionButton button = new CardActionButton(ICMEntryPoint.dictionary.get("SubmitButton_HTML"), new ClickListener() {

					/*
					 * (non-Javadoc)
					 * 
					 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
					 */
					public void onClick(Widget arg0) {
						if (pinPanel.getPinPanel1().getPinTextBox().getText().equals(pinPanel.getPinPanel2().getPinTextBox().getText())) {
							Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("ModifyingPasswordLabel_HTML"));
							String pinCode = null;
							if (getCard().isProtected() && getCard().isValueAvailable()) {
								try {
									pinCode = getCard().getCardCredential()[0].getPinCode();
								} catch (Exception e) {
								}
							}
							ICMEntryPoint.service.editPinCode(ICMEntryPoint.getUserProfile().getLoginName(),
									ICMEntryPoint.getUserProfile().getPassword(), getCard().getCuid(), pinCode, pinPanel.getPinPanel1().getPinTextBox().getText(), new GWTCallBack() {
										/*
										 * (non-Javadoc)
										 * 
										 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onFailure(java.lang.Throwable)
										 */
										public void onFailure(Throwable arg0) {
											Utils.hideWaiteDialog();
											super.onFailure(arg0);

										}

										/*
										 * (non-Javadoc)
										 * 
										 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
										 */
										public void onSuccess(Object res) {
											Utils.hideWaiteDialog();
											Utils.hideWaiteDialog();
											if (res instanceof GWTResponse) {
												GWTResponse response = (GWTResponse) res;
												if (new Integer(0).equals(response.getStatusCode())) {
													Card card = (Card) response.getResult();
													for (int i=0; i<card.getClaimItems().length; i++) {
														card.getClaimItems()[i].setValue("");
													}
													card.setValueAvailable(false);
													ICMEntryPoint.currentState.modifySelectedCard(card);
												} else {
													Utils.showErrorMessage(ICMEntryPoint.dictionary
															.get("ServerErrorLabel_HTML")
															+ response.getStatusMessage());
												}
											}

											if (pinPanel.getDialogBox() != null) {
												pinPanel.getDialogBox().hide();
											}
											if (pinPanel.getDialogBox() != null) {
												pinPanel.getDialogBox().hide();
											}
										}
									});
						} else {
							pinPanel.setDescriptionHTML(ICMEntryPoint.dictionary.get("PasswordsDontMatchLabel_HTML"));
						}
					}
				});
				pinPanel.getPinPanel1().setPinLabel(ICMEntryPoint.dictionary.get("NewPasswordLabel_HTML"));
				pinPanel.getPinPanel2().setPinLabel(ICMEntryPoint.dictionary.get("RetypeNewPasswordLabel_HTML"));
				pinPanel.setDoButton(button);
				SimpleDialog dialog = new SimpleDialog(pinPanel);
				// dialog.getHeaderPanel().add(
				// new HTML("<h1><img src='/ics/images/icon_lock_lrg.gif'/>"
				// + ICMEntryPoint.dictionary.get("LockCardWithPasswordButton_HTML") + "</h>"));
				dialog.setText(ICMEntryPoint.dictionary.get("LockCardWithPasswordButton_HTML"));
				pinPanel.setDialogBox(dialog);
				pinPanel.setDescriptionHTML(ICMEntryPoint.dictionary.get("CardLockWarningBody_HTML"));
				dialog.getButtonPanel().insert(pinPanel.getDoButton(), 2);
				dialog.showDialog();
				pinPanel.setFocus(true);

			}
		});
		
		editPinButton.setTooltip(ICMEntryPoint.dictionary.get("EditPinButtonTooltip_HTML"));

		this.resetPinButton = new CardActionButton(ICMEntryPoint.dictionary.get("RemoveLockButton_HTML"), new ClickListener() {
			public void onClick(Widget arg0) {
				CardActionButton actionButton = new CardActionButton(ICMEntryPoint.dictionary.get("UnlockCardButton_HTML"),
						new ClickListener() {
							public void onClick(Widget arg0) {
								/*String pinCode = null;
								if (getCard().isProtected() && getCard().isValueAvailable()) {
									try {
										pinCode = getCard().getCardCredential()[0].getPinCode();
									} catch (Exception e) {
									}
								}*/
								Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("UnlockingCardLabel_HTML"));
								ICMEntryPoint.service.resetPinCode(getCard(), ICMEntryPoint.getUserProfile()
										.getLoginName(), ICMEntryPoint.getUserProfile().getPassword(), new GWTCallBack() {
									/*
									 * (non-Javadoc)
									 * 
									 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onFailure(java.lang.Throwable)
									 */
									public void onFailure(Throwable arg0) {
										Utils.hideWaiteDialog();
										super.onFailure(arg0);

									}

									/*
									 * (non-Javadoc)
									 * 
									 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
									 */
									public void onSuccess(Object res) {
										Utils.hideWaiteDialog();
										if (res instanceof GWTResponse) {
											GWTResponse response = (GWTResponse) res;
											if (new Integer(0).equals(response.getStatusCode())) {
												List result = ((ListEntity)response.getResult()).getList();
												Card resultCard = (Card)result.get(0);
												if (result.size()>1) {
													for (int i=1; i<result.size(); i++) {
														ICMEntryPoint.currentState.modifySelectedCard((Card)result.get(i));
													}												    
												}
												ICMEntryPoint.currentState.modifySelectedCard(resultCard);
												
											} else {
												Utils.showErrorMessage(ICMEntryPoint.dictionary.get("ServerErrorLabel_HTML")
														+ response.getStatusMessage());
											}
										}
									}
								});
							}
						});
				Utils.showConfirmDialog(ICMEntryPoint.dictionary.get("UnlockCardWarnMessageTitle_HTML"), ICMEntryPoint.dictionary
						.get("UnlockCardWarnMessageBody_HTML"), actionButton);
			}
		});
		
		resetPinButton.setTooltip(ICMEntryPoint.dictionary.get("DeletePinButtonTooltip_HTML"));

		this.makeCopyButton = new CardActionButton(ICMEntryPoint.dictionary.get("DetailsCopyCardButton_HTML"), new ClickListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(Widget arg0) {
				Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("MakingCopyOfLabel_HTML") + getCard().getName() + "' ...");
				String pinCode = null;
				if (getCard().isProtected() && getCard().isValueAvailable()) {
					try {
						pinCode = getCard().getCardCredential()[0].getPinCode();
					} catch (Exception e) {
					}
				}

				ICMEntryPoint.service.createDuplicateCard(getCard().getCuid(), ICMEntryPoint.dictionary.get("CopyOfCardTitleLabel_HTML")
						+ getCard().getName(), pinCode, ICMEntryPoint.getUserProfile().getLoginName(), ICMEntryPoint.getUserProfile()
						.getPassword(), new GWTCallBack() {

					/*
					 * (non-Javadoc)
					 * 
					 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
					 */
					public void onSuccess(Object res) {
						Utils.hideWaiteDialog();
						if (res instanceof GWTResponse) {
							if (((GWTResponse) res).getStatusCode().equals(new Integer(0))) {
								ICMEntryPoint.currentState.addNewCard((Card) ((GWTResponse) res).getResult());
							} else {
								Utils.showErrorMessage(((GWTResponse) res).getStatusMessage());
							}
						}
					}
				});
			}
		});
		
		makeCopyButton.setTooltip(ICMEntryPoint.dictionary.get("CopyCardButtonTooltip_HTML"));

		this.pinButton = new CardActionButton(ICMEntryPoint.dictionary.get("PasswordLockButton_HTML"), new ClickListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(Widget arg0) {
				final ManagePinPanel pinPanel = new ManagePinPanel(getCard(), true);
				CardActionButton button = new CardActionButton(ICMEntryPoint.dictionary.get("SubmitButton_HTML"), new ClickListener() {

					/*
					 * (non-Javadoc)
					 * 
					 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
					 */
					public void onClick(Widget arg0) {
						if (!pinPanel.getPinPanel1().getPinTextBox().getText().equals("") && pinPanel.getPinPanel1().getPinTextBox().getText() != null) {
							if (pinPanel.getPinPanel1().getPinTextBox().getText().equals(pinPanel.getPinPanel2().getPinTextBox().getText())) {
								Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("LockingCardLabel_HTML"));
								ICMEntryPoint.service.setPinCode(getCard(), pinPanel.getPinPanel1().getCardCredential().getPinCode(), 
										ICMEntryPoint.getUserProfile().getLoginName(), ICMEntryPoint.getUserProfile().getPassword(),
										new GWTCallBack() {
											/*
											 * (non-Javadoc)
											 * 
											 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onFailure(java.lang.Throwable)
											 */
											public void onFailure(Throwable arg0) {
												Utils.hideWaiteDialog();
												super.onFailure(arg0);

											}

											/*
											 * (non-Javadoc)
											 * 
											 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
											 */
											public void onSuccess(Object res) {
												Utils.hideWaiteDialog();
												if (res instanceof GWTResponse) {
													GWTResponse response = (GWTResponse) res;
													if (new Integer(0).equals(response.getStatusCode())) {
														List result = ((ListEntity)response.getResult()).getList();
														Card resultCard = (Card)result.get(0);
														if (result.size()>1) {
															for (int i=1; i<result.size(); i++) {
																ICMEntryPoint.currentState.modifySelectedCard((Card)result.get(i));
															}												    
														}
														for (int i=0; i<resultCard.getClaimItems().length; i++) {
															resultCard.getClaimItems()[i].setValue("");
														}
														ICMEntryPoint.currentState.modifySelectedCard(resultCard);
													} else {
														Utils.showErrorMessage(ICMEntryPoint.dictionary.get("ServerErrorLabel_HTML")
																+ response.getStatusMessage());
														getCard().getCardCredential()[0].setPinCode("");
													}
												}

												if (pinPanel.getDialogBox() != null) {
													pinPanel.getDialogBox().hide();
												}
											}
										});
							} else {
								pinPanel.setDescriptionHTML("<br>"+ICMEntryPoint.dictionary.get("PasswordsDontMatchLabel_HTML")+"<br>");
							}
						} else {
							pinPanel.setDescriptionHTML("<br>Password cannot be empty!<br>");
						}
						
					}
				});
				pinPanel.setDoButton(button);
				SimpleDialog dialog = new SimpleDialog(pinPanel);
				dialog.setText(ICMEntryPoint.dictionary.get("LockCardWithPasswordButton_HTML"));
				// dialog.getHeaderPanel().add(
				// new HTML("<h1><img src='/ics/images/icon_lock_lrg.gif'/>"
				// + ICMEntryPoint.dictionary.get("LockCardWithPasswordButton_HTML") + "</h>"));
				pinPanel.setDialogBox(dialog);
				pinPanel.setDescriptionHTML(ICMEntryPoint.dictionary.get("CardLockWarningBody_HTML"));
				dialog.getButtonPanel().insert(pinPanel.getDoButton(), 2);
				dialog.showDialog();
				pinPanel.setFocus(true);

			}

		});
		
		pinButton.setTooltip(ICMEntryPoint.dictionary.get("SetPinCodeButtonTooltip_HTML"));

		this.editButton = new CardActionButton(ICMEntryPoint.dictionary.get("DetailsEditCardButton_HTML"), new ClickListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(Widget arg0) {
				final CardEditablePanel editablePanel;
				
				if (getCard().getCardType().equals("IPersonalInformationCard")) {
					editablePanel = new PCardEditablePanel(getCard());
				} else if (getCard().getCardType().equals("IManagedInformationCard")) {
					editablePanel = new MCardEditablePanel(getCard());
				} else {
					editablePanel = new PWCardEditablePanel(getCard());
				}
				
				final SimpleDialog dialog = new SimpleDialog(editablePanel);
				// final DialogBox dialog = new DialogBox();
				// editablePanel
				// dialog.setWidget(editablePanel);
				dialog.setText(ICMEntryPoint.dictionary.get("EditCardTitle_HTML"));
				editablePanel.setDialogBox(dialog);
				if (getCard().getCardType().equals("IPersonalInformationCard"))
				{
					dialog.getButtonPanel().insert(((PCardEditablePanel)editablePanel).getMoreOptionsButton(), 1);
					((PCardEditablePanel)editablePanel).getMoreOptionsButton().addClickListener(new ClickListener() {
						public void onClick(Widget arg) {
							dialog.getScrollBodyPanel().setScrollPosition(dialog.getScrollBodyPanel().getAbsoluteTop());
						}
					});
				}
				dialog.getButtonPanel().insert(editablePanel.getSaveChangesButton(), 2);
				dialog.showDialog();
				// dialog.getHeaderPanel().add(new HTML(ICMEntryPoint.dictionary.get("EditCardTitle_HTML")));
				// dialog.getButtonPanel().insert(editablePanel.getSaveChangesButton(), 2);
				// dialog.setPopupPositionAndShow(new PopupPanel.PositionCallback() {
				// public void setPosition(int offsetWidth, int offsetHeight) {
				// int w = editablePanel.getOffsetWidth(), h = editablePanel.getOffsetHeight();
				// if (w + 100 > Utils.rootWidth)
				// w = Utils.rootWidth - 50;
				// if (h + 170 > Utils.rootHeight)
				// h = Utils.rootHeight - 170;
				//
				// dialog.setPixelSize(w+20, h);
				//
				// dialog.setPopupPosition(((Utils.rootWidth - w) / 2), (Utils.rootHeight - h-100) / 2);
				// }
				// });

				// Window.alert("el=" + dialog.getElement().toString());
				// Window.alert("D Width" + dialog.getOffsetWidth());
				// Window.alert("EP Width" + editablePanel.getOffsetWidth());

			}
		});
		
		editButton.setTooltip(ICMEntryPoint.dictionary.get("EditCardButtonTooltip_HTML"));

		this.retrieveButton = new CardActionButton(ICMEntryPoint.dictionary.get("RetrieveButton_HTML"), new ClickListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(Widget arg0) {
				if (getCard().getCardCredential() != null && !getCard().isSaveCredential()) {
					CardCredentialPanel credentialPanel = new CardCredentialPanel(getCard());
					SimpleDialog dialog = new SimpleDialog(credentialPanel);
					// dialog.getHeaderPanel().add(
					// new HTML("<h1><img src='/ics/images/icon_lock_lrg.gif'/>"
					// + ICMEntryPoint.dictionary.get("EnterCardPasswordLabel_HTML") + "</h>"));
					dialog.setText(ICMEntryPoint.dictionary.get("EnterCardPasswordLabel_HTML"));
					credentialPanel.setDialogBox(dialog);
					dialog.getButtonPanel().insert(credentialPanel.getRetrieveButton(), 2);
					credentialPanel.showDialog();
					credentialPanel.setFocus(true);
				} else {
					Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("RetrievingClaimValueLabel_HTML"));
					ICMEntryPoint.service.getCardByCredential(getCard(), ICMEntryPoint.getUserProfile().getLoginName(), ICMEntryPoint
							.getUserProfile().getPassword(), new GWTCallBack() {
						/*
						 * (non-Javadoc)
						 * 
						 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onFailure(java.lang.Throwable)
						 */
						public void onFailure(Throwable arg0) {
							Utils.hideWaiteDialog();
							super.onFailure(arg0);

						}

						/*
						 * (non-Javadoc)
						 * 
						 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
						 */
						public void onSuccess(Object res) {
							Utils.hideWaiteDialog();
							if (res instanceof GWTResponse) {
								GWTResponse response = (GWTResponse) res;
								if (new Integer(0).equals(response.getStatusCode())) {
									ICMEntryPoint.currentState.modifySelectedCard((Card) response.getResult());
								} else {
									Utils.showErrorMessage(response.getStatusMessage());
									
								}
							}
						}
					});

				}
			}

		});
		
		this.retrieveButton.setTooltip(ICMEntryPoint.dictionary.get("RetrieveClaimsButtonTooltip_HTML"));

		this.deleteButton = new CardActionButton(ICMEntryPoint.dictionary.get("DetailsDeleteCardButton_HTML"), new ClickListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(Widget arg0) {
				
				CardActionButton actionButton = new CardActionButton(ICMEntryPoint.dictionary.get("DetailsDeleteCardButton_HTML"),
						new ClickListener() {

							/*
							 * (non-Javadoc)
							 * 
							 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
							 */
							public void onClick(Widget arg0) {
								Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("DeletingCardLabel_HTML"));
								ICMEntryPoint.service.deleteICard(getCard().getCuid(), ICMEntryPoint.getUserProfile().getLoginName(),
										ICMEntryPoint.getUserProfile().getPassword(), new GWTCallBack() {
											/*
											 * (non-Javadoc)
											 * 
											 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
											 */
											public void onSuccess(Object res) {
												Utils.hideWaiteDialog();
												if (res instanceof GWTResponse) {
													if (((GWTResponse) res).getStatusCode().equals(new Integer(0))) {
														ICMEntryPoint.currentState.deleteCard(getCard());
													} else {
														Utils.showErrorMessage(((GWTResponse) res).getStatusMessage());
													}
												}
											}

										});
							}

						});
				if (getCard().getRelatedCards()!=null && getCard().getRelatedCards().length>0) {
					VerticalPanel layoutPanel = new VerticalPanel();
					layoutPanel.setSpacing(7);
					layoutPanel.add(new HTML("If you delete this card, the following cards will be unusable:"));
					VerticalPanel cardsPanel = new VerticalPanel();
					List cards = RPCUtils.getCardsByCuids(getCard().getRelatedCards(), ICMEntryPoint.currentState.getCategory());				
					
					for (Iterator it = cards.iterator(); it.hasNext();) {
						HorizontalPanel cardPanel = new HorizontalPanel();
						cardPanel.setSpacing(7);
						cardPanel.setVerticalAlignment(ALIGN_MIDDLE);
						final Card aCard = (Card)it.next();
						final Image image = new Image();
						try {
							if (Utils.isIE()) {
								//photo.setUrl(Utils.getContextPath() + Utils.baseConstant.uriImgProgress());
								ICMEntryPoint.service.putImageForIE(aCard.getImage(),
										new AsyncCallback() {
											public void onSuccess(Object arg0) {
												image.setUrl(ICMEntryPoint.constant.servletPaintLogoAddress()
														+ "?cdata="
														+ aCard.getImage().substring(aCard.getImage().length() - 20).replace('+', '_').replace('=','_'));
											}

											public void onFailure(Throwable arg0) {
												image.setVisible(false);
											}
										});
							} else
								DOM.setElementAttribute(image.getElement(), "src",
										"data:image/jpeg;base64," + aCard.getImage());
						} catch (Exception e) {
						}
						image.setSize("64px", "48px");
						cardPanel.add(image);
						cardPanel.add(new HTML("<b>"+aCard.getName()+"</b>"));
						cardsPanel.add(cardPanel);
					}
					
					layoutPanel.add(cardsPanel);
					final SimpleDialog dialog = new SimpleDialog(layoutPanel);
					actionButton.addClickListener(new ClickListener() {
						public void onClick(Widget arg) {
							dialog.hide();
						}
					});
					dialog.setHTML("<center><h1>" +ICMEntryPoint.dictionary.get("DeleteCardWarningTitle_HTML") + "</h1></center>");					
					dialog.getButtonPanel().insert(actionButton, 2);
					dialog.showDialog();
					
						} else {
					Utils.showConfirmDialog(ICMEntryPoint.dictionary.get("DeleteCardWarningTitle_HTML"), ICMEntryPoint.dictionary
							.get("DeleteCardWarningBody_HTML"), actionButton);
				}
			}

		});
		
		deleteButton.setTooltip(ICMEntryPoint.dictionary.get("DeleteCardButtonTooltip_HTML"));

		// this.removeButton = new CardActionButton("Remove", new ClickListener() {
		//
		// /*
		// * (non-Javadoc)
		// *
		// * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
		// */
		// public void onClick(Widget arg0) {
		// CardActionButton actionButton = new CardActionButton("Remove card", new ClickListener() {
		//
		// /*
		// * (non-Javadoc)
		// *
		// * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
		// */
		// public void onClick(Widget arg0) {
		// RPCUtils.removeCardFromCategory();
		// }
		//
		// });
		// Utils.showConfirmDialog("Remove this card from category?", "<p>Selected card will be removed from
		// category.</p>",
		// actionButton);
		// }
		//
		// });
		//
		this.selectedCardListener = new ChangeSelectedCardListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.higgins.ics.gwt.base.client.listener.ChangeSelectedCardListener#onChangeSelectedCard(org.eclipse.higgins.ics.gwt.base.client.model.entity.Card,
			 *      org.eclipse.higgins.ics.gwt.base.client.model.entity.Category)
			 */
			public void onChangeSelectedCard(Card card, Category category) {
				if (card != null) {
					setCard(card);
					if (card.getCardType().equals("IPersonalInformationCard")) {
						getMakeCopyButton().setVisible(card.isValueAvailable());
						getPinButton().setVisible(!card.isProtected());
						getResetPinButton().setVisible(card.isValueAvailable() && card.isProtected());
						getEditPinButton().setVisible(card.isValueAvailable() && card.isProtected());
						getForgetPinButton().setVisible(false);
						getSavePinButton().setVisible(false);
						getSetAsDefaultButton().setVisible(!card.isDefault() && card.isValueAvailable());
						getNoDeleteButton().setVisible(card.isDefault() && card.isValueAvailable());
						
					} else if (card.getCardType().equals("IManagedInformationCard"))  {
						getMakeCopyButton().setVisible(false);
						// getEditButton().setVisible(card.isValueAvailable());
						getForgetPinButton().setVisible(card.isValueAvailable() && card.isSaveCredential() && card.isProtected() && !card.getCardCredential()[0].getType().equals(CardCredentialEditor.SELFISSUED_NONPIN_CRIDENTIAL_TYPE ));
						getSavePinButton().setVisible(card.isValueAvailable() && !card.isSaveCredential() && card.isProtected() && !card.getCardCredential()[0].getType().equals(CardCredentialEditor.SELFISSUED_NONPIN_CRIDENTIAL_TYPE ));
						getResetPinButton().setVisible(false);
						getEditPinButton().setVisible(false);
						getSetAsDefaultButton().setVisible(false);
						getPinButton().setVisible(false);
					} else {
						getMakeCopyButton().setVisible(false);
						getPinButton().setVisible(false);
						getResetPinButton().setVisible(false);
						getEditPinButton().setVisible(false);
						getSetAsDefaultButton().setVisible(false);
						getForgetPinButton().setVisible(false);
						getSavePinButton().setVisible(false);
					}
					getRetrieveButton().setVisible(!card.isValueAvailable());
					getEditButton().setVisible(card.isValueAvailable());
					getDeleteButton().setVisible(!card.isDefault());
					getNoDeleteButton().setVisible(card.isDefault());

					// getRemoveButton().setVisible(!category.isPreDefined());

					setVisible(true);
				} else {
					setVisible(false);
				}

			}

		};

		this.cardActionPanel.setSpacing(5);
		this.cardActionButtonPanel.setSpacing(5);

		// this.pinPanel.setSpacing(5);
		this.fileInPanel.setSpacing(5);

		// this.cardActionButtonPanel.setWidth("00%");
		this.cardActionButtonPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		this.cardActionButtonPanel.add(getEditButton());
		this.cardActionButtonPanel.add(getMakeCopyButton());
		this.cardActionButtonPanel.add(getRetrieveButton());
		this.cardActionButtonPanel.add(getResetPinButton());
		this.cardActionButtonPanel.add(getEditPinButton());
		this.cardActionButtonPanel.add(getDeleteButton());
		this.cardActionButtonPanel.add(getNoDeleteButton());
		this.cardActionButtonPanel.add(getPinButton());
		this.cardActionButtonPanel.add(getForgetPinButton());
		this.cardActionButtonPanel.add(getSavePinButton());
		this.cardActionButtonPanel.add(getSetAsDefaultButton());
		
		
		this.actionsLabel.setStyleName(STYLE_CARD_PANEL_FOOTER_LABEL);
		this.cardActionPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		this.cardActionPanel.add(this.actionsLabel);
		this.cardActionPanel.add(this.cardActionButtonPanel);

		this.pinLockedLabel.setStyleName(STYLE_CARD_PANEL_FOOTER_LABEL);

		this.fileInLabel.setStyleName(STYLE_CARD_PANEL_FOOTER_LABEL);
		this.fileInPanel.add(this.fileInLabel);
		this.fileInPanel.add(getMoveButton());

		this.bodyPanel.add(this.cardActionPanel);
		setSpacing(5);
		setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
		setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		setWidth("100%");
		super.setHeight("48px");
		setStyleName(STYLE_CARD_PANEL_FOOTER);
		add(this.bodyPanel);
		setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
		add(this.fileInPanel);
		ICMEntryPoint.currentState.addChangeSelectedCardListener(this.selectedCardListener);
		setVisible(false);

	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see com.google.gwt.user.client.ui.UIObject#setPixelSize(int, int)
	 */
	public void setPixelSize(int width, int height) {
		try {
			remove(this.fileInPanel);
		} catch (Exception e) {
		}

		try {
			this.bodyPanel.remove(this.fileInPanel);
		} catch (Exception e) {
		}

		if (width > 650) {
			add(this.fileInPanel);
		} else {
			this.bodyPanel.add(this.fileInPanel);
		}
		super.setPixelSize(width, height);
	}

	/**
	 * @return the cardActionPanel
	 */
	// public SimplePanel getCardActionPanel() {
	// return this.cardActionPanel;
	// }
	// /**
	// * @return the pinPanel
	// */
	// public HorizontalPanel getPinPanel() {
	// return this.pinPanel;
	// }
	/**
	 * @return the fileInPanel
	 */
	public HorizontalPanel getFileInPanel() {
		return this.fileInPanel;
	}

	public CardActionButton getSetAsDefaultButton() {
		return setAsDefaultButton;
	}

	/**
	 * @return the deleteButton
	 */
	private CardActionButton getDeleteButton() {
		return this.deleteButton;
	}

	/**
	 * @return the editButton
	 */
	CardActionButton getEditButton() {
		return this.editButton;
	}

	/**
	 * @return the makeCopyButton
	 */
	CardActionButton getMakeCopyButton() {
		return this.makeCopyButton;
	}

	CardActionButton getResetPinButton() {
		return this.resetPinButton;
	}

	CardActionButton getEditPinButton() {
		return this.editPinButton;
	}

	/**
	 * @return the moveButton
	 */
	private SimpleButton getMoveButton() {
		return this.moveButton;
	}
	
	CardActionButton getForgetPinButton() {
		return this.forgetPinButton;
	}
	
	CardActionButton getSavePinButton() {
		return this.savePinButton;
	}
	
	SimpleButton getNoDeleteButton() {
		return this.noDeleteButton;
	}

	/**
	 * @return the pinButton
	 */
	CardActionButton getPinButton() {
		return this.pinButton;
	}

	/**
	 * @return the card
	 */
	public Card getCard() {
		return this.card;
	}

	/**
	 * @param card
	 *            the card to set
	 */
	public void setCard(Card card) {
		this.card = card;
	}

	/**
	 * @return the retrieveButton
	 */
	public CardActionButton getRetrieveButton() {
		return this.retrieveButton;
	}

}
