/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko -  initial API and implementation
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel.category.dnd;

import com.allen_sauer.gwt.dnd.client.DragContext;
import com.allen_sauer.gwt.dnd.client.PickupDragController;
import com.allen_sauer.gwt.dnd.client.drop.BoundaryDropController;
import com.google.gwt.core.client.JavaScriptException;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class TableDragController extends PickupDragController {
	
	private FlexTable draggableTable;

	  private int dragRow;

	  public TableDragController(AbsolutePanel boundaryPanel) {
	    super(boundaryPanel, false);
	    setBehaviorDragProxy(true);
	    setBehaviorMultipleSelection(false);
	  }
	  
	  public void dragStart() {
		  super.dragStart();
	  }

	  public void dragEnd() {
	    super.dragEnd();
	    draggableTable = null;
	  }

	  public void setBehaviorDragProxy(boolean dragProxyEnabled) {
	    if (!dragProxyEnabled) {
	      // TODO implement drag proxy behavior
	      throw new IllegalArgumentException();
	    }
	    super.setBehaviorDragProxy(dragProxyEnabled);
	  }

	  protected BoundaryDropController newBoundaryDropController(AbsolutePanel boundaryPanel,
	      boolean allowDroppingOnBoundaryPanel) {
	    if (allowDroppingOnBoundaryPanel) {
	      throw new IllegalArgumentException();
	    }
	    return super.newBoundaryDropController(boundaryPanel, allowDroppingOnBoundaryPanel);
	  }

	  protected Widget newDragProxy(DragContext context) {
		 FlexTable proxy = new FlexTable();
	    draggableTable = (FlexTable) context.draggable.getParent();
	    dragRow = getWidgetRow(context.draggable, draggableTable);
	    TableUtils.copyRow(draggableTable, proxy, dragRow, 0);
	    return proxy;
	  }

	  FlexTable getDraggableTable() {
	    return draggableTable;
	  }

	  int getDragRow() {
	    return dragRow;
	  }

	  private int getWidgetRow(Widget widget, FlexTable table) {
	    for (int row = 0; row < table.getRowCount(); row++) {
	      for (int col = 0; col < table.getCellCount(row); col++) {
	        Widget w = table.getWidget(row, col);
	        if (w == widget) {
	          return row;
	        }
	      }
	    }
	    throw new RuntimeException("Unable to determine widget row");
	  }
}
