/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel.edit;

import org.eclipse.higgins.ics.gwt.base.client.button.CardActionButton;
import org.eclipse.higgins.ics.gwt.base.client.editor.ImageEditor;
import org.eclipse.higgins.ics.gwt.base.client.editor.TextBoxEditor;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class CardEditablePanel extends Composite {

	private final Label labelCardImage = new Label();
	private final ImageEditor cardImage = new ImageEditor();
	private final Label labelCardName = new Label();
	private final TextBoxEditor cardName = new TextBoxEditor();
	private final FlexTable bodyTable = new FlexTable();
	private ClickListener saveChangesListener;
	private CardActionButton saveChangesButton;
	private DialogBox dialogBox;

	final Card card;
	protected int dimRowTable = 3;

	/**
	 * 
	 */
	public CardEditablePanel(Card pcard) {
		this.card = pcard;

		getBodyTable().setWidth("100%");
		getBodyTable().setWidget(0, 0, buildGroupPanel(ICMEntryPoint.dictionary.get("Level0ClaimTitle_HTML")));
		getBodyTable().getFlexCellFormatter().setColSpan(0, 0, 2);

		getBodyTable().getFlexCellFormatter().setHorizontalAlignment(1, 0, HasHorizontalAlignment.ALIGN_RIGHT);
		getLabelCardName().setStyleName("cardPanel_claim_label");
		getLabelCardName().setText(ICMEntryPoint.dictionary.get("CardNameLabel_HTML"));

		getBodyTable().setWidget(1, 0, getLabelCardName());

		getCardName().setValue(getCard().getName());
		getCardName().setName(ICMEntryPoint.dictionary.get("CardNameLabel_HTML"));
		getCardName().setInputRegExp("^\\w");
		getCardName().setCheckValueRunTime(true);
		getCardName().disableOptions();

		getBodyTable().getFlexCellFormatter().setHorizontalAlignment(1, 1, HasHorizontalAlignment.ALIGN_LEFT);
		getBodyTable().setWidget(1, 1, getCardName());

		getBodyTable().getFlexCellFormatter().setHorizontalAlignment(2, 0, HasHorizontalAlignment.ALIGN_RIGHT);
		getLabelCardImage().setStyleName("cardPanel_claim_label");
		getBodyTable().setWidget(2, 0, getLabelCardImage());
		
		String image;
		image = getCard().getImage()!=null?getCard().getImage():"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";
		getCardImage().setValue(image);
		getCardImage().setName(ICMEntryPoint.dictionary.get("CardImageLabel_HTML"));
		getCardImage().setChildWidth(getCard().getSelfIssued().booleanValue() ? "80" : "120");
		getCardImage().setChildHeight("80");

		getBodyTable().getFlexCellFormatter().setHorizontalAlignment(2, 1, HasHorizontalAlignment.ALIGN_LEFT);
		getBodyTable().setWidget(2, 1, getCardImage());

		initWidget(getBodyTable());
	}

	/**
	 * @return the card
	 */
	public Card getCard() {
		return this.card;
	}

	/**
	 * @return the bodyTable
	 */
	public FlexTable getBodyTable() {
		return this.bodyTable;
	}

	/**
	 * @return the labelCardImage
	 */
	public Label getLabelCardImage() {
		return this.labelCardImage;
	}

	/**
	 * @return the cardImage
	 */
	public ImageEditor getCardImage() {
		return this.cardImage;
	}

	/**
	 * @return the labelCardName
	 */
	public Label getLabelCardName() {
		return this.labelCardName;
	}

	/**
	 * @return the cardName
	 */
	public TextBoxEditor getCardName() {
		return this.cardName;
	}

	/**
	 * @return the saveChangesListener
	 */
	public ClickListener getSaveChangesListener() {
		return this.saveChangesListener;
	}

	/**
	 * @param saveChangesListener
	 *            the saveChangesListener to set
	 */
	public void setSaveChangesListener(ClickListener saveChangesListener) {
		this.saveChangesListener = saveChangesListener;
	}

	/**
	 * @return the dialogBox
	 */
	public DialogBox getDialogBox() {
		return this.dialogBox;
	}

	/**
	 * @param dialogBox
	 *            the dialogBox to set
	 */
	public void setDialogBox(DialogBox dialogBox) {
		this.dialogBox = dialogBox;
	}

	/**
	 * @return the saveChangesButton
	 */
	public CardActionButton getSaveChangesButton() {
		return this.saveChangesButton;
	}

	/**
	 * @param saveChangesButton
	 *            the saveChangesButton to set
	 */
	public void setSaveChangesButton(CardActionButton saveChangesButton) {
		this.saveChangesButton = saveChangesButton;
	}

	public static HorizontalPanel buildGroupPanel(String name) {
		HorizontalPanel groupPanel = new HorizontalPanel();
		groupPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		groupPanel.setSpacing(5);
		groupPanel.setWidth("100%");
		Label nameLabel = new Label(name, false);
		// replaceAll(" ","&nbsp;")
		nameLabel.setStyleName("groupClaim_label");

		Image separator = new Image(Utils.getContextPath() + ICMEntryPoint.constant.uriImgBgHeaderOverlayForm());
		separator.setHeight("1px");
		separator.setWidth("100%");

		groupPanel.add(nameLabel);
		groupPanel.add(separator);
		groupPanel.setCellWidth(separator, "100%");
		return groupPanel;
	}

}