/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel.edit;

import org.eclipse.higgins.ics.gwt.base.client.button.CardActionButton;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.GWTResponse;
import org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class MCardEditablePanel extends CardEditablePanel {

	/**
	 * @param pcard
	 */
	public MCardEditablePanel(Card pcard) {
		super(pcard);
		getLabelCardImage().setText("Image");
		setSaveChangesListener(new ClickListener() {
			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(Widget arg0) {
				getCard().setName(getCardName().getValue());
				getCard().setImage(getCardImage().getValue());
				getCard().setImageType("image/jpeg");

				Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("SendChangesLabel_HTML"));
				ICMEntryPoint.service.modifyCard(getCard(), ICMEntryPoint.getUserProfile().getLoginName(), ICMEntryPoint.getUserProfile()
						.getPassword(), new GWTCallBack() {

					/*
					 * (non-Javadoc)
					 * 
					 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onFailure(java.lang.Throwable)
					 */
					public void onFailure(Throwable arg0) {
						Utils.hideWaiteDialog();
						super.onFailure(arg0);
					}

					/*
					 * (non-Javadoc)
					 * 
					 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
					 */
					public void onSuccess(Object res) {
						Utils.hideWaiteDialog();
						if (res instanceof GWTResponse) {
							GWTResponse response = (GWTResponse) res;
							if (response.getStatusCode().equals(new Integer(0))) {
								ICMEntryPoint.currentState.modifySelectedCard((Card) response.getResult());
							} else {
								Utils.showErrorMessage(response.getStatusMessage());
							}
						}
						if (getDialogBox() != null) {
							getDialogBox().hide();
						}
					}

				});

			}
		});
		setSaveChangesButton(new CardActionButton("Save changes", getSaveChangesListener()));
	}

}
