/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Alexander Yuhimenko - implementation
 */

package org.eclipse.higgins.ics.model.servlet;

import javax.servlet.ServletException;

import org.eclipse.higgins.ics.ws.client.WSClient;

public class InitConfServlet extends javax.servlet.http.HttpServlet implements	javax.servlet.Servlet {

	static final long serialVersionUID = 1L;

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.servlet.GenericServlet#init()
	 */
	public void init() throws ServletException {
		super.init();
		String rppsEndpoint = getServletContext().getInitParameter("RPPSEndpointAddress");
		if (rppsEndpoint != null)
			WSClient.RPPSEndpointAddress = rppsEndpoint;
	}

}
