package org.eclipse.higgins.ics.model.servlet;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;

import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.axis.encoding.Base64;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.ics.ws.client.Utils;
import org.eclipse.higgins.ics.ws.client.WSClient;

/**
 * Servlet implementation class for Servlet: UploadImageServlet
 * 
 */
public class UploadImageServlet extends javax.servlet.http.HttpServlet implements javax.servlet.Servlet {
	static final long serialVersionUID = 1L;
	public static final int MAX_UPLOAD_LENGTH = 1024 * 1024 * 20;
	
	private static final Log log = LogFactory.getLog(UploadImageServlet.class);

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public UploadImageServlet() {
		super();
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doPost(request, response);
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		try {
			String childHeight = request.getParameter("childHeight");
			String childWidth = request.getParameter("childWidth");
			DiskFileItemFactory factory = new DiskFileItemFactory();
			ServletFileUpload upload = new ServletFileUpload(factory);
			//upload.setSizeMax(MAX_UPLOAD_LENGTH);
			List items = upload.parseRequest(request);
			for (Iterator iterator = items.iterator(); iterator.hasNext();) {
				FileItem item = (FileItem) iterator.next();
				if (!item.isFormField()) {
					long sizeInBytes = item.getSize();
					//if (MAX_UPLOAD_LENGTH >= sizeInBytes) {
						InputStream uploadedStream = item.getInputStream();
						byte[] fileData = new byte[(int) sizeInBytes];
						uploadedStream.read(fileData);
						uploadedStream.close();
						try {
							InputStream is = new ByteArrayInputStream(fileData);
							BufferedImage cardImage = ImageIO.read(is);
							
							if (childHeight != null && childWidth != null && childHeight.length() > 0 && childWidth.length() > 0) {
								String image = Base64.encode(Utils.getScaledImg(Integer.parseInt(childWidth), Integer.parseInt(childHeight),
										cardImage));
								response.getOutputStream().print(image);
							} else {
								
								int[] dim = Utils.getOptimalPictureSize(cardImage.getHeight(), cardImage.getWidth());
								String image = Base64.encode(Utils.getScaledImg(dim[1], dim[0], cardImage));
								response.addHeader("Content-Type", "text/plain; charset=UTF-8");
								response.getOutputStream().print(image);
							}
							is.close();
						} catch (RuntimeException e) {
							response.getOutputStream().print("/9j/4AAQSkZJRgABAgAAAQABAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwgJC4nICIsIxwcKDcpLDAxNDQ0Hyc5PTgyPC4zNDL/2wBDAQkJCQwLDBgNDRgyIRwhMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjL/wAARCABIAHQDASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwD20Caa4mVbho1Q+59ff2p3kSf9BH/P50Rf6y/+n/xVV4LZJUkd3kXD7QEx6A9x70AWPIk/6CP+fzo8iT/oI/5/Oo/scH/PWf8A8d/wpr29tGheSeVVHUsUAH6UATeRJ/0Ef8/nR5En/QR/z+dVYBYXGfJvTLjrsdGx+Qqb7HB/z1n/APHf8KGrASeRJ/0Ef8/nR5En/QR/z+dMFlASB5s/P+7/AIVWCcuOu12XJ9iRQBc8iT/oI/5/OjyJP+gj/n86p7B6UbB6UCLnkSf9BH/P50eRJ/0Ef8/nVPYPSjYPSgC55En/AEEf8/nSrbzMflvyx9AP/r1S2D0q1Yridv8Ad/qKBktm7SQZZ2zkjrRS6b/x7N/vmigCKI4kvz7f/FU21ObaUn/nt/7KKdD/AK2+/wA/3qbb8W0v/Xb/ANlFAD8153cXKeJ/E88F3NILC3cxxwq2A2OCx9c16HmuCSxtbHxNc2TyxrK7maNWYDejHP5g8V3YPlTk3vbQ8/HufLHl2vqO1fRbTTdkuiL9mnXlWiJHPv611ui6gdT0qC5YbZCMSL6MOtUNRlsNM0xp7hkBVcqmeWPoKb4Tv9PudKWK0uUkmX55k5VlJ9VPOO2elFZ89JSabs9xYa1Oq43Wq2OijP7xfqKos5EsoAH+sf8A9CNXYz+9T6iqhXMkp/6aP/6Ea4T0RvmN6CjzG9BTtlGymIb5jego8xvQU7ZRsoAb5jegqzYOWnYED7v9RUGyrNiuJ2/3f6igCXTf+PZv980Uab/x7N/vmikMZB/rr7/PrUcfEEv/AF2/9lFS2oBuroHoSP5mkcBfPA4HnD/0AUAYfiLVZNNso47UA3l1J5MGeinBJY+wAJ/KvP8AQLKKfU3mu83DFyxeTnefU5611/iqKQXdhd7Ha2SOeGQohYoXC7XwOeNpH41z2kyadZsFl1SyDDqGk2n8iBXsYRxhQk1u/wDgng5iqk68I/ZX/AO5uBA9h5YRdu3GAOK4kWH2S6kuLQGK6izLC6+3JU+oIzXWQ6npZtgRdxyjH/LI+Z+i5qhLFNfyFLC0dFcFTczjaFB64XqT9RWFGo4KUXs+5tWoOcozW67HTafcpeW9rcoCEmVJFB9CAf605Vy0n/XR/wD0I0yxt0tILW2jz5cKpGufQYAq9BGjRsSuT5j9/wDaNee7X0PXjtqVdtG2tDyI/wC7+tHkR/3f1pDM/bRtrQ8iP+7+tHkR/wB39aAM/bVi0GJT/u1Y8iP+7+tKsaIcqMGgCtpv/Hs3++aKNN/49m/3zRQAln/x93f+8P5mlaGXzJcIjo7hhmQqR8oHYe1JZ/8AH3d/7w/mau0AUvIf/n2h/wC/zf8AxNRnT42OTYWpPvIf/ia0aKLhYz1sgn3bO3X6Skf+y1J5En/PtD/3+b/4mrlFAFMRSKQRbw5HI/fN/wDE1NboyRYfG4szHByOST/WpqKACiiigAooooAKKKKAKem/8ezf75oo03/j2b/fNFAEKtNBcTMsDOHPuO59vepftlx/z5t/30f8KKKAD7Zcf8+bf99H/Cj7Zcf8+bf99H/CiigA+2XH/Pm3/fR/wo+2XH/Pm3/fR/woooAPtlx/z5t/30f8KPtlx/z5t/30f8KKKAD7Zcf8+bf99H/Cj7Zcf8+bf99H/CiigA+2XH/Pm3/fR/wo+2XH/Pm3/fR/woooAPtlx/z5t/30f8KPtlx/z5t+Z/woooALNGjgwyNnJPSiiigD/9k=");
							//response.getOutputStream().print(e.getMessage());
						}
						response.getOutputStream().flush();
					//}
				}
			}
		} catch (Exception e) {
			log.error(e);
		}
	}
}
