/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut of interfaces agreed upon 20060707
 *******************************************************************************/

package org.eclipse.higgins.idas.api;

import java.net.URI;
import java.util.Iterator;

/**
 * Extended by interfaces which have metadata associated with them.<p>
 * TODO (Doc): Add (or point to) doc which explains metadata.
 *
 */
public interface IHasMetadata {

	/**
	 * Returns this Object's metadata elements as an Iterable.
	 * TODO (Arch): Consider overloading to take a metadata type (gets all metadata of that type)
	 * @return An Iterator of {@link IMetadata} 
	 * @throws IdASException
	 */
	public Iterator getMetadataSet() throws IdASException;

	/**
	 * Returns the specified metadata of this object.
	 * @param metadataID The identifier of the attribute to be returned.
	 * @return An {@link IMetadata} or {@code null} if none exits.
	 * @throws IdASException
	 */
	public IMetadata getMetadata(URI metadataID) throws IdASException;
	
	/**
	 * Creates a new Metadata element for this container of metadata.
	 * This call is typically followed by a call to 
	 * {@link IMetadata#setData(Object)} on the returned IMetadata
	 * Note: This operation is only applied to any backing data store after
	 * {@link IContext#applyUpdates()} is called.
	 * @param metadataID The URI specifying the type of Metadata being created
	 * @throws {@link IdASException}
	 * @throws {@link InvalidTypeException} when the metadataID is invalid
	 */
	public IMetadata addMetadata(URI metadataID) throws IdASException, InvalidTypeException;

	/**
	 * Creates a new Metadata element for this container of metadata 
	 * by copying the data from the passed IMetadata.
	 * Note: This operation is only applied to any backing data store after
	 * {@link IContext#applyUpdates()} is called.
	 * @param copyFrom an {@link IMetadata} from which data is copied to construct a new 
	 * Metadata element.
	 * @throws {@link IdASException}
	 */
	public IMetadata addMetadata(IMetadata copyFrom) throws IdASException;
	
	/**
	 * Returns true if the passed metadata set is equal to this one.
	 * The sets are compared for size, and then each metadata 
	 * item in the set is compared for equality
	 * @param metadataSet the set of metadata to compare to this one
	 * @return true if the sets are equal, false otherwise.
	 * @throws IdASException
	 */
	public boolean equals (IHasMetadata metadataSet) throws IdASException;
}
