/*******************************************************************************
 * Copyright (c) 2006 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut of interface
 *******************************************************************************/
package org.eclipse.higgins.idas.api;

import java.net.URI;

/**
 * Represents an authentication identity to be used when calling {@link org.eclipse.higgins.idas.api.IContext#open(Object)}
 * This type of identity is comprised of a set of attributes which make up the materials used in authentication.
 * Among the materials may be found one attribute which is a secret that can be managed (such as a password attribute
 * that may be changed).  
 * The manageable attribute's type may be found by calling {@link #getManagedAttrURI}. This will be null when there is no manageable attribute.
 * The manageable attribute's instance may be gotten by calling {@link #getManagedAttr}.
 * 
 * Note that it is preferable for implementors of this interface to define a:<br>
 * public static final URI ATTR_MANAGED_URI which is a URI representing the same URI returned by {{@link #getManagedAttrURI()}
 */
public interface IAuthNAttributesMaterials extends IHasAttributes 
{
	/**
	 * 
	 * @return the URI of the manageable attribute associated with this authentication materials object.
	 * null if no manageable attributes are defined
	 */
	public URI getManagedAttrURI();
	
	/**
	 * 
	 * @return the manageable attribute associated with this authentication materials object.
	 * null if no manageable attribute is defined or when it is not yet populated.
	 */
	public IAttribute getManagedAttr();
}
