/*******************************************************************************
 * Copyright (c) 2006 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/

package org.eclipse.higgins.idas.api;

import java.net.URI;

/**
 * Represents a filter assertion about a Digital Subject's Type 
 * (see {@link org.eclipse.higgins.idas.api.IDigitalSubject#getType()}).<p>
 * This assertion is made up of a comparator (operator), and assertion value.<p>
 * The filter assertion is true for a Digital Subject when: <p>
 * TODO (Doc): add assertion rules <p>
 *  
 * The particular form of the String used as an assertion is dictated by the comparator.
 */
public interface IFilterTypeAssertion extends IFilterAssertion {

	/**
	 * Compares true when a tested Digital Subject has a type equal to the specified assertion value.<p>
	 * Value: {@value}
	 */
	public static final String COMP_TYPE_EQ = "urn:org.eclipse.higgins.idas.api.comparator.type.equality";

	/**
	 * Specifies the assertion data to be tested against an IDigitalSubject's unique ID.
	 * 
	 */
	public void setAssertionValue(URI assertion) throws IdASException;

}
