/*******************************************************************************
 * Copyright (c) 2006 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial cut of interfaces
 *******************************************************************************/

package org.eclipse.higgins.idas.api.model;


/**
 * Represents value's model of simple attributes as it defined in the context's
 * schema.
 * 
 * @see org.eclipse.higgins.idas.api.ISimpleAttrValue
 * @see <a
 *      href="http://www.eclipse.org/higgins/ontologies/2006/higgins#SimpleAttribute">http://www.eclipse.org/higgins/ontologies/2006/higgins#SimpleAttribute</a>
 */
public interface IAttributeSimpleValueModel extends IAttributeValueModel {
	
	/**
	 * Determines whether given <code>Object</code> is valid value form of
	 * represented value.
	 * 
	 * @param valueForm
	 *            value to be checked.
	 * @return <code>true</code> if <code>valueForm</code> is valid value
	 *         form and <code>false</code> otherwise.
	 */
	public boolean isValidValue(Object valueForm);

	/**
	 * Determines whether given <code>String</code> is valid lexical form of
	 * represented value.
	 * 
	 * @param lexicalForm
	 *            value to be checked.
	 * @return <code>true</code> if <code>lexicalForm</code> is valid
	 *         lexical form and <code>false</code> otherwise.
	 */
	public boolean isValid(String lexicalForm);

	/**
	 * Convert given <code>String</code> to value form of represented value.
	 * 
	 * @param lexicalForm
	 *            <code>String</code> value to be converted.
	 * @return <code>Object</code> which represents valid value form of
	 *         represented value.
	 * @throws IdASModelException
	 *             if given <code>String</code> can't be converted.
	 */
	public Object toValueForm(String lexicalForm) throws IdASModelException;

	/**
	 * Convert given <code>Object</code> to lexical form of represented value.
	 * 
	 * @param value
	 *            <code>Object</code> value to be converted.
	 * @return <code>String</code> which represents valid lexical form of
	 *         represented value.
	 * @throws IdASModelException
	 *             if given <code>Object</code> can't be converted.
	 */
	public String toLexicalForm(Object value) throws IdASModelException;

	
}
