/*******************************************************************************
 * Copyright (c) 2006 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial cut of interfaces
 *******************************************************************************/
package org.eclipse.higgins.idas.api.model;

import java.net.URI;
import java.util.Iterator;

import org.eclipse.higgins.idas.api.IFilter;

// <p>
// To retrieve this representation of the context model
// {@link org.eclipse.higgins.idas.api.IContext#getContextModel()} could be used.
/**
 * Represents a model of the context object as it defined in the context's ontology model.
 * Since context's ontology model is defined in OWL DL format this interface is designed
 * to simlify query and interpretation of the context's ontology model.
 * <p>
 * The {@link java.net.URI URI} returned by
 * {@link IModel#getType() IContextSchema.getType()} could be used to retrieve
 * an {@link java.net.URL URL} of the OWL ontology where this context's model is
 * defined.
 * 
 * @see org.eclipse.higgins.idas.api.IContext IContext
 */
public interface IContextModel extends IModel {
	public static final String IDAS_BASE_URI = "http://www.eclipse.org/higgins/ontologies/2006/higgins.owl#";

	public static final String C_DS_URI = IDAS_BASE_URI + "DigitalSubject";

	public static final String C_ATT_URI = IDAS_BASE_URI + "Value";

	public static final String C_SIMP_ATT_URI = IDAS_BASE_URI + "SimpleValue";

	public static final String C_COMP_ATT_URI = IDAS_BASE_URI + "ComplexValue";

	public static final String P_ATT_URI = IDAS_BASE_URI + "attribute";

	public static final String DD_BASE_URI = "http://www.eclipse.org/higgins/ontologies/2006/display-data#";

	public static final String C_DD_URI = DD_BASE_URI + "DisplayData";

	public static final String P_DD_URI = DD_BASE_URI + "displayData";

	public static final String P_DD_LABEL_URI = DD_BASE_URI + "label";

	public static final String P_DD_DESC_URI = DD_BASE_URI + "description";

	public static final String P_DD_ORDER_URI = DD_BASE_URI + "order";

	public static final String P_DD_IMAGE_URI = DD_BASE_URI + "image";

	/**
	 * Generic method to query context model for model of the subject with the
	 * specific <code>type</code>. Returns the model of the subject with the
	 * specific <code>type</code> passed as a parameter or <code>null</code>
	 * if subject with corresponding type is not defined in this context model.
	 * 
	 * @param type
	 *            the type of the subject for wich to retrieve the model.
	 * @return the model of the subject or <code>null</code>.
	 */
	public IModel getModel(URI type);

	/**
	 * Returns IDigitalSubjectModels for the digital subjects 
	 * which are defined (allowed) in this context model.
	 * @return Iterator of {@link IDigitalSubjectModel}
	 * @see org.eclipse.higgins.idas.api.IContext#getSubject(String)
	 *      IContext#getSubject(String)
	 * @see org.eclipse.higgins.idas.api.IContext#getSubjects(IFilter)
	 *      IContext#getSubjects(IFilter)
	 */
	public Iterator getSubjectModels();
	
	/**
	 * Returns the IDigitalSubjectModel for the specified subject type
	 * @param type
	 * @return {@link IDigitalSubjectModel} for the specified subject type 
	 */	
	public IDigitalSubjectModel getSubjectModel(URI type);
}
