/*******************************************************************************
 * Copyright (c) 2006 Parity Communications, Inc.
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial cut of interfaces
 *     Jim Sermersheim (Novell) Update to 20070319 interfaces
 *******************************************************************************/

package org.eclipse.higgins.idas.api.model;

import java.net.URI;

/**
 * Represents a model of metadata as it defined in the context's ontology model.
 * 
 * @see org.eclipse.higgins.idas.api.IMetadata
 */
public interface IMetadataModel extends IModel {
	/**
	 * Returns XSD datatype of represented value as it defined in the context's
	 * schema. Please note that XSD:ENTITY, XSD:ID and XSD:IDREF are not
	 * currently supported by context's ontology models.
	 * 
	 * @return <code>URI</code> of metadata's datatype.
	 * @see <a href="http://www.w3.org/2001/XMLSchema#">XML Schema</a>
	 */
	public URI getType();

	/**
	 * Determines whether given <code>Object</code> is valid value form of
	 * represented value.
	 * 
	 * @param valueForm
	 *            value to be checked.
	 * @return <code>true</code> if <code>valueForm</code> is valid value
	 *         form and <code>false</code> otherwise.
	 */
	public boolean isValidValue(Object valueForm);

	/**
	 * Determines whether given <code>String</code> is valid lexical form of
	 * represented value.
	 * 
	 * @param lexicalForm
	 *            value to be checked.
	 * @return <code>true</code> if <code>lexicalForm</code> is valid
	 *         lexical form and <code>false</code> otherwise.
	 */
	public boolean isValid(String lexicalForm);

	/**
	 * Convert given <code>String</code> to value form of represented value.
	 * 
	 * @param lexicalForm
	 *            <code>String</code> value to be converted.
	 * @return <code>Object</code> which represents valid value form of
	 *         represented value.
	 * @throws IdASModelException
	 *             if given <code>String</code> can't be converted.
	 */
	public Object toValueForm(String lexicalForm) throws IdASModelException;

	/**
	 * Convert given <code>Object</code> to lexical form of represented value.
	 * 
	 * @param value
	 *            <code>Object</code> value to be converted.
	 * @return <code>String</code> which represents valid lexical form of
	 *         represented value.
	 * @throws IdASModelException
	 *             if given <code>Object</code> can't be converted.
	 */
	public String toLexicalForm(Object value) throws IdASModelException;
}
