/*******************************************************************************
 * Copyright (c) 2006 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial cut of interfaces
 *******************************************************************************/
package org.eclipse.higgins.idas.api.model;

import java.net.URL;

/**
 * Represents an information which could be used for visual representation of
 * subject.
 * 
 * @see <a
 *      href="http://www.eclipse.org/higgins/ontologies/2006/display-data">http://www.eclipse.org/higgins/ontologies/2006/display-data</a>
 */
public interface IDisplayData {
	/**
	 * Returns display label of subject.
	 * 
	 * @return <code>String</code> containing display label of subject.
	 */
	public String getLabel();

	/**
	 * Returns extended description of the subject.
	 * 
	 * @return <code>String</code> containing extended description of subject
	 *         or <code>null</code> if not available.
	 */
	public String getDescription();

	/**
	 * Returns an {@link URL} of the image which could be used for visual
	 * representation of subject or <code>null</code> if not available.
	 */
	public URL getImage();

	/**
	 * Returns an information on display order of subjectwhich could be used for
	 * visual representation of subject.
	 * 
	 * @return positive <code>int</code> value which represents display order
	 *         of subject or <code>0</code> if not availabe.
	 */
	public int getOrder();
}
