/*******************************************************************************
 * Copyright (c) 2006 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut of interfaces agreed upon 20060707
 *******************************************************************************/

package org.eclipse.higgins.idas.api;

import java.net.URI;

import org.eclipse.higgins.idas.api.model.IDigitalSubjectModel;

/**
 * As defined at <a href="http://spwiki.editme.com/DigitalSubjectM4">http://spwiki.editme.com/DigitalSubjectM4</a> and <a href="http://spwiki.editme.com/ContextProvider">http://spwiki.editme.com/ContextProvider</a>, This interface holds a set of {@link IDigitalSubject} objects.<p>
 * TODO (Doc): Finish javadoc on methods   
 */
public interface IDigitalSubject extends IHasMetadata, IHasAttributes
{
	/**
	 * @return The Context holding this Digital Subject.
	 * @throws IdASException
	 */
	public IContext	getContext() throws IdASException;

	/**
	 * Returns the Contextually Unique Identifier of this Digital Subject
	 * 
	 * @return Contextually Unique Identifier of this Digital Subject
	 * @throws IdASException
	 */
	public String getSubjectID() throws IdASException;
	
	/**
	 * Returns the type of this Digital Subject.  For example: http://www.eclipse.org/higgins/ontologies/2006/person#Person<p>
	 * @return This Digital Subject's type
	 * @throws IdASException
	 */
	public URI getType() throws IdASException;

	/**
	 * Removes this Digital Subject from its Context.
	 * Note: This operation is only applied to any backing data store after
	 * {@link IContext#applyUpdates()} is called. <br>
	 * Note: It is invalid to call subsequent update operations on this 
	 * IDigitalSubject instance or on any elements held by this Digital 
	 * Subject or by any of its sub-elements.
	 * 
	 * @throws IdASException
	 */
	void remove() throws IdASException;	
	
	/**
	 * Returns a model of this type of Digital Subjects as it defined in the
	 * context's schema. Returned model could be used to discover what
	 * attributes are defined in the context's schema for this type of Digital
	 * Subjects.
	 * 
	 * @return the model of this Digital Subject
	 * @throws IdASException
	 */
	public IDigitalSubjectModel getModel() throws IdASException;
}
