/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut of interfaces agreed upon 20061005
 *******************************************************************************/

package org.eclipse.higgins.idas.api;

import java.net.URI;

import org.eclipse.higgins.idas.api.IdASException;

/**
 * Represents a filter assertion. 
 * Sub-interfaces of this are defined for specific aspects of an IDigitalSubject.
 * An assertion is made up of at least a comparator (operator), 
 * and often an identifier and assertion value.<p>
 * TODO Methods here should be get*, not set* to match other interfaces.
 *  
 */
public interface IFilterAssertion {
			
	/**
	 * Set the comparison operator (equal, less, greater, beginsWith, etc.)<p>
	 * Sub-interfaces of this interface define some comparators, 
	 * other implementations may define more.<p>
	 * TODO (Impl): provide a way in which a consumer can discover allowed/supported comparators.
	 * TODO (Arch): some have expressed the belief that this should be represented as an interface rather than a string/URI
	 * @param comparator such as {@link IFilterAttributeAssertion#COMP_ATTR_EQ}. 
	 * 					The format of this string should be that of a URI to ensure 
	 * 					uniqueness among comparators.
	 */
	public void setComparator(String comparator) throws IdASException;

	/**
	 * Identifies the component to be compared.<br>
	 * For Digital Subject attribute assertions, this would be the type of the attribute (see {@link IAttribute#getAttrID()})<br>
	 * For Digital Subject CUID and Digital Subject type assertions, the type is not set.<br>
	 * For Digital Subject metadata assertions, this would be the type of the metadata (see {@link IMetadata#getID()})<br>
	 * @param id The type of the component
	 * @param bIncludeSubtypes A value of true means that subtypes of the specified type are also to be included.
	 */
	public void setID(URI id, boolean bIncludeSubtypes) throws IdASException;
	public void setID(URI id) throws IdASException;
	
	/**
	 * Calling this the same as calling {@link #setID(URI, boolean)} and setting the boolean to true. 
	 * This method is included for IFilterAssertion sub-interfaces which do not 
	 * make use of the {@link #setID(URI, boolean)} method.
	 * @param bIncludeSubtypes A value of true means that subtypes of the specified type are also to be included.
	 * @throws IdASException
	 */
	public void includeSubtypes(boolean bIncludeSubtypes) throws IdASException;
	
}
