/*******************************************************************************
 * Copyright (c) 2006 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut
 *******************************************************************************/
package org.eclipse.higgins.idas.api;

/**
 * Thrown when a specified Digital Subject is not found in the Context.
 */
public class NoSuchSubjectException extends IdASException {

	/**
	 * 
	 */
	private static final long serialVersionUID = -2061692182356732973L;

	/**
	 * @see IdASException#IdASException()
	 */
	public NoSuchSubjectException() {
		super();
	}

	/**
	 * @param message
	 * @see IdASException#IdASException(String)
	 */
	public NoSuchSubjectException(String message) {
		super(message);
	}

	/**
	 * @param message
	 * @param cause
	 * @see IdASException#IdASException(String, Throwable)
	 */
	public NoSuchSubjectException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * @param cause
	 * @see IdASException#IdASException(Throwable)
	 */
	public NoSuchSubjectException(Throwable cause) {
		super(cause);
	}

}
