/*******************************************************************************
 * Copyright (c) 2006 Parity Communications, Inc.
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial cut of interfaces
 *     Jim Sermersheim (Novell) Update to 20070319 interfaces
 *******************************************************************************/

package org.eclipse.higgins.idas.api.model;

import java.net.URI;
import java.util.Iterator;

import org.eclipse.higgins.idas.api.IHasAttributes;

/**
 * Represents a model of attribute as it defined in the context's ontology model.
 * <p>
 * The type returned by
 * {@link org.eclipse.higgins.idas.api.model.IModel#getType()}
 * could be used in
 * {@link IHasAttributes#addAttribute(URI)}
 * to create an {@link org.eclipse.higgins.idas.api.IAttribute} of represented type.
 * 
 * @see org.eclipse.higgins.idas.api.IAttribute
 */
public interface IAttributeModel extends IModel {
	/**
	 * Returns value model of represented type of attribute as it defined in the
	 * context's ontology model.
	 */
	public IAttributeValueModel getValueModel();
	
	public boolean isDirect();

	/**
	 * Returns IMetadataModels for the metadata elements
	 * which are defined (allowed) in this attribute model.
	 * @return Iterator of {@link IMetadataModel}
	 */
	public Iterator getMetadataModels(); 
	
	/**
	 * Returns IMetadataModel for the specified metadata ID
	 * 
	 * @param metadataID the type of metadata.
	 * @return metadata's model of requested type or <code>null</code> if
	 *         the specified metadataID is not defined or not valid for this
	 *         attribute model.
	 */
	public IMetadataModel getMetadataModel(URI metadataID);	
	
}
