/*******************************************************************************
 * Copyright (c) 2008 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim
 *******************************************************************************/

package org.eclipse.higgins.idas.api;

import org.eclipse.higgins.idas.api.model.IMetadataValueModel;

/**
 * Holds the value of a metadata element.<p>
 * This interface is not intended to be instantiated (only used as a super-interface).
 * When the value is a Literal ({@link #isSimple()} returns true), an instance of this interface may be cast to {@link ISimpleMetaValue}, and the table found at {@link ITypedValue#getData()} is used to determine the type returned from {@link ITypedValue#getData()}.    
 * When the value is a Resource ({@link #isSimple()} returns false), an instance of this interface may be cast to {@link IComplexMetaValue}.    
 */
public interface IMetadataValue {

	/**
	 * @throws IdASException
	 */
	public boolean isSimple() throws IdASException;

	/**
	 * Removes this value from its IMetadata container
	 * Note: This operation is only applied to any backing data store after
	 * IContext.applyUpdates() is called.
	 * @throws {@link IdASException}
	 */
	public void remove() throws IdASException;
	
	/**
	 * returns true if this IMetadataValue is equal to the passed IMetadataValue
	 * This should test the metadata ID and the value for equality.
	 */
	public boolean equals(IMetadataValue value) throws IdASException;

	/**
	 * Returns the model for this type of metadata value as it is 
	 * defined in the context's schema. 
	 *  
	 * @return the model for this metadata value
	 * @throws IdASException
	 */
	public IMetadataValueModel getModel() throws IdASException;
}
