/*******************************************************************************
 * Copyright (c) 2008 Novell, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Jim Sermersheim
 *******************************************************************************/

package org.eclipse.higgins.idas.api.model;

import java.net.URI;


/**
 * Represents a metadata value's model as defined in the context's ontology model.
 */
public interface IMetadataValueModel extends IModel {
	/**
	 * Returns XSD datatype of the value as defined in the context's
	 * schema. Please note that XSD:ENTITY, XSD:ID and XSD:IDREF are not
	 * currently supported by context's ontology models.
	 * 
	 * @return <code>URI</code> of value's datatype.
	 * @see <a href="http://www.w3.org/2001/XMLSchema#">XML Schema</a>
	 */
	public URI getType();

	/**
	 * Used to determine whether this represents a simple value.
	 * 
	 * @return <code>true</code> if represented value is simple (non-complex) and
	 *         <code>false</code> otherwise.
	 */
	public boolean isSimple();
	
}