/*******************************************************************************
 * Copyright (c) 2006 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial cut of interfaces
 *******************************************************************************/

package org.eclipse.higgins.idas.api.model;

import org.eclipse.higgins.idas.api.IdASException;


/**
 * Represents value's model of attributes as it defined in the context's ontology model.
 */
public interface IAttributeValueModel extends IModel {
	/**
	 * Returns non negative integer value which represents maximum cardinality
	 * of represented attribute's value or <code>-1</code> if not defined.
	 * @throws IdASException 
	 * 
	 * @see #getMaxCardinality()
	 * @deprecated This has been moved to IAttributeModel
	 */
	public int getMaxCardinality() throws IdASException;

	/**
	 * Returns non negative integer value which represents minimum cardinality
	 * of represented attribute's value or <code>-1</code> if not defined.
	 * @throws IdASException 
	 * 
	 * @see #getMinCardinality()
	 * @deprecated This has been moved to IAttributeModel
	 */
	public int getMinCardinality() throws IdASException;

	/**
	 * Determines whether this value model represents simple attribute's value.
	 * 
	 * @return <code>true</code> if represented value is simple and
	 *         <code>false</code> otherwise.
	 * @throws IdASException 
	 */
	public boolean isSimple() throws IdASException;	

}



