/*******************************************************************************
 * Copyright (c) 2006 Parity Communications, Inc.
 * Copyright (c) 2007-2008 Novell, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial cut of interfaces
 *     Jim Sermersheim
 *******************************************************************************/

package org.eclipse.higgins.idas.api.model;

import java.net.URI;

import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.IdASException;

/**
 * Represents a model of attribute as it defined in the context's ontology model.
 * <p>
 * The type returned by
 * {@link org.eclipse.higgins.idas.api.model.IModel#getType()}
 * could be used in
 * {@link IHasAttributes#addAttribute(URI)}
 * to create an {@link org.eclipse.higgins.idas.api.IAttribute} of represented type.
 * 
 * @see org.eclipse.higgins.idas.api.IAttribute
 */
public interface IAttributeModel extends IModel {
	/**
	 * Returns value model of represented type of attribute as it defined in the
	 * context's ontology model.
	 * @deprecated Attribute values can all have different value models now 
	 */
	public IAttributeValueModel getValueModel() throws IdASException;
	
	/**
	 * TODO: What is this for?
	 * @deprecated Don't know what this is 
	 */
	public boolean isDirect() throws IdASException;

	/**
	 * Returns the maximum number of values required by occurrences of this
	 * attribute.
	 * When this IAttributeModel is returned from 
	 * {@link IEntityModel#getAttributeModel(URI)} or 
	 * {@link IEntityModel#getAttributeModels()}, the maximum cardinality 
	 * refers to occurrences of this attribute in relationship to that Entity
	 * type.
	 * When this IAttributeModel is returned from {@link IContextModel#getModel(URI)},
	 * the minimum cardinality refers to the default
	 * behavior of occurrences of this attribute, but the cardinality may be overridden
	 * as the attribute is applied to any given Entity type.  Therefore,
	 * it's best to query an attribute's cardinality as it applies to a particular 
	 * Entity.
	 * @return A positive number indicates the maximum number of values that may 
	 * be present. The value -1 indicates that there is no limit to the number of values that may 
	 * be present. The value 0 has no meaning and should not be returned. 
	 * @see #getMaxCardinality()
	 */
	public int getMaxCardinality() throws IdASException;

	/**
	 * Returns the minimum number of values required by occurrences of this
	 * attribute.
	 * When this IAttributeModel is returned from 
	 * {@link IEntityModel#getAttributeModel(URI)} or 
	 * {@link IEntityModel#getAttributeModels()}, the minimum cardinality 
	 * refers to occurrences of this attribute in relationship to that Entity
	 * type.
	 * When this IAttributeModel is returned from {@link IContextModel#getModel(URI)}, 
	 * the minimum cardinality refers to the default
	 * behavior of occurrences of this attribute, but the cardinality may be overridden
	 * as the attribute is applied to any given Entity type.  Therefore,
	 * it's best to query an attribute's cardinality as it applies to a particular 
	 * Entity.
	 * @return 0 if no values are required to be present. This of course also means the 
	 * attribute itself is optional. A positive number indicates the minimum number of values that must 
	 * be present. The value -1 has no meaning and should not be returned. 
	 * @see #getMinCardinality()
	 */
	public int getMinCardinality() throws IdASException;	
	
}
