/*******************************************************************************
 * Copyright (c) 2006-2007 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut of interface
 *******************************************************************************/

package org.eclipse.higgins.idas.api;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Date;

/**
 * 
 *
 */
public interface ITypedValue {
	/**
	 * Value: {@value}
	 */
	public static final String BASE_XML_SCHEMA_URI = "http://www.w3.org/2001/XMLSchema#";
	/**
	 * Value: {@value}
	 */
	public static final String OWL_TYPE_SUFFIX = "SimpleValue";

	public static final String ANYURI_XML_TYPE_STR = "anyURI";
	public static final String ANYURI_OWL_TYPE_STR = ANYURI_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String ANYURI_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + ANYURI_OWL_TYPE_STR;
	public static final String ANYURI_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + ANYURI_XML_TYPE_STR;
	public static final URI ANYURI_TYPE_URI = URI.create(ANYURI_ATTR_VALUE_TYPE_URI_STR);

	public static final String BASE64BINARY_XML_TYPE_STR = "base64Binary";
	public static final String BASE64BINARY_OWL_TYPE_STR = BASE64BINARY_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String BASE64BINARY_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + BASE64BINARY_OWL_TYPE_STR;
	public static final String BASE64BINARY_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + BASE64BINARY_XML_TYPE_STR;
	public static final URI BASE64BINARY_TYPE_URI = URI.create(BASE64BINARY_ATTR_VALUE_TYPE_URI_STR);

	public static final String BOOLEAN_XML_TYPE_STR = "boolean";
	public static final String BOOLEAN_OWL_TYPE_STR = BOOLEAN_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String BOOLEAN_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + BOOLEAN_OWL_TYPE_STR;
	public static final String BOOLEAN_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + BOOLEAN_XML_TYPE_STR;
	public static final URI BOOLEAN_TYPE_URI = URI.create(BOOLEAN_ATTR_VALUE_TYPE_URI_STR);

	public static final String BYTE_XML_TYPE_STR = "byte";
	public static final String BYTE_OWL_TYPE_STR = BYTE_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String BYTE_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + BYTE_OWL_TYPE_STR;
	public static final String BYTE_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + BYTE_XML_TYPE_STR;
	public static final URI BYTE_TYPE_URI = URI.create(BYTE_ATTR_VALUE_TYPE_URI_STR);

	public static final String DATE_XML_TYPE_STR = "date";
	public static final String DATE_OWL_TYPE_STR = DATE_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String DATE_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + DATE_OWL_TYPE_STR;
	public static final String DATE_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + DATE_XML_TYPE_STR;
	public static final URI DATE_TYPE_URI = URI.create(DATE_ATTR_VALUE_TYPE_URI_STR);

	public static final String DATETIME_XML_TYPE_STR = "dateTime";
	public static final String DATETIME_OWL_TYPE_STR = DATETIME_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String DATETIME_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + DATETIME_OWL_TYPE_STR;
	public static final String DATETIME_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + DATETIME_XML_TYPE_STR;
	public static final URI DATETIME_TYPE_URI = URI.create(DATETIME_ATTR_VALUE_TYPE_URI_STR);

	public static final String DECIMAL_XML_TYPE_STR = "decimal";
	public static final String DECIMAL_OWL_TYPE_STR = DECIMAL_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String DECIMAL_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + DECIMAL_OWL_TYPE_STR;
	public static final String DECIMAL_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + DECIMAL_XML_TYPE_STR;
	public static final URI DECIMAL_TYPE_URI = URI.create(DECIMAL_ATTR_VALUE_TYPE_URI_STR);

	public static final String DOUBLE_XML_TYPE_STR = "double";
	public static final String DOUBLE_OWL_TYPE_STR = DOUBLE_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String DOUBLE_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + DOUBLE_OWL_TYPE_STR;
	public static final String DOUBLE_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + DOUBLE_XML_TYPE_STR;
	public static final URI DOUBLE_TYPE_URI = URI.create(DOUBLE_ATTR_VALUE_TYPE_URI_STR);

	public static final String FLOAT_XML_TYPE_STR = "float";
	public static final String FLOAT_OWL_TYPE_STR = FLOAT_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String FLOAT_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + FLOAT_OWL_TYPE_STR;
	public static final String FLOAT_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + FLOAT_XML_TYPE_STR;
	public static final URI FLOAT_TYPE_URI = URI.create(FLOAT_ATTR_VALUE_TYPE_URI_STR);

	public static final String GDAY_XML_TYPE_STR = "gDay";
	public static final String GDAY_OWL_TYPE_STR = GDAY_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String GDAY_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + GDAY_OWL_TYPE_STR;
	public static final String GDAY_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + GDAY_XML_TYPE_STR;
	public static final URI GDAY_TYPE_URI = URI.create(GDAY_ATTR_VALUE_TYPE_URI_STR);

	public static final String GMONTH_XML_TYPE_STR = "gMonth";
	public static final String GMONTH_OWL_TYPE_STR = GMONTH_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String GMONTH_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + GMONTH_OWL_TYPE_STR;
	public static final String GMONTH_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + GMONTH_XML_TYPE_STR;
	public static final URI GMONTH_TYPE_URI = URI.create(GMONTH_ATTR_VALUE_TYPE_URI_STR);

	public static final String GMONTHDAY_XML_TYPE_STR = "gMonthDay";
	public static final String GMONTHDAY_OWL_TYPE_STR = GMONTHDAY_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String GMONTHDAY_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + GMONTHDAY_OWL_TYPE_STR;
	public static final String GMONTHDAY_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + GMONTHDAY_XML_TYPE_STR;
	public static final URI GMONTHDAY_TYPE_URI = URI.create(GMONTHDAY_ATTR_VALUE_TYPE_URI_STR);

	public static final String GYEAR_XML_TYPE_STR = "gYear";
	public static final String GYEAR_OWL_TYPE_STR = GYEAR_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String GYEAR_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + GYEAR_OWL_TYPE_STR;
	public static final String GYEAR_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + GYEAR_XML_TYPE_STR;
	public static final URI GYEAR_TYPE_URI = URI.create(GYEAR_ATTR_VALUE_TYPE_URI_STR);

	public static final String GYEARMONTH_XML_TYPE_STR = "gYearMonth";
	public static final String GYEARMONTH_OWL_TYPE_STR = GYEARMONTH_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String GYEARMONTH_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + GYEARMONTH_OWL_TYPE_STR;
	public static final String GYEARMONTH_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + GYEARMONTH_XML_TYPE_STR;
	public static final URI GYEARMONTH_TYPE_URI = URI.create(GYEARMONTH_ATTR_VALUE_TYPE_URI_STR);

	public static final String HEXBINARY_XML_TYPE_STR = "hexBinary";
	public static final String HEXBINARY_OWL_TYPE_STR = HEXBINARY_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String HEXBINARY_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + HEXBINARY_OWL_TYPE_STR;
	public static final String HEXBINARY_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + HEXBINARY_XML_TYPE_STR;
	public static final URI HEXBINARY_TYPE_URI = URI.create(HEXBINARY_ATTR_VALUE_TYPE_URI_STR);

	public static final String INT_XML_TYPE_STR = "int";
	public static final String INT_OWL_TYPE_STR = INT_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String INT_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + INT_OWL_TYPE_STR;
	public static final String INT_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + INT_XML_TYPE_STR;
	public static final URI INT_TYPE_URI = URI.create(INT_ATTR_VALUE_TYPE_URI_STR);

	public static final String INTEGER_XML_TYPE_STR = "integer";
	public static final String INTEGER_OWL_TYPE_STR = INTEGER_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String INTEGER_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + INTEGER_OWL_TYPE_STR;
	public static final String INTEGER_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + INTEGER_XML_TYPE_STR;
	public static final URI INTEGER_TYPE_URI = URI.create(INTEGER_ATTR_VALUE_TYPE_URI_STR);

	public static final String LANGUAGE_XML_TYPE_STR = "language";
	public static final String LANGUAGE_OWL_TYPE_STR = LANGUAGE_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String LANGUAGE_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + LANGUAGE_OWL_TYPE_STR;
	public static final String LANGUAGE_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + LANGUAGE_XML_TYPE_STR;
	public static final URI LANGUAGE_TYPE_URI = URI.create(LANGUAGE_ATTR_VALUE_TYPE_URI_STR);

	public static final String LONG_XML_TYPE_STR = "long";
	public static final String LONG_OWL_TYPE_STR = LONG_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String LONG_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + LONG_OWL_TYPE_STR;
	public static final String LONG_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + LONG_XML_TYPE_STR;
	public static final URI LONG_TYPE_URI = URI.create(LONG_ATTR_VALUE_TYPE_URI_STR);

	public static final String NAME_XML_TYPE_STR = "Name";
	public static final String NAME_OWL_TYPE_STR = NAME_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String NAME_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + NAME_OWL_TYPE_STR;
	public static final String NAME_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + NAME_XML_TYPE_STR;
	public static final URI NAME_TYPE_URI = URI.create(NAME_ATTR_VALUE_TYPE_URI_STR);

	public static final String NCNAME_XML_TYPE_STR = "NCName";
	public static final String NCNAME_OWL_TYPE_STR = NCNAME_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String NCNAME_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + NCNAME_OWL_TYPE_STR;
	public static final String NCNAME_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + NCNAME_XML_TYPE_STR;
	public static final URI NCNAME_TYPE_URI = URI.create(NCNAME_ATTR_VALUE_TYPE_URI_STR);

	public static final String NEGATIVEINTEGER_XML_TYPE_STR = "negativeInteger";
	public static final String NEGATIVEINTEGER_OWL_TYPE_STR = NEGATIVEINTEGER_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String NEGATIVEINTEGER_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + NEGATIVEINTEGER_OWL_TYPE_STR;
	public static final String NEGATIVEINTEGER_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + NEGATIVEINTEGER_XML_TYPE_STR;
	public static final URI NEGATIVEINTEGER_TYPE_URI = URI.create(NEGATIVEINTEGER_ATTR_VALUE_TYPE_URI_STR);

	public static final String NMTOKEN_XML_TYPE_STR = "NMToken";
	public static final String NMTOKEN_OWL_TYPE_STR = NMTOKEN_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String NMTOKEN_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + NMTOKEN_OWL_TYPE_STR;
	public static final String NMTOKEN_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + NMTOKEN_XML_TYPE_STR;
	public static final URI NMTOKEN_TYPE_URI = URI.create(NMTOKEN_ATTR_VALUE_TYPE_URI_STR);

	public static final String NONPOSITIVEINTEGER_XML_TYPE_STR = "nonPositiveInteger";
	public static final String NONPOSITIVEINTEGER_OWL_TYPE_STR = NONPOSITIVEINTEGER_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String NONPOSITIVEINTEGER_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + NONPOSITIVEINTEGER_OWL_TYPE_STR;
	public static final String NONPOSITIVEINTEGER_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + NONPOSITIVEINTEGER_XML_TYPE_STR;
	public static final URI NONPOSITIVEINTEGER_TYPE_URI = URI.create(NONPOSITIVEINTEGER_ATTR_VALUE_TYPE_URI_STR);

	public static final String NONNEGATIVEINTEGER_XML_TYPE_STR = "nonNegativeInteger";
	public static final String NONNEGATIVEINTEGER_OWL_TYPE_STR = NONNEGATIVEINTEGER_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String NONNEGATIVEINTEGER_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + NONNEGATIVEINTEGER_OWL_TYPE_STR;
	public static final String NONNEGATIVEINTEGER_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + NONNEGATIVEINTEGER_XML_TYPE_STR;
	public static final URI NONNEGATIVEINTEGER_TYPE_URI = URI.create(NONNEGATIVEINTEGER_ATTR_VALUE_TYPE_URI_STR);

	public static final String NORMALIZEDSTRING_XML_TYPE_STR = "normalizedString";
	public static final String NORMALIZEDSTRING_OWL_TYPE_STR = NORMALIZEDSTRING_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String NORMALIZEDSTRING_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + NORMALIZEDSTRING_OWL_TYPE_STR;
	public static final String NORMALIZEDSTRING_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + NORMALIZEDSTRING_XML_TYPE_STR;
	public static final URI NORMALIZEDSTRING_TYPE_URI = URI.create(NORMALIZEDSTRING_ATTR_VALUE_TYPE_URI_STR);

	public static final String POSITIVEINTEGER_XML_TYPE_STR = "positiveInteger";
	public static final String POSITIVEINTEGER_OWL_TYPE_STR = POSITIVEINTEGER_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String POSITIVEINTEGER_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + POSITIVEINTEGER_OWL_TYPE_STR;
	public static final String POSITIVEINTEGER_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + POSITIVEINTEGER_XML_TYPE_STR;
	public static final URI POSITIVEINTEGER_TYPE_URI = URI.create(POSITIVEINTEGER_ATTR_VALUE_TYPE_URI_STR);

	public static final String SHORT_XML_TYPE_STR = "short";
	public static final String SHORT_OWL_TYPE_STR = SHORT_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String SHORT_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + SHORT_OWL_TYPE_STR;
	public static final String SHORT_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + SHORT_XML_TYPE_STR;
	public static final URI SHORT_TYPE_URI = URI.create(SHORT_ATTR_VALUE_TYPE_URI_STR);

	public static final String STRING_XML_TYPE_STR = "string";
	public static final String STRING_OWL_TYPE_STR = STRING_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String STRING_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + STRING_OWL_TYPE_STR;
	public static final String STRING_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + STRING_XML_TYPE_STR;
	public static final URI STRING_TYPE_URI = URI.create(STRING_ATTR_VALUE_TYPE_URI_STR);

	public static final String TIME_XML_TYPE_STR = "time";
	public static final String TIME_OWL_TYPE_STR = TIME_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String TIME_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + TIME_OWL_TYPE_STR;
	public static final String TIME_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + TIME_XML_TYPE_STR;
	public static final URI TIME_TYPE_URI = URI.create(TIME_ATTR_VALUE_TYPE_URI_STR);

	public static final String TOKEN_XML_TYPE_STR = "token";
	public static final String TOKEN_OWL_TYPE_STR = TOKEN_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String TOKEN_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + TOKEN_OWL_TYPE_STR;
	public static final String TOKEN_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + TOKEN_XML_TYPE_STR;
	public static final URI TOKEN_TYPE_URI = URI.create(TOKEN_ATTR_VALUE_TYPE_URI_STR);

	public static final String UNSIGNEDBYTE_XML_TYPE_STR = "unsignedByte";
	public static final String UNSIGNEDBYTE_OWL_TYPE_STR = UNSIGNEDBYTE_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String UNSIGNEDBYTE_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + UNSIGNEDBYTE_OWL_TYPE_STR;
	public static final String UNSIGNEDBYTE_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + UNSIGNEDBYTE_XML_TYPE_STR;
	public static final URI UNSIGNEDBYTE_TYPE_URI = URI.create(UNSIGNEDBYTE_ATTR_VALUE_TYPE_URI_STR);

	public static final String UNSIGNEDINT_XML_TYPE_STR = "unsignedtInt";
	public static final String UNSIGNEDINT_OWL_TYPE_STR = UNSIGNEDINT_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String UNSIGNEDINT_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + UNSIGNEDINT_OWL_TYPE_STR;
	public static final String UNSIGNEDINT_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + UNSIGNEDINT_XML_TYPE_STR;
	public static final URI UNSIGNEDINT_TYPE_URI = URI.create(UNSIGNEDINT_ATTR_VALUE_TYPE_URI_STR);

	public static final String UNSIGNEDLONG_XML_TYPE_STR = "unsignedLong";
	public static final String UNSIGNEDLONG_OWL_TYPE_STR = UNSIGNEDLONG_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String UNSIGNEDLONG_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + UNSIGNEDLONG_OWL_TYPE_STR;
	public static final String UNSIGNEDLONG_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + UNSIGNEDLONG_XML_TYPE_STR;
	public static final URI UNSIGNEDLONG_TYPE_URI = URI.create(UNSIGNEDLONG_ATTR_VALUE_TYPE_URI_STR);

	public static final String UNSIGNEDSHORT_XML_TYPE_STR = "unsignedShort";
	public static final String UNSIGNEDSHORT_OWL_TYPE_STR = UNSIGNEDSHORT_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String UNSIGNEDSHORT_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + UNSIGNEDSHORT_OWL_TYPE_STR;
	public static final String UNSIGNEDSHORT_ATTR_VALUE_TYPE_URI_STR = BASE_XML_SCHEMA_URI + UNSIGNEDSHORT_XML_TYPE_STR;
	public static final URI UNSIGNEDSHORT_TYPE_URI = URI.create(UNSIGNEDSHORT_ATTR_VALUE_TYPE_URI_STR);
	
	public static final String RELATIVEENTITYUDI_XML_TYPE_STR = "RelativeEntityUDI";
	public static final String RELATIVEENTITYUDI_OWL_TYPE_STR = RELATIVEENTITYUDI_XML_TYPE_STR + OWL_TYPE_SUFFIX;
	public static final String RELATIVEENTITYUDI_ATTR_VALUE_URI_STR = IAttributeValue.BASE_OWL_URI + RELATIVEENTITYUDI_OWL_TYPE_STR;
	public static final String RELATIVEENTITYUDI_ATTR_VALUE_TYPE_URI_STR = IAttributeValue.BASE_OWL_URI + RELATIVEENTITYUDI_XML_TYPE_STR;
	public static final URI RELATIVEENTITYUDI_TYPE_URI = URI.create(RELATIVEENTITYUDI_ATTR_VALUE_TYPE_URI_STR);

	public static final String typeMap[][] = {
		{STRING_ATTR_VALUE_TYPE_URI_STR, String.class.getName()}, 
		{NORMALIZEDSTRING_ATTR_VALUE_TYPE_URI_STR, String.class.getName()}, 
		{BOOLEAN_ATTR_VALUE_TYPE_URI_STR, Boolean.class.getName()}, 
		{DECIMAL_ATTR_VALUE_TYPE_URI_STR, BigDecimal.class.getName()}, 
		{INTEGER_ATTR_VALUE_TYPE_URI_STR, BigInteger.class.getName()}, 
		{NONNEGATIVEINTEGER_ATTR_VALUE_TYPE_URI_STR, BigInteger.class.getName()}, 
		{POSITIVEINTEGER_ATTR_VALUE_TYPE_URI_STR, BigInteger.class.getName()}, 
		{NONPOSITIVEINTEGER_ATTR_VALUE_TYPE_URI_STR, BigInteger.class.getName()}, 
		{NEGATIVEINTEGER_ATTR_VALUE_TYPE_URI_STR, BigInteger.class.getName()}, 
		{FLOAT_ATTR_VALUE_TYPE_URI_STR, Float.class.getName()}, 
		{DOUBLE_ATTR_VALUE_TYPE_URI_STR, Double.class.getName()}, 
		{LONG_ATTR_VALUE_TYPE_URI_STR, Long.class.getName()}, 
		{INT_ATTR_VALUE_TYPE_URI_STR, Integer.class.getName()}, 
		{SHORT_ATTR_VALUE_TYPE_URI_STR, Short.class.getName()}, 
		{BYTE_ATTR_VALUE_TYPE_URI_STR, Byte.class.getName()}, 
		{UNSIGNEDLONG_ATTR_VALUE_TYPE_URI_STR, BigInteger.class.getName()}, 
		{UNSIGNEDINT_ATTR_VALUE_TYPE_URI_STR, BigInteger.class.getName()}, 
		{UNSIGNEDSHORT_ATTR_VALUE_TYPE_URI_STR, BigInteger.class.getName()}, 
		{UNSIGNEDBYTE_ATTR_VALUE_TYPE_URI_STR, BigInteger.class.getName()}, 
		{BASE64BINARY_ATTR_VALUE_TYPE_URI_STR, ByteBuffer.class.getName()}, 
		{HEXBINARY_ATTR_VALUE_TYPE_URI_STR, ByteBuffer.class.getName()}, 
		{DATETIME_ATTR_VALUE_TYPE_URI_STR, Date.class.getName()}, 
		{TIME_ATTR_VALUE_TYPE_URI_STR, Date.class.getName()}, 
		{DATE_ATTR_VALUE_TYPE_URI_STR, Date.class.getName()}, 
		{GYEARMONTH_ATTR_VALUE_TYPE_URI_STR, Date.class.getName()}, 
		{GYEAR_ATTR_VALUE_TYPE_URI_STR, Date.class.getName()}, 
		{GMONTHDAY_ATTR_VALUE_TYPE_URI_STR, Date.class.getName()}, 
		{GDAY_ATTR_VALUE_TYPE_URI_STR, Date.class.getName()}, 
		{GMONTH_ATTR_VALUE_TYPE_URI_STR, Date.class.getName()}, 
		{ANYURI_ATTR_VALUE_TYPE_URI_STR, URI.class.getName()}, 
		{TOKEN_ATTR_VALUE_TYPE_URI_STR, String.class.getName()}, 
		{LANGUAGE_ATTR_VALUE_TYPE_URI_STR, String.class.getName()}, 
		{NMTOKEN_ATTR_VALUE_TYPE_URI_STR, String.class.getName()}, 
		{NAME_ATTR_VALUE_TYPE_URI_STR, String.class.getName()}, 
		{NCNAME_ATTR_VALUE_TYPE_URI_STR, String.class.getName()}
	};

	/**
	 * @deprecated Use getModel on the attribute value 
	 */
	public URI getDataType()throws IdASException; // The simple type (string, integer, etc.)
	
	/**
	 * Returns a lexical representation if this value is a literal
	 * @throws IdASException
	 */
	public String getLexical() throws IdASException;
	
	/**
	 * Returns the canonical representation if this value is a literal
	 * @throws IdASException
	 */
	public String getCanonical() throws IdASException;

	/**
	 * Returns the underlying Java object holding this simple type's value.
	 * Modifications made to the returned object have no effect on this 
	 * simple type's value.  In other words, the Context Provider ensures immutable behavior.<p>
	 * This table specifies the mappings between Higgins OWL datatypes (in the higgins ontology http://www.eclipse.org/higgins/ontologies/2008/6/higgins), XML schema types (in the http://www.w3.org/2001/XMLSchema namespace), Java classes (returned by {@link #getData()}), and IdAS basic value implementations.
	 * <table border="1" >
	 * <tr><th>Higgins OWL type<th>XML schema type<th>Java class 
	 * <tr><td>{@value #STRING_OWL_TYPE_STR}</td><td>{@value #STRING_XML_TYPE_STR}</td><td>{@link String}</td></tr>
	 * <tr><td>{@value #NORMALIZEDSTRING_OWL_TYPE_STR}</td><td>{@value #NORMALIZEDSTRING_XML_TYPE_STR}</td><td>{@link String} constrained to normalizedString</td></tr>
	 * <tr><td>{@value #BOOLEAN_OWL_TYPE_STR}</td><td>{@value #BOOLEAN_XML_TYPE_STR}</td><td>{@link Boolean}</td></tr>
	 * <tr><td>{@value #DECIMAL_OWL_TYPE_STR}</td><td>{@value #DECIMAL_XML_TYPE_STR}</td><td>{@link java.math.BigDecimal}</td></tr>
	 * <tr><td>{@value #INTEGER_OWL_TYPE_STR}</td><td>{@value #INTEGER_XML_TYPE_STR}</td><td>{@link java.math.BigInteger}</td></tr>
	 * <tr><td>{@value #NONNEGATIVEINTEGER_OWL_TYPE_STR}</td><td>{@value #NONNEGATIVEINTEGER_XML_TYPE_STR}</td><td>{@link java.math.BigInteger}</td></tr>
	 * <tr><td>{@value #POSITIVEINTEGER_OWL_TYPE_STR}</td><td>{@value #POSITIVEINTEGER_XML_TYPE_STR}</td><td>{@link java.math.BigInteger}</td></tr>
	 * <tr><td>{@value #NONPOSITIVEINTEGER_OWL_TYPE_STR}</td><td>{@value #NONPOSITIVEINTEGER_XML_TYPE_STR}</td><td>{@link java.math.BigInteger}</td></tr>
	 * <tr><td>{@value #NEGATIVEINTEGER_OWL_TYPE_STR}</td><td>{@value #NEGATIVEINTEGER_XML_TYPE_STR}</td><td>{@link java.math.BigInteger}</td></tr>
	 * <tr><td>{@value #FLOAT_OWL_TYPE_STR}</td><td>{@value #FLOAT_XML_TYPE_STR}</td><td>{@link Float}</td></tr>
	 * <tr><td>{@value #DOUBLE_OWL_TYPE_STR}</td><td>{@value #DOUBLE_XML_TYPE_STR}</td><td>{@link Double}</td></tr>
	 * <tr><td>{@value #LONG_OWL_TYPE_STR}</td><td>{@value #LONG_XML_TYPE_STR}</td><td>{@link Long}</td></tr>
	 * <tr><td>{@value #INT_OWL_TYPE_STR}</td><td>{@value #INT_XML_TYPE_STR}</td><td>{@link Integer}</td></tr>
	 * <tr><td>{@value #SHORT_OWL_TYPE_STR}</td><td>{@value #SHORT_XML_TYPE_STR}</td><td>{@link Short}</td></tr>
	 * <tr><td>{@value #BYTE_OWL_TYPE_STR}</td><td>{@value #BYTE_XML_TYPE_STR}</td><td>{@link Byte}</td></tr>
	 * <tr><td>{@value #UNSIGNEDLONG_OWL_TYPE_STR}</td><td>{@value #UNSIGNEDLONG_XML_TYPE_STR}</td><td>{@link java.math.BigInteger}</td></tr>
	 * <tr><td>{@value #UNSIGNEDINT_OWL_TYPE_STR}</td><td>{@value #UNSIGNEDINT_XML_TYPE_STR}</td><td>{@link java.math.BigInteger}</td></tr>
	 * <tr><td>{@value #UNSIGNEDSHORT_OWL_TYPE_STR}</td><td>{@value #UNSIGNEDSHORT_XML_TYPE_STR}</td><td>{@link java.math.BigInteger}</td></tr>
	 * <tr><td>{@value #UNSIGNEDBYTE_OWL_TYPE_STR}</td><td>{@value #UNSIGNEDBYTE_XML_TYPE_STR}</td><td>{@link java.math.BigInteger}</td></tr>
	 * <tr><td>{@value #HEXBINARY_OWL_TYPE_STR}</td><td>{@value #HEXBINARY_XML_TYPE_STR}</td><td>{@link java.nio.ByteBuffer}</td></tr>
	 * <tr><td>{@value #BASE64BINARY_OWL_TYPE_STR}</td><td>{@value #BASE64BINARY_XML_TYPE_STR}</td><td>{@link java.nio.ByteBuffer}</td></tr>
	 * <tr><td>{@value #DATETIME_OWL_TYPE_STR}</td><td>{@value #DATETIME_XML_TYPE_STR}</td><td>{@link java.util.Date}</td></tr>
	 * <tr><td>{@value #TIME_OWL_TYPE_STR}</td><td>{@value #TIME_XML_TYPE_STR}</td><td>{@link java.util.Date}</td></tr>
	 * <tr><td>{@value #DATE_OWL_TYPE_STR}</td><td>{@value #DATE_XML_TYPE_STR}</td><td>{@link java.util.Date}</td></tr>
	 * <tr><td>{@value #GYEARMONTH_OWL_TYPE_STR}</td><td>{@value #GYEARMONTH_XML_TYPE_STR}</td><td>{@link java.util.Date}</td></tr>
	 * <tr><td>{@value #GYEAR_OWL_TYPE_STR}</td><td>{@value #GYEAR_XML_TYPE_STR}</td><td>{@link java.util.Date}</td></tr>
	 * <tr><td>{@value #GMONTHDAY_OWL_TYPE_STR}</td><td>{@value #GMONTHDAY_XML_TYPE_STR}</td><td>{@link java.util.Date}</td></tr>
	 * <tr><td>{@value #GDAY_OWL_TYPE_STR}</td><td>{@value #GDAY_XML_TYPE_STR}</td><td>{@link java.util.Date}</td></tr>
	 * <tr><td>{@value #GMONTH_OWL_TYPE_STR}</td><td>{@value #GMONTH_XML_TYPE_STR}</td><td>{@link java.util.Date}</td></tr>
	 * <tr><td>{@value #ANYURI_OWL_TYPE_STR}</td><td>{@value #ANYURI_XML_TYPE_STR}</td><td>{@link URI}</td></tr>
	 * <tr><td>{@value #TOKEN_OWL_TYPE_STR}</td><td>{@value #TOKEN_XML_TYPE_STR}</td><td>{@link String} constrained to token</td></tr>
	 * <tr><td>{@value #LANGUAGE_OWL_TYPE_STR}</td><td>{@value #LANGUAGE_XML_TYPE_STR}</td><td>{@link String} constrained to language</td></tr>
	 * <tr><td>{@value #NMTOKEN_OWL_TYPE_STR}</td><td>{@value #NMTOKEN_XML_TYPE_STR}</td><td>{@link String} constrained to NMTOKEN</td></tr>
	 * <tr><td>{@value #NAME_OWL_TYPE_STR}</td><td>{@value #NAME_XML_TYPE_STR}</td><td>{@link String} constrained to Name</td></tr>
	 * <tr><td>{@value #NCNAME_OWL_TYPE_STR}</td><td>{@value #NCNAME_XML_TYPE_STR}</td><td>{@link String} constrained to NCName</td></tr>
	 * </table>
	 * @throws IdASException
	 */
	public Object getData() throws IdASException;
	
	/**
	 * Sets the data for this simple value.
	 * This is typically called after calling {@link IAttribute#addValue(URI)}
	 * but may be called at any time.
	 * Note: This operation is only applied to any backing data store after
	 * {@link IContext#applyUpdates()} is called.
	 * Subsequent modifications made to the data Object have no effect on this 
	 * simple type's value.  In other words, the Context Provider ensures 
	 * immutable behavior.<p>
	 * @param data The data of the attribute value
	 * @throws {@link IdASException}
	 */
	void setData(Object data) throws IdASException;
	
}
