/*******************************************************************************
 * Copyright (c) 2006 Novell, Inc..
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Jim Sermersheim - Initial cut as agreed upon 20060811
 *******************************************************************************/
package org.eclipse.higgins.idas.api;

/**
 * Thrown when methods requiring an open Context are called on a non-open Context.
 */
public class ContextNotOpenException extends IdASException {

	/**
	 * 
	 */
	private static final long serialVersionUID = 8373397892052449596L;

	/**
	 * @see IdASException#IdASException()
	 */
	public ContextNotOpenException() {
		super();
	}

	/**
	 * @param message
	 * @see IdASException#IdASException(String)
	 */
	public ContextNotOpenException(String message) {
		super(message);
	}

	/**
	 * @param message
	 * @param cause
	 * @see IdASException#IdASException(String, Throwable)
	 */
	public ContextNotOpenException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * @param cause
	 * @see IdASException#IdASException(String, Throwable)
	 */
	public ContextNotOpenException(Throwable cause) {
		super(cause);
	}

}
